/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;

public class VideoUnitDrawable
extends Drawable {
    private Paint mPaint = new Paint(1);
    private RectF mRectF = new RectF();
    private Path mPath = new Path();
    private int mWidth;
    private int mHeight;
    private float mDefaultBgRadius;

    public VideoUnitDrawable() {
        this.mPaint.setDither(true);
    }

    public void draw(Canvas canvas) {
        this.mPaint.setColor(Color.parseColor((String)"#7297A3"));
        this.mPaint.setShader(null);
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight, this.mDefaultBgRadius, this.mDefaultBgRadius, this.mPaint);
            this.mPaint.setColor(Color.parseColor((String)"#90C3D4"));
            canvas.drawRoundRect(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight - 0.05f * (float)this.mHeight, this.mDefaultBgRadius, this.mDefaultBgRadius, this.mPaint);
        } else {
            canvas.drawRoundRect(this.mRectF, this.mDefaultBgRadius, this.mDefaultBgRadius, this.mPaint);
            this.mPaint.setColor(Color.parseColor((String)"#90C3D4"));
            this.mRectF.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight - 0.05f * (float)this.mHeight);
            canvas.drawRoundRect(this.mRectF, this.mDefaultBgRadius, this.mDefaultBgRadius, this.mPaint);
            this.mRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
            this.mRectF.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
        }
        this.mPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.mHeight, Color.parseColor((String)"#614C45"), Color.parseColor((String)"#FAC7B6"), Shader.TileMode.CLAMP));
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPaint.setShader(null);
        this.mPaint.setColor(Color.parseColor((String)"#362A25"));
        this.mPaint.setTextSize(0.12f * (float)this.mWidth);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        canvas.drawText("KIDOZ TV", (float)this.mWidth / 2.0f, (float)this.mHeight - 0.1f * (float)this.mHeight, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mWidth = bounds.width();
        this.mHeight = bounds.height();
        this.mRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
        this.mDefaultBgRadius = 0.1f * (float)this.mWidth;
        this.mPath = new Path();
        this.mPath.setFillType(Path.FillType.EVEN_ODD);
        this.mPath.moveTo((float)this.mWidth / 4.0f, ((float)this.mHeight - 0.05f * (float)this.mHeight) / 4.0f);
        this.mPath.lineTo((float)this.mWidth / 4.0f, (float)this.mHeight - (float)this.mHeight / 4.0f);
        this.mPath.lineTo((float)this.mWidth - (float)this.mWidth / 4.0f, (float)this.mHeight / 2.0f);
        this.mPath.close();
    }
}

