/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

public class ShadowView
extends View {
    private Paint mPaint;
    private RectF mRectF;
    private float mCornerRadius;
    private PANEL_TYPE mPanelType;
    private HANDLE_POSITION mHandePosition;

    public ShadowView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        int blurValue = Utils.dpTOpx(this.getContext(), 3.0f);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(Color.parseColor((String)"#000000"));
        this.mPaint.setMaskFilter((MaskFilter)new BlurMaskFilter((float)blurValue, BlurMaskFilter.Blur.NORMAL));
        this.mCornerRadius = Utils.dpTOpx(this.getContext(), 4.0f);
        this.setLayerType(1, this.mPaint);
    }

    private void prepareView() {
        int horizontalSpacing = Utils.dpTOpx(this.getContext(), 13.0f);
        int verticalSpacing = Utils.dpTOpx(this.getContext(), 11.0f);
        this.mRectF = new RectF();
        block0 : switch (this.mPanelType) {
            case TOP: {
                switch (this.mHandePosition) {
                    case CENTER: {
                        this.mRectF.set((float)horizontalSpacing, (float)(-verticalSpacing), (float)(this.getWidth() - horizontalSpacing), (float)(this.getHeight() - verticalSpacing));
                        break block0;
                    }
                    case END: {
                        this.mRectF.set((float)horizontalSpacing, (float)(-verticalSpacing), (float)(this.getWidth() + horizontalSpacing), (float)(this.getHeight() - verticalSpacing));
                        break block0;
                    }
                }
                this.mRectF.set((float)(-horizontalSpacing), (float)(-verticalSpacing), (float)(this.getWidth() - horizontalSpacing), (float)(this.getHeight() - verticalSpacing));
                break;
            }
            default: {
                switch (this.mHandePosition) {
                    case CENTER: {
                        this.mRectF.set((float)horizontalSpacing, (float)verticalSpacing, (float)(this.getWidth() - horizontalSpacing), (float)(this.getHeight() + verticalSpacing));
                        break block0;
                    }
                    case END: {
                        this.mRectF.set((float)horizontalSpacing, (float)verticalSpacing, (float)(this.getWidth() + horizontalSpacing), (float)(this.getHeight() + verticalSpacing));
                        break block0;
                    }
                }
                this.mRectF.set((float)(-horizontalSpacing), (float)verticalSpacing, (float)(this.getWidth() - horizontalSpacing), (float)(this.getHeight() + verticalSpacing));
            }
        }
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.prepareView();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawRoundRect(this.mRectF, this.mCornerRadius, this.mCornerRadius, this.mPaint);
    }

    public void setConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handePosition) {
        this.mPanelType = panelType;
        this.mHandePosition = handePosition;
        this.prepareView();
        this.postInvalidate();
    }
}

