/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.web_view_clients.KidozFullScreenVideoEnabled_No_Progress_WebChromeClient;

public class WebPlayerView
extends RelativeLayout {
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.35f;
    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;
    private LoadingProgressView mLoadingProgressView;
    private Window mWindow;
    private RelativeLayout mNonVideoLayout;
    private boolean mUseNativeTopBar = true;
    private ContentItem mContentItem;

    public WebPlayerView(Window window, Context context, WebPlayerType webPlayerType, boolean useNativeTopBar) {
        super(context);
        this.mWindow = window;
        this.mWebPlayerType = webPlayerType;
        this.mUseNativeTopBar = useNativeTopBar;
        this.initiateView();
    }

    private void initiateView() {
        this.initLayout();
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
            this.mKidozWebView.setAlpha(0.0f);
            this.mLoadingProgressView = new LoadingProgressView(this.getContext());
            Point point = Utils.getScreenSize(this.getContext());
            int size = (int)((float)Math.min(point.x, point.y) * 0.35f);
            RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
            this.mLoadingProgressView.setCircleWidthRelativeToSize(size);
            prParams.addRule(13);
            this.addView(this.mLoadingProgressView, (ViewGroup.LayoutParams)prParams);
            this.mLoadingProgressView.startLoadingAnimation();
        }
    }

    public void setFullScreenWebChromeClient(ViewGroup viewGroup) {
        KidozFullScreenVideoEnabled_No_Progress_WebChromeClient webChromeClient = new KidozFullScreenVideoEnabled_No_Progress_WebChromeClient((View)this.mNonVideoLayout, viewGroup, null, this.mKidozWebView, this.mWindow);
        this.mKidozWebView.setWebChromeClient(webChromeClient);
    }

    private void initLayout() {
        this.mNonVideoLayout = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        if (this.mWebPlayerType != null && this.mWebPlayerType != WebPlayerType.ROVIO || this.mUseNativeTopBar) {
            Point point = Utils.getScreenSize(this.getContext());
            params.topMargin = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        }
        this.mNonVideoLayout.setId(Utils.generateViewId());
        this.addView((View)this.mNonVideoLayout, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-1, -1);
        this.mKidozWebView = new KidozWebView(this.getContext(), this.mWebPlayerType);
        this.mKidozWebView.setId(Utils.generateViewId());
        this.mNonVideoLayout.addView((View)this.mKidozWebView, (ViewGroup.LayoutParams)params);
        this.mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener(){

            @Override
            public void onLounch() {
                if (WebPlayerView.this.mRemoveViewRequestListener != null) {
                    WebPlayerView.this.mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void loadWebUrlWithAllowedDomains(String[] allowedDomains, String url, String googlePlayAppId) {
        this.mKidozWebView.loadWebUrl(allowedDomains, url, googlePlayAppId);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopLoading();
        }
    }

    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener) {
        this.mRemoveViewRequestListener = listener;
    }

    public void releaseAndcloseView() {
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopAndReleaseWebView();
        }
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.stopLoadingAnimation();
        }
    }

    public KidozWebView getKidozWebView() {
        return this.mKidozWebView;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int size = (int)((float)Math.min(w, h) * 0.35f);
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.getLayoutParams().height = size;
            this.mLoadingProgressView.getLayoutParams().width = size;
            this.mLoadingProgressView.setCircleWidthRelativeToSize(size);
        }
    }

    public void setContentItem(ContentItem contentItem) {
        this.mContentItem = contentItem;
        if (this.mKidozWebView != null) {
            this.mKidozWebView.setContentItem(this.mContentItem);
        }
    }

    public static interface IOnRemoveViewRequestListener {
        public void onRemoveView();
    }
}

