/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.video_unit;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.KidozUrl;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.video_unit.RedirectManager;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnit;
import com.kidoz.sdk.api.ui_views.web_view_clients.KidozFullScreenVideoEnabledWebChromeClient;
import java.lang.ref.WeakReference;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class VideoUnitActivity
extends Activity {
    public static final String VIDEO_UNIT_ACTION_BUTTON_TAG = "VIDEO_UNIT_ACTION_BUTTON_TAG";
    public static final String VIDEO_UNIT_URL_TAG = "VIDEO_UNIT_URL_TAG";
    private final String TAG = VideoUnitActivity.class.getSimpleName();
    public static FullScreenVideoEnabledWebView mWebView;
    public static VideoUnit.VideoUnitListener sVideoUnitListener;
    private static RelativeLayout sLoadingViewContainer;
    private static LoadingProgressView sLoadingProgressView;
    private boolean mIsAlreadyLoaded = false;
    private int mDeviceOrientation;
    private RedirectManager mRedirectManager;

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        try {
            this.mDeviceOrientation = this.getRequestedOrientation();
            this.initActivity();
            if (mWebView != null) {
                this.invokeJavaScript("javascript:onWidgetOpen();");
                if (sVideoUnitListener != null && sVideoUnitListener != null) {
                    sVideoUnitListener.onOpen();
                }
            } else {
                this.finish();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Exception = " + ex);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            this.invokeJavaScript("javascript:onWidgetClose();");
            if (sVideoUnitListener != null && sVideoUnitListener != null) {
                sVideoUnitListener.onClose();
            }
            mWebView = null;
            sVideoUnitListener = null;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Exception = " + ex);
        }
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    protected void onStop() {
        super.onStop();
        this.setRequestedOrientation(this.mDeviceOrientation);
        this.mRedirectManager.stopRedirectHandler();
    }

    protected void onResume() {
        super.onResume();
        try {
            this.initFullScreenFlags();
            if (mWebView.getParent() != null) {
                mWebView.getParent().requestLayout();
            }
            this.invokeJavaScript("javascript:onWidgetResume();");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Exception = " + ex);
        }
    }

    protected void onPause() {
        super.onPause();
        try {
            this.invokeJavaScript("javascript:onWidgetPause();");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Exception = " + ex);
        }
    }

    private void initActivity() {
        if (this.getIntent() != null) {
            this.mIsAlreadyLoaded = this.getIntent().getBooleanExtra("isLoaded", false);
        }
        this.initFullScreenFlags();
        this.initWebView();
        this.initRedirectManager();
        this.initLoadingProgressView();
    }

    private void initLoadingProgressView() {
        sLoadingViewContainer = new RelativeLayout((Context)this);
        sLoadingViewContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        sLoadingViewContainer.setBackgroundColor(Color.parseColor((String)"#80000000"));
        sLoadingProgressView = new LoadingProgressView((Context)this);
        sLoadingProgressView.setCircleColor(Color.parseColor((String)"#289E9E"));
        Point point = Utils.getScreenSize((Context)this);
        int size = (int)((double)Math.min(point.x, point.y) * 0.35);
        sLoadingProgressView.setCircleWidthRelativeToSize(size);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(13);
        sLoadingViewContainer.addView((View)sLoadingProgressView, (ViewGroup.LayoutParams)params);
        ((ViewGroup)mWebView.getParent()).addView((View)sLoadingViewContainer, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.toggleLoadingView(false);
    }

    private void initRedirectManager() {
        this.mRedirectManager = new RedirectManager((Context)this);
        this.mRedirectManager.setRedirectManagerListener(new RedirectManager.RedirectManagerListener(){

            @Override
            public void onRedirectStarted() {
                VideoUnitActivity.this.toggleLoadingView(true);
            }

            @Override
            public void onRedirectEnd(boolean isError) {
                VideoUnitActivity.this.toggleLoadingView(false);
            }
        });
    }

    private void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int itemIndexAsInteger = 0;
                try {
                    itemIndexAsInteger = Integer.parseInt(itemIndex);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(VideoUnitActivity.this.TAG, "Error when trying to parse item index: " + ex.getMessage());
                }
                ContentItem contentItem = new ContentItem();
                contentItem.setId(appID);
                contentItem.setName("");
                contentItem.setData(googlePlayLink);
                contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                contentItem.setAdvertiserID(advertiserID);
                contentItem.setIsPromoted(true);
                ContentExecutionHandler.handleContentItemClick((Context)VideoUnitActivity.this, contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
            }
        });
    }

    private void initWebView() {
        if (mWebView != null) {
            if (mWebView.getParent() != null) {
                ((ViewGroup)mWebView.getParent()).removeAllViews();
            }
            if (Build.VERSION.SDK_INT >= 19) {
                FullScreenVideoEnabledWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
            }
            this.setContentView((View)mWebView, new ViewGroup.LayoutParams(-1, -1));
        }
        if (!this.mIsAlreadyLoaded) {
            this.initWebViewSettings();
            VideoUnit.misLoaded = true;
        }
    }

    private void initWebViewSettings() {
        PropertiesObj propertiesObj;
        if (mWebView != null) {
            mWebView.initWebViewSettings();
            mWebView.addJavascriptInterface(new VideoUnitJavascriptInterface(), "VideoUnit");
        }
        if ((propertiesObj = DatabaseManager.getInstance((Context)this).getConfigTable().loadAppProperties()) != null) {
            String videoUnitURL = propertiesObj.getVideoUnitURL();
            VideoUnitActivity context = this;
            Point screenSize = ScreenUtils.getScreenSize((Context)context);
            String mainUrl = videoUnitURL;
            mainUrl = !mainUrl.contains("?") ? mainUrl + "?" : mainUrl + "&";
            KidozUrl.Builder kidozUrlBuilder = new KidozUrl.Builder(mainUrl);
            kidozUrlBuilder.setPublisherId(KidozSDK.getPublisherID()).setAuthToken(KidozSDK.getAuthToken()).setPackageId(context.getPackageName()).setSdkVersion("4").setActualSdkVersion("0.8.2.1").setOsVersion(Build.VERSION.SDK_INT).setOsType("android").setExtensionType(ConstantDef.SDK_EXTENSION_TYPE).setAppVersionCode(Utils.getAppVersionCode((Context)context)).setAppVersionName(Utils.getAppVersionName((Context)context)).setDeviceType(Utils.getDeviceType((Context)context)).setDeviceLang(Locale.getDefault().getLanguage()).setDeviceHash(Utils.generateUniqeDeviceID(context.getPackageName(), KidozSDK.getPublisherID())).setGid(SdkDeviceUtils.getGoogleAdvertisingID((Context)context)).setManufacturer(Build.MANUFACTURER).setModel(Build.MODEL).setWebviewVersion(Utils.getWebViewVersion()).setScreenSize(ScreenUtils.getDeviceScreenSizeInInches((Context)context)).setDpi(ScreenUtils.getScreenDpi((Context)context)).setScreenCategory(ScreenUtils.getScreenCategory((Context)context)).setWifiMode(Utils.getWifiOn((Context)context)).setCarrierName(Utils.getCarrierName((Context)context)).setNetworkType(Utils.getNetworkType((Context)context)).setResolutionHeight(screenSize.y).setResolutionWidth(screenSize.x);
            kidozUrlBuilder.setWidgetType(WidgetType.WIDGET_TYPE_VIDEO_UNIT.getStringValue()).setStyleId(0).setAppSessionId(Utils.getAppSessionId(this));
            if (mWebView != null) {
                mWebView.setWebViewClient(new WebViewClient(){

                    public boolean shouldOverrideUrlLoading(WebView view, String url) {
                        SDKLogger.printDebugLog(VideoUnitActivity.this.TAG, "shouldOverrideUrlLoading: URL = " + url);
                        VideoUnitActivity.this.mRedirectManager.loadURL(url);
                        return true;
                    }

                    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                        VideoUnitActivity.this.toggleLoadingView(false);
                        EventManager.getInstance((Context)VideoUnitActivity.this).logEvent((Context)VideoUnitActivity.this, WidgetType.WIDGET_TYPE_VIDEO_UNIT.getStringValue(), "0", EventManager.LOG_CRITICAL_LEVEL, "WebView Error", String.valueOf(errorCode).concat(": ").concat(description), failingUrl);
                    }
                });
                KidozFullScreenVideoEnabledWebChromeClient kidozFSwebChromeClient = new KidozFullScreenVideoEnabledWebChromeClient(mWebView);
                mWebView.setWebChromeClient(kidozFSwebChromeClient);
                KidozUrl kidozUrl = kidozUrlBuilder.build();
                mWebView.loadUrl(kidozUrl.toString());
            }
        }
    }

    private void initFullScreenFlags() {
        if (Build.VERSION.SDK_INT < 16) {
            this.getWindow().setFlags(1024, 1024);
        } else if (Build.VERSION.SDK_INT < 18) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 4;
            decorView.setSystemUiVisibility(uiOptions);
        } else {
            final View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
            decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if ((visibility & 4) == 0) {
                        decorView.setSystemUiVisibility(5894);
                    }
                }
            });
        }
    }

    private void invokeJavaScript(final String javascript) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (mWebView != null) {
                    try {
                        if (Build.VERSION.SDK_INT >= 19) {
                            mWebView.evaluateJavascript(javascript, null);
                        } else {
                            mWebView.loadUrl(javascript);
                        }
                    }
                    catch (Exception ex) {
                        mWebView.loadUrl(javascript);
                    }
                }
            }
        });
    }

    public static void parseVideoUnitStyle(final Context context, final JSONObject json) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                VideoUnitParserAsyncTask asyncTask = new VideoUnitParserAsyncTask(context, json);
                if (Build.VERSION.SDK_INT < 11) {
                    asyncTask.execute(new EventBulk[0]);
                } else {
                    asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new EventBulk[0]);
                }
            }
        }).start();
    }

    private void toggleLoadingView(boolean isNeedToShow) {
        if (isNeedToShow) {
            sLoadingProgressView.startLoadingAnimation();
            sLoadingViewContainer.setVisibility(0);
        } else {
            sLoadingProgressView.stopLoadingAnimation();
            sLoadingViewContainer.setVisibility(4);
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.WEB_PLAYER_DIALOG_CLOSED) {
            if (mWebView.getParent() != null) {
                mWebView.getParent().requestLayout();
            }
            this.invokeJavaScript("javascript:onWidgetResume();");
        } else if (event.getMessageType() == EventMessage.MessageType.CLOSE_VIDEO_UNIT) {
            this.finish();
        }
    }

    public static class VideoUnitParserAsyncTask
    extends AsyncTask<EventBulk, Void, Boolean> {
        WeakReference<Context> weakActivity = null;
        JSONObject mJsonObject;

        public VideoUnitParserAsyncTask(Context context, JSONObject json) {
            this.weakActivity = new WeakReference<Context>(context);
            this.mJsonObject = json;
        }

        protected Boolean doInBackground(EventBulk ... params) {
            boolean isNeedRefresh = false;
            String actionButtonURL = null;
            if (this.mJsonObject != null) {
                try {
                    JSONObject videoUnitStyle = this.mJsonObject.getJSONObject("videoUnitStyle");
                    JSONObject videoUnit = videoUnitStyle.getJSONObject("videoUnit");
                    actionButtonURL = videoUnit.getString("action_button_url");
                }
                catch (Exception videoUnitStyle) {
                    // empty catch block
                }
                if (actionButtonURL != null) {
                    boolean isNeedUpdate = false;
                    JSONObject jsonObject = DatabaseManager.getInstance((Context)this.weakActivity.get()).getConfigTable().loadProperties(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG);
                    if (jsonObject != null) {
                        try {
                            String oldActionButtonURL = jsonObject.getString(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG);
                            if (oldActionButtonURL != null && !oldActionButtonURL.equals(actionButtonURL)) {
                                isNeedUpdate = true;
                                AssetUtil.deleteAssetFile2((Context)this.weakActivity.get(), oldActionButtonURL);
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        isNeedUpdate = true;
                        isNeedRefresh = true;
                    }
                    if (isNeedUpdate) {
                        AssetUtil.createAssetFile2((Context)this.weakActivity.get(), actionButtonURL);
                        jsonObject = new JSONObject();
                        try {
                            jsonObject.put(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG, (Object)actionButtonURL);
                            DatabaseManager.getInstance((Context)this.weakActivity.get()).getConfigTable().insertProperties(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG, jsonObject);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.weakActivity != null) {
                this.weakActivity.clear();
            }
            return isNeedRefresh;
        }

        protected void onPostExecute(Boolean needTofresh) {
            super.onPostExecute((Object)needTofresh);
            if (needTofresh.booleanValue()) {
                EventMessage widgetEventMessage = new EventMessage(EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY);
                EventBus.getDefault().post((Object)widgetEventMessage);
            }
        }
    }

    public class VideoUnitJavascriptInterface {
        @JavascriptInterface
        public void onVideoUnitReady() {
        }

        @JavascriptInterface
        public void onCloseVideoUnit() {
            VideoUnitActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EventMessage widgetEventMessage = new EventMessage(EventMessage.MessageType.CLOSE_VIDEO_UNIT);
                    EventBus.getDefault().post((Object)widgetEventMessage);
                }
            });
        }

        @JavascriptInterface
        public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
            VideoUnitActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VideoUnitActivity.this.forwardToGooglePlay(advertiserID, appID, googlePlayLink, widgetType, styleID, itemIndex);
                }
            });
        }

        @JavascriptInterface
        public void setOrientation(final int orientation) {
            VideoUnitActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VideoUnitActivity.this.setRequestedOrientation(orientation);
                }
            });
        }

        @JavascriptInterface
        public void sendItemDetailsToClient(final String itemDetailsJson) {
            VideoUnitActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VideoUnitActivity.this.mRedirectManager.setItemDetails(itemDetailsJson);
                }
            });
        }
    }
}

