/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.platforms;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class KidozPopupWindow {
    private static final String TAG = KidozPopupWindow.class.getSimpleName();
    private static final int WINDOW_BACKGROUND_COLOR = -573572390;
    private PopupWindow mPopupWindow;
    private FrameLayout mPopupContainer;
    private FrameLayout mContentView;
    private FrameLayout mDragLayout;
    private Activity mActivity;
    private int mGravity = 0;
    private int mOffsetX = 0;
    private int mOffsetY = 0;
    private int mPosX = 0;
    private int mPosY = 0;

    public KidozPopupWindow(Activity activity, int width, int height) {
        this.mActivity = activity;
        this.createContentView();
        this.createDragLayout();
        this.createPopupContainer();
        this.layoutContainer();
        this.createPopupWindow(width, height);
    }

    public void addView(final View view) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                KidozPopupWindow.this.mContentView.addView(view);
            }
        });
    }

    public void show() {
        if (this.mActivity != null) {
            this.mActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    KidozPopupWindow.this.mPopupWindow.showAtLocation(KidozPopupWindow.this.mActivity.getWindow().getDecorView().getRootView(), KidozPopupWindow.this.mGravity, KidozPopupWindow.this.mPosX + KidozPopupWindow.this.mOffsetX, KidozPopupWindow.this.mPosY + KidozPopupWindow.this.mOffsetY);
                }
            });
        }
    }

    public void hide() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                KidozPopupWindow.this.mPopupContainer.setVisibility(8);
                KidozPopupWindow.this.mPopupWindow.dismiss();
            }
        });
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public void setOffset(int x, int y) {
        this.mOffsetX = x;
        this.mOffsetY = y;
    }

    public void setDraggable(boolean dragable) {
        if (!dragable) {
            return;
        }
        this.mDragLayout.setOnTouchListener(new View.OnTouchListener(){
            private float startX;
            private float startY;

            public boolean onTouch(View v, MotionEvent motionEvent) {
                switch (motionEvent.getAction()) {
                    case 0: {
                        this.startX = (float)KidozPopupWindow.this.mPosX - motionEvent.getRawX();
                        this.startY = (float)KidozPopupWindow.this.mPosY - motionEvent.getRawY();
                        break;
                    }
                    case 2: {
                        KidozPopupWindow.this.mPosX = (int)(motionEvent.getRawX() + this.startX);
                        KidozPopupWindow.this.mPosY = (int)(motionEvent.getRawY() + this.startY);
                        KidozPopupWindow.this.mPopupWindow.update(KidozPopupWindow.this.mPosX, KidozPopupWindow.this.mPosY, -1, -1);
                    }
                }
                KidozPopupWindow.this.mContentView.dispatchTouchEvent(motionEvent);
                return true;
            }
        });
    }

    public void forceWrap() {
        this.mPopupWindow.update(this.mPosX, this.mPosY, -2, -2);
    }

    private void createContentView() {
        this.mContentView = new FrameLayout((Context)this.mActivity);
        FrameLayout.LayoutParams viewLPs = new FrameLayout.LayoutParams(-1, -1);
        this.mContentView.setLayoutParams((ViewGroup.LayoutParams)viewLPs);
        this.mContentView.setBackgroundColor(-573572390);
    }

    private void createDragLayout() {
        this.mDragLayout = new FrameLayout((Context)this.mActivity);
        FrameLayout.LayoutParams viewLPs = new FrameLayout.LayoutParams(-1, -1);
        this.mDragLayout.setLayoutParams((ViewGroup.LayoutParams)viewLPs);
    }

    private void createPopupContainer() {
        this.mPopupContainer = new FrameLayout((Context)this.mActivity);
    }

    private void layoutContainer() {
        this.mPopupContainer.addView((View)this.mContentView);
        this.mPopupContainer.addView((View)this.mDragLayout);
    }

    private void createPopupWindow(int width, int height) {
        this.mPopupWindow = new PopupWindow((View)this.mPopupContainer, width, height);
        int visibilityFlags = this.mActivity.getWindow().getAttributes().flags;
        this.mPopupWindow.getContentView().setSystemUiVisibility(visibilityFlags);
        this.setPopUpWindowLayoutType(this.mPopupWindow, 1002);
    }

    private void setPopUpWindowLayoutType(PopupWindow popupWindow, int layoutType) {
        try {
            Method method = PopupWindow.class.getDeclaredMethod("setWindowLayoutType", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)popupWindow, layoutType);
        }
        catch (NoSuchMethodException exception) {
            Log.w((String)TAG, (String)String.format("Unable to set popUpWindow window layout type: %s", exception.getLocalizedMessage()));
        }
        catch (IllegalAccessException exception) {
            Log.w((String)TAG, (String)String.format("Unable to set popUpWindow window layout type: %s", exception.getLocalizedMessage()));
        }
        catch (InvocationTargetException exception) {
            Log.d((String)TAG, (String)String.format("Unable to set popUpWindow window layout type: %s", exception.getLocalizedMessage()));
        }
    }
}

