/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.gif.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.Log;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.gif.decoder.GifDecoder;
import java.io.InputStream;
import java.util.UUID;

public class GifDecoderView
extends ImageView {
    private static final int BACKGROUND_COLOR = 0;
    private GifDecoder mGifDecoder;
    private Handler mHandler;
    private Runnable mUpdateResults;
    private Bitmap mTmpBitmap;
    private AnimationThread mLastAnimationThread;
    private boolean mIsPaused = false;

    public GifDecoderView(Context context, InputStream stream) {
        super(context);
        Log.d((String)"ahmed", (String)"GifDecoderView | create");
        this.setBackgroundColor(0);
        this.initGifDecoder(stream);
        this.initUiUpdateMechanism();
    }

    private void initUiUpdateMechanism() {
        this.mHandler = new Handler();
        this.mUpdateResults = new Runnable(){

            @Override
            public void run() {
                if (GifDecoderView.this.mTmpBitmap != null && !GifDecoderView.this.mTmpBitmap.isRecycled()) {
                    GifDecoderView.this.setImageBitmap(GifDecoderView.this.mTmpBitmap);
                }
            }
        };
    }

    private void initGifDecoder(InputStream stream) {
        this.mGifDecoder = new GifDecoder();
        this.mGifDecoder.read(stream);
    }

    public synchronized void start() {
        if (this.mLastAnimationThread != null) {
            this.mLastAnimationThread.requestStop();
        }
        this.mLastAnimationThread = new AnimationThread();
        this.mLastAnimationThread.start();
    }

    public synchronized void stop() {
        if (this.mLastAnimationThread != null) {
            this.mLastAnimationThread.requestStop();
        }
    }

    public synchronized void pause() {
        Log.d((String)"ahmed", (String)"GifDecoderView | pause");
        this.mIsPaused = true;
    }

    public synchronized void resume() {
        Log.d((String)"ahmed", (String)"GifDecoderView | resume");
        this.mIsPaused = false;
    }

    public synchronized void clean() {
        Log.d((String)"ahmed", (String)"GifDecoderView | clean");
        if (this.mLastAnimationThread != null) {
            this.mLastAnimationThread.requestStop();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mUpdateResults);
        }
        if (this.mTmpBitmap != null) {
            this.mTmpBitmap.recycle();
        }
    }

    public synchronized boolean isPlaying() {
        return !this.mLastAnimationThread.mRequestStop;
    }

    public synchronized boolean isVisible() {
        return this.getVisibility() == 0;
    }

    class AnimationThread
    extends Thread {
        private boolean mRequestStop;

        public AnimationThread() {
            super(new Runnable(){

                @Override
                public void run() {
                    int n = GifDecoderView.this.mGifDecoder.getFrameCount();
                    int ntimes = GifDecoderView.this.mGifDecoder.getLoopCount();
                    int repetitionCounter = 0;
                    String mThreadInstanceId = UUID.randomUUID().toString();
                    do {
                        if (GifDecoderView.this.mIsPaused) continue;
                        for (int i = 0; i < n; ++i) {
                            GifDecoderView.this.mTmpBitmap = GifDecoderView.this.mGifDecoder.getFrame(i);
                            int t = GifDecoderView.this.mGifDecoder.getDelay(i);
                            GifDecoderView.this.mHandler.post(GifDecoderView.this.mUpdateResults);
                            try {
                                Thread.sleep(t);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Log.d((String)"ahmed", (String)("GifDecoderView | exception " + e.getLocalizedMessage()));
                                SDKLogger.printErrorLog(e.getLocalizedMessage());
                            }
                        }
                        if (ntimes == 0) continue;
                        ++repetitionCounter;
                    } while (!((AnimationThread)Thread.currentThread()).mRequestStop && repetitionCounter <= ntimes);
                }
            });
            this.mRequestStop = false;
        }

        public void requestStop() {
            this.mRequestStop = true;
        }
    }
}

