/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Build;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.util.HashMap;

@SuppressLint(value={"NewApi"})
public class SdkSoundManager {
    private static String TAG = SdkSoundManager.class.getSimpleName();
    private static SoundPool sSoundPool;
    private static HashMap<String, Integer> sLoadedSounds;

    @SuppressLint(value={"NewApi"})
    private static void initSoundPool() {
        if (sSoundPool == null) {
            if (Build.VERSION.SDK_INT >= 21) {
                SoundPool.Builder builder = new SoundPool.Builder();
                builder.setMaxStreams(3);
                AudioAttributes.Builder atrBuilder = new AudioAttributes.Builder();
                atrBuilder.setContentType(4);
                atrBuilder.setLegacyStreamType(4);
                atrBuilder.setUsage(1);
                builder.setAudioAttributes(atrBuilder.build());
                sSoundPool = builder.build();
            } else {
                sSoundPool = new SoundPool(3, 3, 0);
            }
        }
    }

    private static void playLoadedSound(Context context, int sound) {
        SdkSoundManager.initSoundPool();
        if (context != null) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            float actualVolume = audioManager.getStreamVolume(3);
            float maxVolume = audioManager.getStreamMaxVolume(3);
            float volume = actualVolume / maxVolume;
            sSoundPool.play(sound, volume, volume, 1, 0, 1.0f);
        }
    }

    public static void preloadSound(Context context, int soundResource) {
        SdkSoundManager.initSoundPool();
        if (context != null && sLoadedSounds != null && sLoadedSounds.get(soundResource + "") == null) {
            int soundID = sSoundPool.load(context, soundResource, 1);
            sLoadedSounds.put(soundResource + "", soundID);
        }
    }

    public static void preloadSound(String path) {
        SDKLogger.printDebugLog(TAG, "*** preloadSound");
        SdkSoundManager.initSoundPool();
        if (path != null && sLoadedSounds != null && sLoadedSounds.get(path) == null) {
            int soundID = sSoundPool.load(path, 1);
            sLoadedSounds.put(path, soundID);
            SDKLogger.printDebugLog(TAG, "preloadSound: path = " + path + ", soundID = " + String.valueOf(soundID));
        }
    }

    public static void playSound(Context context, int soundResource) {
        SdkSoundManager.initSoundPool();
        if (context != null && sLoadedSounds != null && sLoadedSounds.get(soundResource + "") == null) {
            int soundID = sSoundPool.load(context, soundResource, 1);
            sLoadedSounds.put(soundResource + "", soundID);
            SdkSoundManager.playLoadedSound(context, soundID);
        } else if (sLoadedSounds != null) {
            SdkSoundManager.playLoadedSound(context, sLoadedSounds.get("" + soundResource));
        }
    }

    public static void playSound(Context context, String path) {
        SDKLogger.printDebugLog(TAG, "*** playSound");
        SdkSoundManager.initSoundPool();
        if (context != null && path != null && sSoundPool != null) {
            if (sLoadedSounds != null && sLoadedSounds.get(path) == null) {
                int soundID = sSoundPool.load(path, 1);
                sLoadedSounds.put(path, soundID);
                SdkSoundManager.playLoadedSound(context, soundID);
                SDKLogger.printDebugLog(TAG, "playSound: path = " + path + ", soundID = " + String.valueOf(soundID));
            } else if (sLoadedSounds != null) {
                SdkSoundManager.playLoadedSound(context, sLoadedSounds.get(path));
                SDKLogger.printDebugLog(TAG, "playSound: path = " + path + ", soundID = " + String.valueOf(sLoadedSounds.get(path)));
            }
        }
    }

    public static void releaseManager() {
        if (sSoundPool != null) {
            sSoundPool.release();
        }
        sSoundPool = null;
        if (sLoadedSounds != null) {
            sLoadedSounds.clear();
        }
    }

    static {
        sLoadedSounds = new HashMap();
    }
}

