/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.kidoz.sdk.api.general.database.ConfigurationTable;
import com.kidoz.sdk.api.general.database.IsEventTable;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class DatabaseManager
extends SQLiteOpenHelper {
    private static final String TAG = DatabaseManager.class.getSimpleName();
    public static final String DATABASE_NAME = "KIDOZ_SDK_DATATBASE_1";
    private static final int DATABASE_VERSION = 1;
    private IsEventTable mIsEventTable;
    private ConfigurationTable mConfigurationTable;
    protected final Object mSyncObject = new Object();
    private int mOpenCounter;
    private SQLiteDatabase mDatabase;
    private static DatabaseManager mDatabaseManager;

    public DatabaseManager(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.initDatabase();
    }

    private void initDatabase() {
        this.mIsEventTable = new IsEventTable(this, this.mSyncObject);
        this.mConfigurationTable = new ConfigurationTable(this, this.mSyncObject);
    }

    public void onCreate(SQLiteDatabase db) {
        IsEventTable.onCreate(db);
        ConfigurationTable.onCreate(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        IsEventTable.onUpgrade(db, oldVersion, newVersion);
        ConfigurationTable.onUpgrade(db, oldVersion, newVersion);
    }

    public IsEventTable getIsEventTable() {
        return this.mIsEventTable;
    }

    public ConfigurationTable getConfigTable() {
        return this.mConfigurationTable;
    }

    public synchronized SQLiteDatabase handleDatabase(boolean open) {
        if (open) {
            ++this.mOpenCounter;
            if (this.mOpenCounter == 1) {
                try {
                    this.mDatabase = this.getWritableDatabase();
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to open database: " + ex.getMessage());
                }
            }
        } else {
            if (this.mOpenCounter > 0) {
                --this.mOpenCounter;
            }
            if (this.mOpenCounter == 0) {
                try {
                    if (this.mDatabase != null) {
                        this.mDatabase.close();
                    }
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to close database: " + ex.getMessage());
                }
            }
        }
        return this.mDatabase;
    }

    public static DatabaseManager getInstance(Context context) {
        if (mDatabaseManager == null) {
            mDatabaseManager = new DatabaseManager(context);
        }
        return mDatabaseManager;
    }
}

