/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.UniquePlacement;

import android.text.TextUtils;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.UniquePlacement.UniqueInterstitialListener;
import com.kidoz.sdk.api.general.UniquePlacement.UniquePlacementId;
import com.kidoz.sdk.api.ui_views.interstitial.BaseInterstitial;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class UniquePlacementHelper {
    private UniquePlacementId mUniquePlacementId = new UniquePlacementId();
    private UniqueInterstitialListener mUniqueInterstitialListener;
    private BaseInterstitial.IOnInterstitialEventListener mExternalInterstitialListener;
    private BaseInterstitial.IOnInterstitialRewardedEventListener mExternalRewardedListener;

    public UniquePlacementHelper() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        String placementId = event.getAdditionalParam();
        if (TextUtils.isEmpty((CharSequence)placementId) || !placementId.equals(this.mUniquePlacementId.getId())) {
            return;
        }
        if (this.mUniqueInterstitialListener != null) {
            switch (event.getMessageType()) {
                case INTERSTITIAL_AD_CLOSE: {
                    this.mUniqueInterstitialListener.onInterstitialClose();
                }
            }
        }
        if (this.mExternalInterstitialListener != null) {
            switch (event.getMessageType()) {
                case OPENED: {
                    this.mExternalInterstitialListener.onOpened();
                    break;
                }
                case CLOSED: {
                    this.mExternalInterstitialListener.onClosed();
                    break;
                }
                case READY: {
                    this.mExternalInterstitialListener.onReady();
                    break;
                }
                case LOAD_FAILED: {
                    this.mExternalInterstitialListener.onLoadFailed();
                    break;
                }
                case NO_OFFERS: {
                    this.mExternalInterstitialListener.onNoOffers();
                }
            }
        }
        if (this.mExternalRewardedListener != null) {
            switch (event.getMessageType()) {
                case REWARDED: {
                    this.mExternalRewardedListener.onRewardReceived();
                    break;
                }
                case REWARDED_VIDEO_STARTED: {
                    this.mExternalRewardedListener.onRewardedStarted();
                }
            }
        }
    }

    public String getUniqueId() {
        return this.mUniquePlacementId.getId();
    }

    public void setInternalInterstitialListener(UniqueInterstitialListener interstitialListener) {
        this.mUniqueInterstitialListener = interstitialListener;
    }

    public void setExternalInterstitialListener(BaseInterstitial.IOnInterstitialEventListener externalInterstitialListener) {
        this.mExternalInterstitialListener = externalInterstitialListener;
    }

    public void setExternalRewardedListener(BaseInterstitial.IOnInterstitialRewardedEventListener externalRewardedListener) {
        this.mExternalRewardedListener = externalRewardedListener;
    }
}

