/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.imagelib;

import android.content.Context;
import android.media.ExifInterface;
import android.net.Uri;
import com.squareup.imagelib.ContentStreamRequestHandler;
import com.squareup.imagelib.Picasso;
import com.squareup.imagelib.Request;
import com.squareup.imagelib.RequestHandler;
import java.io.IOException;

class FileRequestHandler
extends ContentStreamRequestHandler {
    FileRequestHandler(Context context) {
        super(context);
    }

    @Override
    public boolean canHandleRequest(Request data) {
        return "file".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        return new RequestHandler.Result(null, this.getInputStream(request), Picasso.LoadedFrom.DISK, FileRequestHandler.getFileExifRotation(request.uri));
    }

    static int getFileExifRotation(Uri uri) throws IOException {
        ExifInterface exifInterface = new ExifInterface(uri.getPath());
        return exifInterface.getAttributeInt("Orientation", 1);
    }
}

