/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.UniquePlacement.UniqueInterstitialListener;
import com.kidoz.sdk.api.general.UniquePlacement.UniquePlacementHelper;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.interstitial.KidozAdActivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class IntrstWrapper {
    protected static final int REQUEST_FILTER_TIMEOUT = 5000;
    private ArrayList<ContentItem> mContentList = new ArrayList();
    protected static IntrstWrapper mInstance = null;
    protected Activity mActivity;
    protected HtmlViewWrapper webView;
    protected ContentLogicLoader mContentLogicLoader;
    protected ContentData mContentData;
    protected String mStyleId;
    protected boolean mIsInitializationFinished = false;
    protected boolean mIsLoaded = false;
    protected boolean mIsShowRequested = false;
    protected boolean mIsLoadRequested = false;
    protected long mLoadRequestTM = 0L;
    protected boolean mIsLoadRequestedWhileNotReady;
    protected JSONObject mProperties;
    protected Lock mLaunchLock;
    protected InnerHelperInterface mInnerHelperInterface;
    protected KidozInterstitial.AD_TYPE mAdRequestType = KidozInterstitial.AD_TYPE.INTERSTITIAL;
    protected Lock raceConditionLock = new ReentrantLock();
    protected JSONObject mAdProperties;
    private int mCurrentIndex;
    private boolean mIsLocal = false;
    private UniquePlacementHelper mUniquePlacementHelper;

    public IntrstWrapper(Activity activity) {
        this.mActivity = activity;
        this.mUniquePlacementHelper = new UniquePlacementHelper();
        this.mUniquePlacementHelper.setInternalInterstitialListener(new UniqueInterstitialListener(){

            @Override
            public void onInterstitialClose() {
                IntrstWrapper.this.mInnerHelperInterface.onAdClose();
            }
        });
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.mLaunchLock = new ReentrantLock();
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.mInnerHelperInterface = new InnerHelperInterface(){

            @Override
            public void onAdOpen() {
                if (!IntrstWrapper.this.mIsLocal) {
                    EventMessage eventMessage = new EventMessage(EventMessage.MessageType.OPENED);
                    eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                    EventBus.getDefault().post((Object)eventMessage);
                }
            }

            @Override
            public void onAdClose() {
                if (!IntrstWrapper.this.mIsLocal) {
                    EventMessage eventMessage = new EventMessage(EventMessage.MessageType.CLOSED);
                    eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                    EventBus.getDefault().post((Object)eventMessage);
                }
                IntrstWrapper.this.mIsShowRequested = false;
                IntrstWrapper.this.mIsLoaded = false;
                if (IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                    SdkCookieManager.resetStorage((Context)IntrstWrapper.this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(), StorageLife.WIDGET);
                } else {
                    SdkCookieManager.resetStorage((Context)IntrstWrapper.this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), StorageLife.WIDGET);
                }
            }
        };
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                IntrstWrapper.this.mContentData = contentData;
                IntrstWrapper.this.mContentList = new ArrayList();
                IntrstWrapper.this.mContentList.addAll(contentData.getContentDataItems());
                if (IntrstWrapper.this.mContentList.size() > 0) {
                    IntrstWrapper.this.mCurrentIndex = 0;
                    ContentItem contentItem = (ContentItem)IntrstWrapper.this.mContentList.get(IntrstWrapper.this.mCurrentIndex);
                    String urlToLoad = IntrstWrapper.this.getUrlFromContent(contentItem);
                    PropertiesObj appConfig = DatabaseManager.getInstance((Context)IntrstWrapper.this.mActivity).getConfigTable().loadAppProperties();
                    if (urlToLoad == null) {
                        urlToLoad = appConfig.getInterstitialHtmlLink();
                    }
                    if (urlToLoad != null) {
                        IntrstWrapper.this.prepareWebViewWithLink(urlToLoad);
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                EventMessage eventMessage = new EventMessage(EventMessage.MessageType.LOAD_FAILED);
                eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                EventBus.getDefault().post((Object)eventMessage);
            }

            @Override
            public void onNoContentOffers() {
                EventMessage eventMessage = new EventMessage(EventMessage.MessageType.NO_OFFERS);
                eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                EventBus.getDefault().post((Object)eventMessage);
            }
        });
    }

    public InnerHelperInterface getHelperInterface() {
        return this.mInnerHelperInterface;
    }

    private void validateLayoutAndAssets() {
        if (this.raceConditionLock.tryLock()) {
            try {
                AssetUtil.parseStyleAsync((Context)this.mActivity, AssetUtil.ParserAsyncTask.StyleType.INTERSTITIAL_STYLE, new AssetUtil.ParserAsyncTask.IOnStyleParseListener(){

                    @Override
                    public void onParseFinished(boolean success) {
                        if (success) {
                            PropertiesObj appConfig;
                            IntrstWrapper.this.mProperties = DatabaseManager.getInstance((Context)IntrstWrapper.this.mActivity).getConfigTable().loadProperties(KidozInterstitial.TAG);
                            if (IntrstWrapper.this.mProperties != null) {
                                IntrstWrapper.this.mStyleId = IntrstWrapper.this.mProperties.optString("style_id");
                            }
                            if ((appConfig = DatabaseManager.getInstance((Context)IntrstWrapper.this.mActivity).getConfigTable().loadAppProperties()) != null) {
                                IntrstWrapper.this.prepareWebViewWithLink(appConfig.getInterstitialHtmlLink());
                            }
                        } else {
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.LOAD_FAILED);
                            eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                            EventBus.getDefault().post((Object)eventMessage);
                        }
                    }
                });
            }
            finally {
                this.raceConditionLock.unlock();
            }
        }
    }

    protected void generateHtmlView() {
        this.webView = HtmlManager.initIntrstDefaultHtmlView((Context)this.mActivity, this.mAdRequestType);
    }

    private synchronized void prepareWebView() {
        if (this.webView == null) {
            this.generateHtmlView();
            this.webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void onHtmlFinishedLoading() {
                    super.onHtmlFinishedLoading();
                }

                @Override
                public void onNotifyVastReady(boolean isVastReady, JSONObject vast_properties) {
                    super.onNotifyVastReady(isVastReady, vast_properties);
                    IntrstWrapper.this.mAdProperties = vast_properties;
                    IntrstWrapper.this.mIsLoadRequested = false;
                    if (isVastReady) {
                        IntrstWrapper.this.mIsLoaded = true;
                        IntrstWrapper.this.mIsInitializationFinished = true;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.READY);
                            eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                            EventBus.getDefault().post((Object)eventMessage);
                        } else {
                            IntrstWrapper.this.show();
                        }
                    } else {
                        IntrstWrapper.this.mIsLoaded = false;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.LOAD_FAILED);
                            eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                            EventBus.getDefault().post((Object)eventMessage);
                        }
                    }
                    if (IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    } else {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }

                @Override
                public void onViewReady() {
                    super.onViewReady();
                    IntrstWrapper.this.mIsInitializationFinished = true;
                    if (IntrstWrapper.this.mIsLoadRequestedWhileNotReady) {
                        IntrstWrapper.this.mIsLoadRequestedWhileNotReady = false;
                        IntrstWrapper.this.load(IntrstWrapper.this.mAdRequestType);
                    }
                }

                @Override
                public void onClose() {
                    super.onClose();
                    WidgetEventMessage eventMessage = null;
                    eventMessage = IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO ? new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED) : new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    EventBus.getDefault().post((Object)eventMessage);
                }

                @Override
                public void onRewarded() {
                    super.onRewarded();
                    EventMessage eventMessage = new EventMessage(EventMessage.MessageType.REWARDED);
                    eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                    EventBus.getDefault().post((Object)eventMessage);
                }

                @Override
                public void onRewardedVideoStarted() {
                    super.onRewardedVideoStarted();
                    EventMessage eventMessage = new EventMessage(EventMessage.MessageType.REWARDED_VIDEO_STARTED);
                    eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                    EventBus.getDefault().post((Object)eventMessage);
                }
            });
        }
        if (this.mAdRequestType != null && this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
        } else {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        }
        PropertiesObj appConfig = DatabaseManager.getInstance((Context)this.mActivity).getConfigTable().loadAppProperties();
        if (appConfig != null) {
            this.webView.loadHtml(appConfig.getInterstitialHtmlLink());
        }
    }

    private synchronized void prepareWebViewWithLink(String url) {
        if (this.webView == null) {
            this.generateHtmlView();
            this.webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void onHtmlFinishedLoading() {
                    super.onHtmlFinishedLoading();
                }

                @Override
                public void onNotifyVastReady(boolean isVastReady, JSONObject vast_properties) {
                    super.onNotifyVastReady(isVastReady, vast_properties);
                    IntrstWrapper.this.mAdProperties = vast_properties;
                    IntrstWrapper.this.mIsLoadRequested = false;
                    if (isVastReady) {
                        IntrstWrapper.this.mIsLoaded = true;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.READY);
                            eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                            EventBus.getDefault().post((Object)eventMessage);
                        } else {
                            IntrstWrapper.this.show();
                        }
                    } else if (IntrstWrapper.this.mCurrentIndex < IntrstWrapper.this.mContentList.size() - 1) {
                        IntrstWrapper.this.mCurrentIndex = IntrstWrapper.this.mCurrentIndex + 1;
                        ContentItem contentItem = (ContentItem)IntrstWrapper.this.mContentList.get(IntrstWrapper.this.mCurrentIndex);
                        String urlToLoad = IntrstWrapper.this.getUrlFromContent(contentItem);
                        PropertiesObj appConfig = DatabaseManager.getInstance((Context)IntrstWrapper.this.mActivity).getConfigTable().loadAppProperties();
                        if (urlToLoad == null) {
                            urlToLoad = appConfig.getInterstitialHtmlLink();
                        }
                        if (urlToLoad != null) {
                            IntrstWrapper.this.prepareWebViewWithLink(urlToLoad);
                        }
                    } else {
                        IntrstWrapper.this.mIsLoaded = false;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.LOAD_FAILED);
                            eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                            EventBus.getDefault().post((Object)eventMessage);
                        }
                    }
                    if (IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    } else {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }

                @Override
                public void onViewReady() {
                    super.onViewReady();
                    if (IntrstWrapper.this.mContentList.size() > IntrstWrapper.this.mCurrentIndex) {
                        ContentItem contentItem = (ContentItem)IntrstWrapper.this.mContentList.get(IntrstWrapper.this.mCurrentIndex);
                        HashMap<String, Integer> keysMap = IntrstWrapper.this.mContentData.getmKeysMap();
                        String item = contentItem.getJSONitem().toString();
                        String map = new JSONObject(keysMap).toString();
                        IntrstWrapper.this.webView.loadContent(map, item);
                    }
                    IntrstWrapper.this.mIsInitializationFinished = true;
                }

                @Override
                public void onClose() {
                    super.onClose();
                    WidgetEventMessage eventMessage = null;
                    eventMessage = IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO ? new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED) : new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    EventBus.getDefault().post((Object)eventMessage);
                }

                @Override
                public void onRewarded() {
                    super.onRewarded();
                    EventMessage eventMessage = new EventMessage(EventMessage.MessageType.REWARDED);
                    eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                    EventBus.getDefault().post((Object)eventMessage);
                }

                @Override
                public void onRewardedVideoStarted() {
                    super.onRewardedVideoStarted();
                    EventMessage eventMessage = new EventMessage(EventMessage.MessageType.REWARDED_VIDEO_STARTED);
                    eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                    EventBus.getDefault().post((Object)eventMessage);
                }

                @Override
                public void onNotifyAdReady(boolean isAdReady, JSONObject adProperties) {
                    super.onNotifyAdReady(isAdReady, adProperties);
                    IntrstWrapper.this.mAdProperties = adProperties;
                    IntrstWrapper.this.mIsLoadRequested = false;
                    if (isAdReady) {
                        IntrstWrapper.this.mIsLoaded = true;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.READY);
                            eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                            EventBus.getDefault().post((Object)eventMessage);
                        } else {
                            IntrstWrapper.this.show();
                        }
                    } else {
                        IntrstWrapper.this.mIsLoaded = false;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.LOAD_FAILED);
                            eventMessage.setAdditionalParam(IntrstWrapper.this.getPlacementHelper().getUniqueId());
                            EventBus.getDefault().post((Object)eventMessage);
                        }
                    }
                    if (IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    } else {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }
            });
        }
        if (this.mAdRequestType != null && this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
        } else {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        }
        this.webView.loadHtml(url);
    }

    public void setAdType(KidozInterstitial.AD_TYPE adType) {
        this.mAdRequestType = adType;
    }

    public KidozInterstitial.AD_TYPE getAdType() {
        return this.mAdRequestType;
    }

    public synchronized void load(KidozInterstitial.AD_TYPE ad_type) {
        this.mIsShowRequested = false;
        this.mAdRequestType = ad_type;
        if (this.mAdRequestType == KidozInterstitial.AD_TYPE.INTERSTITIAL) {
            this.mContentLogicLoader.loadWaterfall((Context)this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), this.mStyleId, "0");
        } else {
            this.mContentLogicLoader.loadWaterfall((Context)this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(), this.mStyleId, "1");
        }
        this.mCurrentIndex = 0;
    }

    public synchronized void show() {
        if (this.mIsLoaded) {
            if (!this.mIsShowRequested) {
                this.mIsShowRequested = true;
                this.openView();
            }
        } else {
            SDKLogger.printWarningLog("KidozInterstitial", "Interstitial Ad is not loaded! Please call loadAd() first.");
        }
    }

    public boolean isInterstitialLoaded() {
        return this.mIsLoaded;
    }

    protected synchronized void openView() {
        if (this.mLaunchLock.tryLock()) {
            try {
                Intent intent = new Intent((Context)this.mActivity, KidozAdActivity.class);
                intent.putExtra("styleId", this.mStyleId);
                intent.putExtra("unique_placement_id_key", this.mUniquePlacementHelper.getUniqueId());
                intent.putExtra("ad_type_key", (Serializable)((Object)this.mAdRequestType));
                if (this.mAdProperties != null) {
                    intent.putExtra("disableBack", this.mAdProperties.optBoolean("interstitial_lock", false));
                }
                if (this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                    intent.putExtra("disableBack", true);
                }
                intent.addFlags(0x30020000);
                if (this.mInnerHelperInterface != null) {
                    this.mInnerHelperInterface.onAdOpen();
                }
                this.mActivity.startActivity(intent);
            }
            catch (Exception exception) {
            }
            finally {
                this.mLaunchLock.unlock();
            }
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    public void validateIfPrepared() {
        PropertiesObj appConfig;
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (!this.mIsInitializationFinished && (appConfig = DatabaseManager.getInstance((Context)this.mActivity).getConfigTable().loadAppProperties()) != null) {
            this.prepareWebViewWithLink(appConfig.getInterstitialHtmlLink());
        }
    }

    private String getUrlFromContent(ContentItem item) {
        PropertiesObj appConfig = DatabaseManager.getInstance((Context)this.mActivity).getConfigTable().loadAppProperties();
        String url = item.getHTMLUrl();
        if (url == null) {
            switch (item.getHtmlType()) {
                case NONE: {
                    break;
                }
                case VAST: {
                    url = appConfig.getInterstitialDefaultLinkForType("vast");
                    break;
                }
                case MRAID: {
                    url = appConfig.getInterstitialDefaultLinkForType("mraid");
                    break;
                }
                case DOUBLE_CLICK: {
                    url = appConfig.getInterstitialDefaultLinkForType("double_click");
                    break;
                }
                case SUPER_AWESOME: {
                    url = appConfig.getInterstitialDefaultLinkForType("super_awesome");
                    break;
                }
                case JAVASCRIPT: {
                    url = appConfig.getInterstitialDefaultLinkForType("javascript");
                }
            }
        }
        return url;
    }

    public void setIsLocalRequest(boolean local) {
        this.mIsLocal = local;
    }

    public boolean getIsLocal() {
        return this.mIsLocal;
    }

    public UniquePlacementHelper getPlacementHelper() {
        return this.mUniquePlacementHelper;
    }

    public static interface InnerHelperInterface {
        public void onAdOpen();

        public void onAdClose();
    }
}

