/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

public class DefaultPanelDrawable
extends Drawable {
    private static final float SIZE_RATIO = 0.54f;
    private static final float LINE_WIDTH = 0.258f;
    private static final float CLOSE_BUTTON_SIZE_RATIO_RELATIVE_TO_OPEN = 0.6f;
    private Paint mXPaint;
    private Paint mBgPaint;
    private int mWidth;
    private int mHeight;
    private RectF mOpenBackgroundRoundedRectF;
    private RectF mOpenBackgroundRectF;
    private RectF mCloseBackgroundRoundedRectF;
    private RectF mCloseBackgroundRectF;
    private int mBaseColor;
    private int mXcolor;
    private PANEL_TYPE mPanelType;
    private PanelDrawableType mDrawableType;
    private Path mPlus = new Path();
    private Path mMinus = new Path();
    private boolean mDrawSign = true;

    public DefaultPanelDrawable(Context context, PANEL_TYPE panel_type, PanelDrawableType panelDrawableType) {
        float scaleFactor = ScreenUtils.getScaleFactor(context);
        this.mWidth = (int)((float)this.mWidth * scaleFactor);
        this.mHeight = (int)((float)this.mHeight * scaleFactor);
        this.mBaseColor = Color.parseColor((String)"#ffffff");
        this.mXcolor = Color.parseColor((String)"#cdffffff");
        this.mXPaint = new Paint(1);
        this.mXPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mXPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mXPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mXPaint.setPathEffect((PathEffect)new CornerPathEffect(15.0f));
        this.mXPaint.setColor(this.mXcolor);
        this.mXPaint.setShadowLayer(4.5f, 0.0f, 1.5f, 0x45000000);
        this.mXPaint.setDither(true);
        this.mBgPaint = new Paint(1);
        this.mBgPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mBgPaint.setColor(this.mBaseColor);
        this.mBgPaint.setDither(true);
        this.mPanelType = panel_type;
        this.mDrawableType = panelDrawableType;
        this.initRectF();
    }

    public void setAlpha(int alpha) {
        this.mBgPaint.setAlpha(alpha);
        this.mXPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mBgPaint.setColorFilter(cf);
        this.mXPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mWidth = bounds.width();
        this.mHeight = bounds.height();
        this.initRectF();
    }

    private void initRectF() {
        switch (this.mPanelType) {
            case TOP: {
                if (this.mDrawableType == PanelDrawableType.OPEN_VIEW) {
                    this.mOpenBackgroundRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight / 2.0f);
                    this.mOpenBackgroundRoundedRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
                    this.generatePlusButtonPath((float)this.mWidth / 2.0f, (float)this.mHeight / 2.0f);
                    break;
                }
                this.mCloseBackgroundRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, ((float)this.mHeight - (float)this.mHeight * 0.6f) / 1.3f);
                this.mCloseBackgroundRoundedRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight - (float)this.mHeight * 0.6f);
                float centerY = ((float)this.mHeight - (float)this.mHeight * 0.6f) / 2.0f;
                this.generateMinusButtonPath((float)this.mWidth / 2.0f, centerY);
                break;
            }
            case BOTTOM: {
                if (this.mDrawableType == PanelDrawableType.OPEN_VIEW) {
                    this.mOpenBackgroundRectF = new RectF(0.0f, (float)this.mHeight / 2.0f, (float)this.mWidth, (float)this.mHeight);
                    this.mOpenBackgroundRoundedRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
                    this.generatePlusButtonPath((float)this.mWidth / 2.0f, (float)this.mHeight / 2.0f);
                    break;
                }
                this.mCloseBackgroundRectF = new RectF(0.0f, (float)this.mHeight * 0.6f * 1.3f, (float)this.mWidth, (float)this.mHeight);
                this.mCloseBackgroundRoundedRectF = new RectF(0.0f, (float)this.mHeight * 0.6f, (float)this.mWidth, (float)this.mHeight);
                float start = (float)this.mHeight * 0.6f;
                float centerY = start + ((float)this.mHeight - start) / 2.0f;
                this.generateMinusButtonPath((float)this.mWidth / 2.0f, centerY);
            }
        }
    }

    private void generatePlusButtonPath(float centerX, float centerY) {
        float size = (float)this.mWidth * 0.54f;
        float width = (float)this.mWidth * 0.258f;
        float offsetSize = size / 2.0f - width / 3.5f;
        float offsetWidth = width / 2.0f;
        this.mPlus.reset();
        this.mPlus.moveTo(centerX - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f - offsetSize);
        this.mPlus.lineTo(centerX + offsetWidth / 2.0f, centerY - offsetWidth / 2.0f - offsetSize);
        this.mPlus.lineTo(centerX + offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX + offsetWidth / 2.0f + offsetSize, centerY - offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX + offsetWidth / 2.0f + offsetSize, centerY + offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX + offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX + offsetWidth / 2.0f, centerY + offsetWidth / 2.0f + offsetSize);
        this.mPlus.lineTo(centerX - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f + offsetSize);
        this.mPlus.lineTo(centerX - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPlus.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
    }

    private void generateMinusButtonPath(float centerX, float centerY) {
        float size = (float)this.mWidth * 0.54f;
        float width = (float)this.mWidth * 0.258f;
        float offsetSize = size / 2.0f - width / 2.6f;
        float offsetWidth = width / 2.0f;
        this.mMinus.reset();
        this.mMinus.moveTo(centerX - offsetSize - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mMinus.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mMinus.lineTo(centerX + offsetSize + offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mMinus.lineTo(centerX + offsetSize + offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mMinus.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mMinus.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
    }

    public void draw(Canvas canvas) {
        this.mBgPaint.setColor(this.mBaseColor);
        this.mXPaint.setColor(this.mXcolor);
        float radius = 0.14084508f * (float)this.mWidth;
        switch (this.mDrawableType) {
            case OPEN_VIEW: {
                canvas.drawRect(this.mOpenBackgroundRectF, this.mBgPaint);
                canvas.drawRoundRect(this.mOpenBackgroundRoundedRectF, radius, radius, this.mBgPaint);
                if (!this.mDrawSign) break;
                canvas.drawPath(this.mPlus, this.mXPaint);
                break;
            }
            case CLOSE_VIEW: {
                canvas.drawRect(this.mCloseBackgroundRectF, this.mBgPaint);
                canvas.drawRoundRect(this.mCloseBackgroundRoundedRectF, radius, radius, this.mBgPaint);
                if (!this.mDrawSign) break;
                canvas.drawPath(this.mMinus, this.mXPaint);
            }
        }
    }

    public void setPanelType(PANEL_TYPE panelType) {
        this.mPanelType = panelType;
        this.initRectF();
        this.invalidateSelf();
    }

    public void setBaseColor(int baseColor) {
        this.mBaseColor = baseColor;
        this.mBgPaint.setColor(baseColor);
    }

    public void setDrawSign(boolean draw) {
        this.mDrawSign = draw;
        this.invalidateSelf();
    }

    public static enum PanelDrawableType {
        OPEN_VIEW,
        CLOSE_VIEW;

    }
}

