/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

public abstract class RecycleEndlessScrollListener {
    private int visibleThreshold = 5;
    private int currentPage = 0;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private int startingPageIndex = 0;

    public RecycleEndlessScrollListener() {
    }

    public RecycleEndlessScrollListener(int visibleThreshold) {
        this.visibleThreshold = visibleThreshold;
    }

    public RecycleEndlessScrollListener(int visibleThreshold, int startPage) {
        this.visibleThreshold = visibleThreshold;
        this.startingPageIndex = startPage;
        this.currentPage = startPage;
    }

    public void onScroll(int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (totalItemCount < this.previousTotalItemCount) {
            this.currentPage = this.startingPageIndex;
            this.previousTotalItemCount = totalItemCount;
            if (totalItemCount == 0) {
                this.loading = true;
            }
        }
        if (this.loading && totalItemCount > this.previousTotalItemCount) {
            this.loading = false;
            this.previousTotalItemCount = totalItemCount;
            ++this.currentPage;
        }
        if (!this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + this.visibleThreshold) {
            this.onLoadMore(this.currentPage, totalItemCount);
            this.loading = true;
        }
    }

    public abstract void onLoadMore(int var1, int var2);

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPageAndCount(int pageNum, int totlaItemsCount) {
        this.currentPage = pageNum;
        this.startingPageIndex = pageNum;
    }
}

