/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.platforms;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.kidoz.sdk.api.FeedButton;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.FlexiView;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.interfaces.FlexiViewListener;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.interfaces.SDKEventListener;
import com.kidoz.sdk.api.ui_views.flexi_view.FLEXI_POSITION;
import com.kidoz.sdk.api.ui_views.interstitial.BaseInterstitial;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnit;

public abstract class BasePlatformsBridge {
    public static final int HANDLE_POSITION_START = 0;
    public static final int HANDLE_POSITION_CENTER = 1;
    public static final int HANDLE_POSITION_END = 2;
    public static final int HANDLE_POSITION_NONE = 3;
    public static final int PANEL_TYPE_BOTTOM = 0;
    public static final int PANEL_TYPE_TOP = 1;
    public static final int PANEL_TYPE_LEFT = 2;
    public static final int PANEL_TYPE_RIGHT = 3;
    public static final int FLEXI_VIEW_POSITION_TOP_START = 0;
    public static final int FLEXI_VIEW_POSITION_TOP_CENTER = 1;
    public static final int FLEXI_VIEW_POSITION_TOP_END = 2;
    public static final int FLEXI_VIEW_POSITION_MID_START = 3;
    public static final int FLEXI_VIEW_POSITION_MID_CENTER = 4;
    public static final int FLEXI_VIEW_POSITION_MID_END = 5;
    public static final int FLEXI_VIEW_POSITION_BOTTOM_START = 6;
    public static final int FLEXI_VIEW_POSITION_BOTTOM_CENTER = 7;
    public static final int FLEXI_VIEW_POSITION_BOTTOM_END = 8;
    protected Activity mActivity;
    private FeedView mFeedView;
    private PanelView mPanelView;
    private FeedButton mFeedButton;
    private FlexiView mFlexiView;
    private VideoUnit mVideoUnit;
    private KidozInterstitial mInterstitial;
    private KidozInterstitial.AD_TYPE mInterstitialAdType;
    private FrameLayout mContainer;
    private boolean isContainerAdded = false;
    protected static final String KIDOZ_ERROR_ACTIVITY_REQUIRED = "Kidoz requires an Activity context in order to function properly.";

    protected abstract void initialize(Activity var1, String var2, String var3);

    protected abstract boolean isInitialised();

    protected abstract void onSDKInitSuccess();

    protected abstract void onSDKInitError(String var1);

    public abstract void onClbkFeedDismissView();

    public abstract void onClbkFeedReadyToShow();

    public abstract void onClbkFeedViewReady();

    public abstract void onClbkPanelViewCollapsed();

    public abstract void onClbkPanelViewReady();

    public abstract void onClbkPanelViewExpanded();

    public abstract void onClbkFlexiViewReady();

    public abstract void onClbkFlexiViewHidden();

    public abstract void onClbkFlexiViewVisible();

    public abstract void onClbkPlayerOpened();

    public abstract void onClbkPlayerClosed();

    public abstract void onClbkInterstitialOpened();

    public abstract void onClbkInterstitialClosed();

    public abstract void onClbkInterstitialReady();

    public abstract void onClbkInterstitialLoadFailed();

    public abstract void onClbkInterstitialNoOffers();

    public abstract void onClbkRewarded();

    public abstract void onClbkRewardedVideoStarted();

    public abstract void onClbkVideoUnitReady();

    public abstract void onClbkVideoUnitOpen();

    public abstract void onClbkVideoUnitClose();

    public BasePlatformsBridge(Context context) {
        if (!(context instanceof Activity)) {
            SDKLogger.printErrorLog(KIDOZ_ERROR_ACTIVITY_REQUIRED);
            return;
        }
        this.mActivity = (Activity)context;
        this.mContainer = new FrameLayout((Context)this.mActivity);
        KidozSDK.setSDKListener(new SDKEventListener(){

            @Override
            public void onInitSuccess() {
                BasePlatformsBridge.this.onSDKInitSuccess();
            }

            @Override
            public void onInitError(String errorMsg) {
                BasePlatformsBridge.this.onSDKInitError(errorMsg);
            }
        });
    }

    private boolean isChildViewExistsInContainer(View view) {
        boolean exists = false;
        if (this.mContainer != null && this.mContainer.getChildCount() > 0) {
            for (int i = 0; i < this.mContainer.getChildCount(); ++i) {
                if (this.mContainer.getChildAt(i) != view) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    private void addContainerIfNeeded() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!BasePlatformsBridge.this.isContainerAdded) {
                    BasePlatformsBridge.this.mActivity.addContentView((View)BasePlatformsBridge.this.mContainer, new ViewGroup.LayoutParams(-1, -1));
                    BasePlatformsBridge.this.isContainerAdded = true;
                    BasePlatformsBridge.this.mContainer.bringToFront();
                }
            }
        });
    }

    public void addFeedButton(int x, int y, int size) {
        this.addFeedButton(x, y, size, true);
    }

    public void addFeedButton(final int x, final int y, final int size, final boolean autoShow) {
        this.addContainerIfNeeded();
        if (this.mFeedButton == null) {
            this.mActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (size == -1) {
                        BasePlatformsBridge.this.mFeedButton = new FeedButton((Context)BasePlatformsBridge.this.mActivity);
                    }
                    BasePlatformsBridge.this.mFeedButton.getFeedView().setOnFeedViewEventListener(new IOnFeedViewEventListener(){

                        @Override
                        public void onDismissView() {
                            BasePlatformsBridge.this.onClbkFeedDismissView();
                        }

                        @Override
                        public void onReadyToShow() {
                            BasePlatformsBridge.this.onClbkFeedReadyToShow();
                        }

                        @Override
                        public void onViewReady() {
                            BasePlatformsBridge.this.onClbkFeedViewReady();
                        }
                    });
                    BasePlatformsBridge.this.mFeedButton.getFeedView().setKidozPlayerListener(new KidozPlayerListener(){

                        @Override
                        public void onPlayerOpen() {
                            super.onPlayerOpen();
                            BasePlatformsBridge.this.onClbkPlayerOpened();
                        }

                        @Override
                        public void onPlayerClose() {
                            super.onPlayerClose();
                            BasePlatformsBridge.this.onClbkPlayerClosed();
                        }
                    });
                    if (!BasePlatformsBridge.this.isChildViewExistsInContainer((View)BasePlatformsBridge.this.mFeedButton)) {
                        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
                        params.setMargins(x, y, 0, 0);
                        BasePlatformsBridge.this.mContainer.addView((View)BasePlatformsBridge.this.mFeedButton, (ViewGroup.LayoutParams)params);
                        BasePlatformsBridge.this.mContainer.bringToFront();
                        BasePlatformsBridge.this.mFeedButton.bringToFront();
                        if (!autoShow) {
                            BasePlatformsBridge.this.mFeedButton.setVisibility(4);
                        }
                    }
                }
            });
        }
    }

    public void changeFeedButtonVisibility(final boolean visible) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mFeedButton != null) {
                    if (visible) {
                        BasePlatformsBridge.this.mFeedButton.setVisibility(0);
                    } else {
                        BasePlatformsBridge.this.mFeedButton.setVisibility(4);
                    }
                    BasePlatformsBridge.this.mFeedButton.bringToFront();
                }
            }
        });
    }

    public void showFeedView() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mFeedView == null) {
                    BasePlatformsBridge.this.mFeedView = new FeedView.Builder((Context)BasePlatformsBridge.this.mActivity).build();
                    BasePlatformsBridge.this.mFeedView.setOnFeedViewEventListener(new IOnFeedViewEventListener(){

                        @Override
                        public void onDismissView() {
                            BasePlatformsBridge.this.onClbkFeedDismissView();
                        }

                        @Override
                        public void onReadyToShow() {
                            BasePlatformsBridge.this.onClbkFeedReadyToShow();
                        }

                        @Override
                        public void onViewReady() {
                            BasePlatformsBridge.this.onClbkFeedViewReady();
                        }
                    });
                    BasePlatformsBridge.this.mFeedView.setKidozPlayerListener(new KidozPlayerListener(){

                        @Override
                        public void onPlayerOpen() {
                            super.onPlayerOpen();
                            BasePlatformsBridge.this.onClbkPlayerOpened();
                        }

                        @Override
                        public void onPlayerClose() {
                            super.onPlayerClose();
                            BasePlatformsBridge.this.onClbkPlayerClosed();
                        }
                    });
                }
                if (BasePlatformsBridge.this.mFeedView != null) {
                    BasePlatformsBridge.this.mFeedView.showView();
                }
            }
        });
    }

    public void dismissFeedView() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mFeedView != null) {
                    BasePlatformsBridge.this.mFeedView.dismissView();
                }
            }
        });
    }

    public void addPanelToView(int panel_type, int handle_position) {
        this.addPanelToView(panel_type, handle_position, true);
    }

    public void addPanelToView(int panel_type, int handle_position, boolean autoShow) {
        this.addPanelToView(panel_type, handle_position, autoShow, -1.0f, -1.0f);
    }

    public void addPanelToView(int panel_type, int handle_position, float startDelay, float showPeriod) {
        this.addPanelToView(panel_type, handle_position, true, startDelay, showPeriod);
    }

    public void addPanelToView(final int panel_type, final int handle_position, final boolean autoShow, float startDelay, float showPeriod) {
        this.addContainerIfNeeded();
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mPanelView == null) {
                    PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
                    HANDLE_POSITION mHandlePos = HANDLE_POSITION.START;
                    switch (panel_type) {
                        case 0: {
                            mPanelType = PANEL_TYPE.BOTTOM;
                            break;
                        }
                        case 2: {
                            mPanelType = PANEL_TYPE.LEFT;
                            break;
                        }
                        case 3: {
                            mPanelType = PANEL_TYPE.RIGHT;
                            break;
                        }
                        case 1: {
                            mPanelType = PANEL_TYPE.TOP;
                        }
                    }
                    switch (handle_position) {
                        case 0: {
                            mHandlePos = HANDLE_POSITION.START;
                            break;
                        }
                        case 1: {
                            mHandlePos = HANDLE_POSITION.CENTER;
                            break;
                        }
                        case 2: {
                            mHandlePos = HANDLE_POSITION.END;
                            break;
                        }
                        case 3: {
                            mHandlePos = HANDLE_POSITION.NONE;
                        }
                    }
                    BasePlatformsBridge.this.mPanelView = new PanelView((Context)BasePlatformsBridge.this.mActivity);
                    BasePlatformsBridge.this.mPanelView.setPanelConfiguration(mPanelType, mHandlePos);
                    BasePlatformsBridge.this.mPanelView.setOnPanelViewEventListener(new IOnPanelViewEventListener(){

                        @Override
                        public void onPanelViewCollapsed() {
                            BasePlatformsBridge.this.onClbkPanelViewCollapsed();
                        }

                        @Override
                        public void onPanelViewExpanded() {
                            BasePlatformsBridge.this.onClbkPanelViewExpanded();
                        }

                        @Override
                        public void onPanelReady() {
                            BasePlatformsBridge.this.onClbkPanelViewReady();
                        }
                    });
                    BasePlatformsBridge.this.mPanelView.setKidozPlayerListener(new KidozPlayerListener(){

                        @Override
                        public void onPlayerOpen() {
                            super.onPlayerOpen();
                            BasePlatformsBridge.this.onClbkPlayerOpened();
                        }

                        @Override
                        public void onPlayerClose() {
                            super.onPlayerClose();
                            BasePlatformsBridge.this.onClbkPlayerClosed();
                        }
                    });
                    if (!BasePlatformsBridge.this.isChildViewExistsInContainer((View)BasePlatformsBridge.this.mPanelView)) {
                        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
                        BasePlatformsBridge.this.mContainer.addView((View)BasePlatformsBridge.this.mPanelView, (ViewGroup.LayoutParams)params);
                        BasePlatformsBridge.this.mPanelView.bringToFront();
                    }
                    if (!autoShow) {
                        BasePlatformsBridge.this.mPanelView.setVisibility(4);
                    }
                }
            }
        });
    }

    public void changePanelVisibility(final boolean visible) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mPanelView != null) {
                    if (visible) {
                        BasePlatformsBridge.this.mPanelView.setVisibility(0);
                    } else {
                        BasePlatformsBridge.this.mPanelView.setVisibility(4);
                    }
                    BasePlatformsBridge.this.mContainer.bringToFront();
                    BasePlatformsBridge.this.mPanelView.bringToFront();
                }
            }
        });
    }

    public void expandPanelView() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mPanelView != null && !BasePlatformsBridge.this.mPanelView.getIsPanelViewExpanded()) {
                    BasePlatformsBridge.this.mPanelView.expandPanelView();
                }
            }
        });
    }

    public void collapsePanelView() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mPanelView != null && BasePlatformsBridge.this.mPanelView.getIsPanelViewExpanded()) {
                    BasePlatformsBridge.this.mPanelView.collapsePanelView();
                }
            }
        });
    }

    public boolean getIsPanelExpanded() {
        if (this.mPanelView != null) {
            return this.mPanelView.getIsPanelViewExpanded();
        }
        return false;
    }

    public void addFlexiView(final boolean isAutoShow, final int initialPosition) {
        this.addContainerIfNeeded();
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mFlexiView == null) {
                    BasePlatformsBridge.this.mFlexiView = new FlexiView((Context)BasePlatformsBridge.this.mActivity);
                    BasePlatformsBridge.this.mFlexiView.setAutoShow(isAutoShow);
                    BasePlatformsBridge.this.mFlexiView.setOnFlexiViewEventListener(new FlexiViewListener(){

                        @Override
                        public void onViewHidden() {
                            super.onViewHidden();
                            BasePlatformsBridge.this.onClbkFlexiViewHidden();
                        }

                        @Override
                        public void onViewReady() {
                            super.onViewReady();
                            BasePlatformsBridge.this.onClbkFlexiViewReady();
                        }

                        @Override
                        public void onViewVisible() {
                            super.onViewVisible();
                            BasePlatformsBridge.this.onClbkFlexiViewVisible();
                        }
                    });
                    BasePlatformsBridge.this.mFlexiView.setKidozPlayerListener(new KidozPlayerListener(){

                        @Override
                        public void onPlayerOpen() {
                            super.onPlayerOpen();
                            BasePlatformsBridge.this.onClbkPlayerOpened();
                        }

                        @Override
                        public void onPlayerClose() {
                            super.onPlayerClose();
                            BasePlatformsBridge.this.onClbkPlayerClosed();
                        }
                    });
                    FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
                    switch (initialPosition) {
                        case 0: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.TOP_START);
                            break;
                        }
                        case 1: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.TOP_CENTER);
                            break;
                        }
                        case 2: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.TOP_END);
                            break;
                        }
                        case 3: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.MIDDLE_START);
                            break;
                        }
                        case 4: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.MIDDLE_CENTER);
                            break;
                        }
                        case 5: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.MIDDLE_END);
                            break;
                        }
                        case 6: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.BOTTOM_START);
                            break;
                        }
                        case 7: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.BOTTOM_CENTER);
                            break;
                        }
                        case 8: {
                            BasePlatformsBridge.this.mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.BOTTOM_END);
                        }
                    }
                    BasePlatformsBridge.this.mContainer.addView((View)BasePlatformsBridge.this.mFlexiView, (ViewGroup.LayoutParams)params);
                    BasePlatformsBridge.this.mContainer.bringToFront();
                    BasePlatformsBridge.this.mFlexiView.bringToFront();
                }
            }
        });
    }

    public void showFlexiView() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mFlexiView != null) {
                    BasePlatformsBridge.this.mFlexiView.showFlexiView();
                }
            }
        });
    }

    public void hideFlexiView() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mFlexiView != null) {
                    BasePlatformsBridge.this.mFlexiView.hideFlexiView();
                }
            }
        });
    }

    public boolean getIsFlexiViewVisible() {
        if (this.mFlexiView != null) {
            return this.mFlexiView.getIsFlexiViewVisible();
        }
        return false;
    }

    public void loadInterstitialAd(boolean autoShowOnLoad) {
        this.loadInterstitialAd(autoShowOnLoad, KidozInterstitial.AD_TYPE.INTERSTITIAL.getValue());
    }

    public void loadRewardedAd(boolean autoShowOnLoad) {
        this.loadInterstitialAd(autoShowOnLoad, KidozInterstitial.AD_TYPE.REWARDED_VIDEO.getValue());
    }

    public void loadInterstitialAd(final boolean autoShowOnLoad, final int ad_type) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BasePlatformsBridge.this.defineAdType(ad_type);
                BasePlatformsBridge.this.createInterstitial(BasePlatformsBridge.this.mActivity);
                BasePlatformsBridge.this.mInterstitial.setOnInterstitialEventListener(new BaseInterstitial.IOnInterstitialEventListener(){

                    @Override
                    public void onClosed() {
                        BasePlatformsBridge.this.onClbkInterstitialClosed();
                    }

                    @Override
                    public void onOpened() {
                        BasePlatformsBridge.this.onClbkInterstitialOpened();
                    }

                    @Override
                    public void onReady() {
                        BasePlatformsBridge.this.onClbkInterstitialReady();
                        if (autoShowOnLoad) {
                            BasePlatformsBridge.this.showInterstitial();
                        }
                    }

                    @Override
                    public void onLoadFailed() {
                        BasePlatformsBridge.this.onClbkInterstitialLoadFailed();
                    }

                    @Override
                    public void onNoOffers() {
                        BasePlatformsBridge.this.onClbkInterstitialNoOffers();
                    }
                });
                BasePlatformsBridge.this.mInterstitial.setOnInterstitialRewardedEventListener(new BaseInterstitial.IOnInterstitialRewardedEventListener(){

                    @Override
                    public void onRewardReceived() {
                        BasePlatformsBridge.this.onClbkRewarded();
                    }

                    @Override
                    public void onRewardedStarted() {
                        BasePlatformsBridge.this.onClbkRewardedVideoStarted();
                    }
                });
                if (BasePlatformsBridge.this.mInterstitialAdType != null) {
                    BasePlatformsBridge.this.mInterstitial.loadAd();
                }
            }
        });
    }

    private void defineAdType(int ad_type) {
        this.mInterstitialAdType = KidozInterstitial.AD_TYPE.INTERSTITIAL;
        try {
            if (KidozInterstitial.AD_TYPE.values().length > ad_type) {
                this.mInterstitialAdType = KidozInterstitial.AD_TYPE.values()[ad_type];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showInterstitial() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mInterstitial != null) {
                    BasePlatformsBridge.this.mInterstitial.show();
                }
            }
        });
    }

    private void createInterstitial(Activity activity) {
        if (this.mInterstitial == null) {
            this.mInterstitial = new KidozInterstitial(activity, this.mInterstitialAdType);
        }
    }

    public void showVideoUnit() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BasePlatformsBridge.this.mVideoUnit == null) {
                    BasePlatformsBridge.this.mVideoUnit = new VideoUnit((Context)BasePlatformsBridge.this.mActivity);
                    BasePlatformsBridge.this.mVideoUnit.setVideoUnitListener(new VideoUnit.VideoUnitListener(){

                        @Override
                        public void onReady() {
                            BasePlatformsBridge.this.onClbkVideoUnitReady();
                        }

                        @Override
                        public void onClose() {
                            BasePlatformsBridge.this.onClbkVideoUnitClose();
                        }

                        @Override
                        public void onOpen() {
                            BasePlatformsBridge.this.onClbkVideoUnitOpen();
                        }
                    });
                }
                if (BasePlatformsBridge.this.mVideoUnit.getIsReady()) {
                    BasePlatformsBridge.this.mVideoUnit.show();
                }
            }
        });
    }

    public boolean getIsInterstitialLoaded() {
        if (this.mInterstitial != null) {
            return this.mInterstitial.isLoaded();
        }
        return false;
    }

    public void printToastLog(final String log) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)BasePlatformsBridge.this.mActivity, (CharSequence)log, (int)0).show();
            }
        });
    }
}

