/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.kidoz.sdk.api.general.utils.EncoderUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class Utils {
    private static final String TAG = Utils.class.getSimpleName();
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static boolean isWebViewSupportWepPAnimations = false;
    private static String mDefaultUserAgent = "";
    private static String cacheBuster;

    public static int generateViewId() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public static String getCarrierName(Context context) {
        String carrierName = "unknown";
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            carrierName = manager.getNetworkOperatorName();
        }
        catch (Exception e) {
            SDKLogger.printErrorLog("KIDOZ", e.getMessage());
        }
        return carrierName;
    }

    public static String getNetworkType(Context context) {
        String networkString = "Unknown";
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            int networkType = manager.getNetworkType();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    networkString = "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    networkString = "3G";
                }
                case 13: {
                    networkString = "4G";
                }
            }
            networkString = "Unknown";
        }
        catch (Exception e) {
            SDKLogger.printErrorLog("KIDOZ", e.getMessage());
        }
        return networkString;
    }

    public static String getCacheBuster() {
        Random rnd = new Random();
        int value = rnd.nextInt(38975);
        return new Integer(value).toString();
    }

    public static long getAppSessionId(Activity activity) {
        SharedPreferences sharedPreferences = activity.getSharedPreferences("events_shared_preferences", 0);
        return sharedPreferences.getLong("last_session_id", 0L);
    }

    public static int dpTOpx(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int dpTOpx(Resources resources, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static int spTOpx(Context context, float sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static Uri prepareCorrectUri(Object res) {
        if (res != null) {
            if (res instanceof Uri) {
                return (Uri)res;
            }
            if (res instanceof Integer) {
                return Uri.parse((String)("res:///" + res));
            }
            if (res instanceof File) {
                return Uri.fromFile((File)((File)res));
            }
            int val = -1;
            try {
                val = Integer.parseInt((String)res);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (val != -1) {
                return Uri.parse((String)("res:///" + val));
            }
            if (((String)res).startsWith("http://") || ((String)res).startsWith("https://")) {
                return Uri.parse((String)((String)res));
            }
            if (((String)res).contains("mnt/") || ((String)res).contains("storage/")) {
                return Uri.fromFile((File)new File((String)res));
            }
            return Uri.parse((String)("asset:///" + res));
        }
        return Uri.EMPTY;
    }

    @SuppressLint(value={"NewApi"})
    public static Point getScreenSize(Context context) {
        Point size = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 19) {
            display.getRealSize(size);
        } else {
            size.x = display.getWidth();
            size.y = display.getHeight();
        }
        return size;
    }

    public static double getDeviceScreenSizeInInches(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int mWidthPixels = displayMetrics.widthPixels;
        int mHeightPixels = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                mWidthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                mHeightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, realSize);
                mWidthPixels = realSize.x;
                mHeightPixels = realSize.y;
            }
            catch (Exception realSize) {
                // empty catch block
            }
        }
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        double x = Math.pow((float)mWidthPixels / dm.xdpi, 2.0);
        double y = Math.pow((float)mHeightPixels / dm.ydpi, 2.0);
        double screenInches = Math.sqrt(x + y);
        return (double)Math.round(screenInches * 10.0) / 10.0;
    }

    public static String fixUrlLink(String url) {
        String result = url;
        if (result != null && (result.contains("http") || result.contains("https"))) {
            if ((result = result.trim()).contains(" ")) {
                result = result.replace(" ", "%20");
            }
            if (result.contains("+")) {
                result = result.replace("+", "_");
            }
        }
        return result;
    }

    public static boolean checkManifestPermission(Context context, String permissison) {
        if (TextUtils.isEmpty((CharSequence)permissison)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return context.checkSelfPermission(permissison) == 0;
        }
        return context.checkCallingOrSelfPermission(permissison) == 0;
    }

    public static String getDeviceType(Context context) {
        String DEVICE_IS_NOT_TABLET = "1";
        String DEVICE_IS_TABLET = "2";
        if (ScreenUtils.getIsTablet(context)) {
            return "2";
        }
        return "1";
    }

    public static String getAppVersionCode(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return String.valueOf(packageInfo.versionCode);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to get app version code: " + ex.getMessage());
            return null;
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to get app version name: " + ex.getMessage());
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void setOnGlobalLayoutFinishListener(final View view, final OnGlobalLayoutFinishedListener layoutFinishedListener) {
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (layoutFinishedListener != null) {
                    layoutFinishedListener.onLayoutFinished();
                }
            }
        });
    }

    public static String readStringFromAssets(Context context, String path) {
        String res = null;
        try {
            String str;
            StringBuilder buf = new StringBuilder();
            InputStream json = context.getAssets().open(path);
            BufferedReader in = new BufferedReader(new InputStreamReader(json, "UTF-8"));
            while ((str = in.readLine()) != null) {
                buf.append(str);
            }
            in.close();
            res = buf.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static String generateUniqeDeviceID(String packageName, String publisherId) {
        String scrumbler = "KidozSDK";
        String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        if (Build.SERIAL != null) {
            scrumbler = scrumbler + Build.SERIAL;
        }
        String preliminaryId = new UUID(m_szDevIDShort.hashCode(), scrumbler.hashCode()).toString();
        return EncoderUtils.SHA1(preliminaryId + packageName + publisherId);
    }

    public static int getNavigationBarHeight(Context context) {
        int height = 0;
        try {
            Resources resources = context.getResources();
            int orientation = resources.getConfiguration().orientation;
            int id = resources.getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_height_landscape", "dimen", "android");
            if (id > 0) {
                height = resources.getDimensionPixelSize(id);
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return height;
    }

    public static String getDeviceReferral(Context context) {
        String publisherID = SharedPreferencesUtils.loadSharedPreferencesData(context, "PUBLISHER_ID");
        String result = "SDK_";
        if (context != null) {
            result = result + context.getPackageName();
            result = result + "_";
            if (publisherID != null) {
                result = result + publisherID;
            }
        }
        SDKLogger.printDebugLog(TAG, "Device Referral>> " + result);
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public static int getScreenSize(Context context, boolean isWidth) {
        int result = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (isWidth) {
            if (Build.VERSION.SDK_INT >= 19) {
                Point point = new Point();
                display.getRealSize(point);
                result = point.x;
            } else {
                result = display.getWidth();
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            Point point = new Point();
            display.getRealSize(point);
            result = point.y;
        } else {
            result = display.getHeight();
        }
        return result;
    }

    public static String getWifiOn(Context context) {
        ConnectivityManager cm;
        NetworkInfo activeNetwork;
        String WIFI_OFF = "0";
        String WIFI_ON = "1";
        String wifiMode = "0";
        if (Utils.checkManifestPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (activeNetwork = (cm = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && activeNetwork.getType() == 1) {
            wifiMode = "1";
        }
        return wifiMode;
    }

    public static boolean isTablet(Context context) {
        boolean isTable;
        boolean xlarge = (context.getResources().getConfiguration().screenLayout & 0xF) == 4;
        boolean large = (context.getResources().getConfiguration().screenLayout & 0xF) == 3;
        boolean bl = isTable = xlarge || large;
        return isTable || Utils.getDeviceScreenSizeInInches(context) >= 7.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultUserAgentString(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return WebSettings.getDefaultUserAgent((Context)context);
        }
        Constructor constructor = WebSettings.class.getDeclaredConstructor(Context.class, WebView.class);
        constructor.setAccessible(true);
        try {
            WebSettings settings = (WebSettings)constructor.newInstance(context, null);
            String string = settings.getUserAgentString();
            constructor.setAccessible(false);
            return string;
        }
        catch (Throwable throwable) {
            try {
                constructor.setAccessible(false);
                throw throwable;
            }
            catch (Exception e) {
                return new WebView(context).getSettings().getUserAgentString();
            }
        }
    }

    public static String getWebViewVersion() {
        String[] tempVal;
        int index;
        String sub;
        String[] res;
        String webviewVersion = "w";
        String useragent = Utils.getDefaultUserAgent();
        if (useragent != null && useragent.contains("Chrome") && (res = (sub = useragent.substring(index = useragent.indexOf("Chrome"), useragent.length())).split(" ")) != null && res.length > 0 && (tempVal = res[0].split("/")) != null && tempVal.length > 1) {
            webviewVersion = "c_" + tempVal[1];
        }
        return webviewVersion;
    }

    protected static boolean checkIfDeviceSupportWebPAnimations(Context context) {
        String[] version;
        String[] tempVal;
        int index;
        String sub;
        String[] res;
        boolean allowed = false;
        mDefaultUserAgent = Utils.getDefaultUserAgentString(context);
        String useragent = mDefaultUserAgent;
        if (useragent != null && useragent.contains("Chrome") && (res = (sub = useragent.substring(index = useragent.indexOf("Chrome"), useragent.length())).split(" ")) != null && res.length > 0 && (tempVal = res[0].split("/")) != null && tempVal.length > 1 && (version = tempVal[1].split(Pattern.quote("."))) != null && version.length > 0) {
            try {
                int realVal = Integer.parseInt(version[0]);
                if (realVal >= 32) {
                    allowed = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return allowed;
    }

    public static boolean isWebViewSupportWebP() {
        return isWebViewSupportWepPAnimations;
    }

    public static String getDefaultUserAgent() {
        return mDefaultUserAgent;
    }

    public static void preInitiate(Context context) {
        isWebViewSupportWepPAnimations = Utils.checkIfDeviceSupportWebPAnimations(context);
    }

    public static interface OnGlobalLayoutFinishedListener {
        public void onLayoutFinished();
    }

    public static class StaticHandler
    extends Handler {
        public StaticHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
        }
    }
}

