/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.kidoz.sdk.api.general.utils.CustomAdvertisingIdClient;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.NetworkInterface;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class SdkDeviceUtils {
    private static final String TAG = SdkDeviceUtils.class.getSimpleName();
    private static final String STOP_STATE_FLAG_SHARED_PREFERENCES = "STOP_STATE_FLAG_SHARED_PREFERENCES";

    public static String getDeviceReferral(Context context) {
        String publisherID = SharedPreferencesUtils.loadSharedPreferencesData(context, "PUBLISHER_ID");
        String result = "SDK_";
        if (context != null) {
            result = result + context.getPackageName();
            result = result + "_";
            if (publisherID != null) {
                result = result + publisherID;
            }
        }
        SDKLogger.printDebugLog(TAG, "Device Referral>> " + result);
        return result;
    }

    public static String getCurrentDefaultLauncherPackageName(Context context) {
        String result = null;
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        if (resolveInfo != null && (result = resolveInfo.activityInfo.packageName).equals("android")) {
            result = null;
        }
        return result;
    }

    public static void setDeviceLanguage(Context context, String languageCode) {
        if (context != null && languageCode != null) {
            String[] selectedLocale = languageCode.split("_");
            Locale locale = null;
            if (selectedLocale != null && selectedLocale.length > 1) {
                locale = new Locale(selectedLocale[0], selectedLocale[1]);
            } else if (selectedLocale != null && selectedLocale.length > 0) {
                locale = new Locale(selectedLocale[0]);
            } else {
                return;
            }
            Locale.setDefault(locale);
            Configuration config = context.getResources().getConfiguration();
            config.locale = locale;
            if (context != null) {
                context.getResources().updateConfiguration(config, context.getResources().getDisplayMetrics());
            }
        }
    }

    public static String getWiFiActivityClassName(Context context) {
        Intent wifiIntent = new Intent("android.settings.WIRELESS_SETTINGS");
        PackageManager packageManager = context.getPackageManager();
        List galleryActivities = packageManager.queryIntentActivities(wifiIntent, 65536);
        if (galleryActivities != null && galleryActivities.size() > 0 && ((ResolveInfo)galleryActivities.get((int)0)).activityInfo != null) {
            return ((ResolveInfo)galleryActivities.get((int)0)).activityInfo.name;
        }
        return null;
    }

    public static Intent getLaunchIntentForPackageName(Context context, String packageName) {
        if (context != null) {
            return context.getPackageManager().getLaunchIntentForPackage(packageName);
        }
        return null;
    }

    public static File getWritableExternalStorageFilePath() {
        File path = null;
        String state = Environment.getExternalStorageState();
        path = "mounted".equals(state) || !"mounted_ro".equals(state) ? Environment.getExternalStorageDirectory() : null;
        return path;
    }

    @SuppressLint(value={"NewApi"})
    public static int getScreenSize(Context context, boolean isWidth) {
        int result = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (isWidth) {
            if (Build.VERSION.SDK_INT >= 19) {
                Point point = new Point();
                display.getRealSize(point);
                result = point.x;
            } else {
                result = display.getWidth();
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            Point point = new Point();
            display.getRealSize(point);
            result = point.y;
        } else {
            result = display.getHeight();
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public static Point getScreenSize(Context context) {
        Point size = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 19) {
            display.getRealSize(size);
        } else {
            size.x = display.getWidth();
            size.y = display.getHeight();
        }
        return size;
    }

    public static String getMACAddress(String interfaceName) {
        String result = null;
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                byte[] mac;
                if (interfaceName != null && !intf.getName().equalsIgnoreCase(interfaceName) || (mac = intf.getHardwareAddress()) == null) continue;
                StringBuilder buf = new StringBuilder();
                for (byte aMac : mac) {
                    buf.append(String.format("%02X:", aMac));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                result = buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void writeObjectToInternalStorage(Context context, String key, Object object) {
        try {
            FileOutputStream fos = context.openFileOutput(key, 0);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            oos.flush();
            oos.close();
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            SDKLogger.printErrorLog(TAG, "Error Writing OBJECT to interlal application storage !");
        }
    }

    public static Object readObjectFromInternalStorage(Context context, String key) {
        Object object = null;
        try {
            FileInputStream fis = context.openFileInput(key);
            ObjectInputStream ois = new ObjectInputStream(fis);
            object = ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception e) {
            SDKLogger.printErrorLog(TAG, "Error Reading OBJECT from interlal application storage !");
        }
        return object;
    }

    public static boolean removeObjectFromInternalStorage(Context context, String key) {
        boolean res = false;
        try {
            res = context.deleteFile(key);
        }
        catch (Exception e) {
            SDKLogger.printErrorLog(TAG, "Error Deleteing OBJECT from interlal application storage !");
        }
        return res;
    }

    public static void writeObject(File filePath, Object object) {
        try {
            if (filePath.exists()) {
                filePath.delete();
            }
            if (!filePath.exists()) {
                filePath.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(filePath);
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(object);
            out.flush();
            out.close();
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error Writing object to External Cache folder \n " + ex.getMessage());
        }
    }

    public static Object readObject(File filePath) {
        Object object = null;
        try {
            if (filePath.exists()) {
                FileInputStream fos = new FileInputStream(filePath);
                ObjectInputStream ois = new ObjectInputStream(fos);
                object = ois.readObject();
                ois.close();
                fos.close();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error Reading object from External Cache folder \n " + ex.getMessage());
        }
        return object;
    }

    public static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    public static File getBackgroundsFolderLocationPath() {
        File photoDir;
        File outputDir = null;
        if (SdkDeviceUtils.isExternalStorageWritable() && !(outputDir = new File(photoDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "Backgrounds")).exists() && !outputDir.mkdirs()) {
            SDKLogger.printErrorLog(TAG, "Failed to create directory " + outputDir.getAbsolutePath());
            outputDir = null;
        }
        return outputDir;
    }

    public static int getDeviceDefaultOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Configuration config = context.getResources().getConfiguration();
        int rotation = windowManager.getDefaultDisplay().getRotation();
        if ((rotation == 0 || rotation == 2) && config.orientation == 2 || (rotation == 1 || rotation == 3) && config.orientation == 1) {
            return 2;
        }
        return 1;
    }

    public static String getPicturePathFromUri(Context context, Uri pictureUri) {
        String result = null;
        if (pictureUri != null) {
            String[] proj = new String[]{"_data"};
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = contentResolver.query(pictureUri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            result = cursor.getString(column_index);
            cursor.close();
        }
        return result;
    }

    public static double getDeviceDPIFactor(Context context) {
        double result = 1.0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        switch (metrics.densityDpi) {
            case 120: {
                result = 0.75;
                break;
            }
            case 160: {
                result = 1.0;
                break;
            }
            case 240: {
                result = 1.5;
                break;
            }
            case 320: {
                result = 2.0;
                break;
            }
            case 480: {
                result = 3.0;
                break;
            }
            case 640: {
                result = 4.0;
            }
        }
        return result;
    }

    public static boolean getIsKidozSetAsDefaultLauncher(Context context) {
        boolean result = false;
        String currentLauncherPackageName = SdkDeviceUtils.getCurrentDefaultLauncherPackageName(context);
        if (currentLauncherPackageName != null && currentLauncherPackageName.equals(context.getPackageName())) {
            result = true;
        }
        return result;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        try {
            if (!sourceFile.exists()) {
                return;
            }
            FileChannel source = null;
            FileChannel destination = null;
            FileInputStream fis = new FileInputStream(sourceFile);
            source = fis.getChannel();
            FileOutputStream fos = new FileOutputStream(destFile);
            destination = fos.getChannel();
            if (destination != null && source != null) {
                destination.transferFrom(source, 0L, source.size());
            }
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
            fis.close();
            fos.flush();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean getIsAppInstalledByIntentFilter(Context context, String appIntentFilter) {
        boolean result = false;
        if (appIntentFilter != null) {
            Intent appIntent = new Intent(appIntentFilter);
            PackageManager packageManager = context.getPackageManager();
            List resultActivities = packageManager.queryIntentActivities(appIntent, 65536);
            if (resultActivities != null && resultActivities.size() > 0) {
                result = true;
            }
        }
        return result;
    }

    public static String getActivityNameByIntentFilter(Context context, String appIntentFilter) {
        String name = null;
        if (appIntentFilter != null) {
            Intent appIntent = new Intent(appIntentFilter);
            PackageManager packageManager = context.getPackageManager();
            List resultActivities = packageManager.queryIntentActivities(appIntent, 65536);
            if (resultActivities != null && resultActivities.size() > 0) {
                name = ((ResolveInfo)resultActivities.get((int)0)).resolvePackageName;
            }
        }
        return name;
    }

    public static boolean getIsAppInstalledByPckgName(Context context, String packageName) {
        return context.getPackageManager().getLaunchIntentForPackage(packageName) != null;
    }

    public void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            String[] children;
            if (!targetLocation.exists() && !targetLocation.mkdirs()) {
                throw new IOException("Cannot create dir " + targetLocation.getAbsolutePath());
            }
            for (String aChildren : children = sourceLocation.list()) {
                this.copyDirectory(new File(sourceLocation, aChildren), new File(targetLocation, aChildren));
            }
        } else {
            int len;
            File directory = targetLocation.getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                throw new IOException("Cannot create dir " + directory.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            out.flush();
            ((OutputStream)out).close();
        }
    }

    public static boolean deleteFolder(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String aChildren : children = dir.list()) {
                boolean success = SdkDeviceUtils.deleteFolder(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getGoogleAdvertisingID(Context context) {
        String GOOGLE_ADVERTISING_ID_KEY = "GOOGLE_ADVERTISING_ID_KEY";
        String result = SharedPreferencesUtils.loadSharedPreferencesData(context, GOOGLE_ADVERTISING_ID_KEY);
        if (result == null || result.equals("")) {
            SdkDeviceUtils.generateGoogleAdvertisingIDInBackground(context);
        }
        SDKLogger.printDebugLog(TAG, ">>>>Google advertising ID = " + result);
        return result;
    }

    public static synchronized void generateGoogleAdvertisingIDInBackground(final Context context) {
        if (context != null) {
            AsyncTask<Void, Void, Void> registerInBackground = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    String GOOGLE_ADVERTISING_ID_KEY = "GOOGLE_ADVERTISING_ID_KEY";
                    try {
                        String googleAdvertisingID = CustomAdvertisingIdClient.getAdvertisingIdInfo(context).getId();
                        SharedPreferencesUtils.saveSharedPreferencesData(context, GOOGLE_ADVERTISING_ID_KEY, googleAdvertisingID);
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to get google advertising ID: " + ex.getMessage());
                    }
                    return null;
                }
            };
            registerInBackground.execute((Object[])new Void[]{null, null, null});
        }
    }

    public static File getInnerStoragePathIfPosible(Context context) {
        File filePath = null;
        try {
            File[] files;
            String state = Environment.getExternalStorageState();
            if ("mounted".equals(state) && (files = ContextCompat.getExternalFilesDirs((Context)context, null)).length > 0) {
                boolean ok = false;
                filePath = files[0];
                if (filePath != null && filePath.exists()) {
                    if (!(filePath = new File(filePath.getAbsolutePath() + File.separator + "KsdkTemp")).exists()) {
                        filePath.mkdirs();
                    }
                    if (filePath.exists()) {
                        ok = true;
                    }
                }
                if (!ok && files.length > 1 && (filePath = files[1]) != null && filePath.exists() && !(filePath = new File(filePath.getAbsolutePath() + File.separator + "KsdkTemp")).exists()) {
                    filePath.mkdirs();
                }
            }
        }
        catch (Exception e) {
            SDKLogger.printErrorLog("Problem initiating storage location: \n\n" + e.getMessage());
        }
        return filePath;
    }
}

