/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.interfaces.KidozPlayerEventHelper;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.ui_views.feed_view.FeedFamilyViewDialog;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class FeedView {
    public static final String KIDOZ_FEED_BUTTON = "feedButton";
    public static final String TAG = FeedView.class.getSimpleName();
    private Builder mBuilder;
    private Lock raceConditionLock = new ReentrantLock();
    private FeedFamilyViewDialog mFamilyViewDialog;
    protected ContentLogicLoader mContentLogicLoader;
    protected IOnFeedViewEventListener mOnFeedViewEventListener;
    protected boolean mIsAutomaticInvocation = false;
    protected boolean mIsShowing = false;
    protected boolean mShowWhenInitiated = false;
    protected JSONObject mJsonObjectProperties;
    private KidozPlayerEventHelper mKidozPlayerEventHelper;
    private DialogInterface.OnDismissListener dismissListener;
    private KidozPlayerListener mKidozPlayerListener;
    private boolean mIsViewReadyCalled = false;
    private boolean mIsReadyToShowCalled = false;

    public void setKidozPlayerListener(KidozPlayerListener kidozPlayerListener) {
        this.mKidozPlayerListener = kidozPlayerListener;
    }

    protected FeedView(Builder builder) {
        this.mBuilder = builder;
        this.initContentLogicLoader();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.mKidozPlayerEventHelper = new KidozPlayerEventHelper(new KidozPlayerEventHelper.IPlayerListener(){

            @Override
            public void onOpen(boolean isMaximizedPlayer) {
                if (FeedView.this.mKidozPlayerListener != null) {
                    FeedView.this.mKidozPlayerListener.onPlayerOpen();
                }
                if (FeedView.this.mFamilyViewDialog != null && FeedView.this.mFamilyViewDialog.isShowing()) {
                    FeedView.this.mFamilyViewDialog.pauseAction(isMaximizedPlayer);
                }
            }

            @Override
            public void onClose(boolean isMaximizedPlayer) {
                if (FeedView.this.mKidozPlayerListener != null) {
                    FeedView.this.mKidozPlayerListener.onPlayerClose();
                }
                if (FeedView.this.mFamilyViewDialog != null && FeedView.this.mFamilyViewDialog.isShowing()) {
                    FeedView.this.mFamilyViewDialog.resumeAction(isMaximizedPlayer);
                }
            }
        }, WidgetType.WIDGET_TYPE_FEED);
        this.dismissListener = new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (FeedView.this.mKidozPlayerEventHelper != null) {
                    FeedView.this.mKidozPlayerEventHelper.unRegister();
                }
                if (FeedView.this.mOnFeedViewEventListener != null) {
                    FeedView.this.mOnFeedViewEventListener.onDismissView();
                }
                FeedView.this.mIsShowing = false;
            }
        };
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    private void unregisterEventBus() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    private void validateLayoutAndAssets() {
        this.unregisterEventBus();
        if (this.raceConditionLock.tryLock()) {
            try {
                AssetUtil.parseStyleAsync(this.mBuilder.mContext, AssetUtil.ParserAsyncTask.StyleType.FEED_STYLE, new AssetUtil.ParserAsyncTask.IOnStyleParseListener(){

                    @Override
                    public void onParseFinished(boolean success) {
                        if (success) {
                            FeedView.this.mJsonObjectProperties = DatabaseManager.getInstance(FeedView.this.mBuilder.mContext).getConfigTable().loadProperties(TAG);
                            if (FeedView.this.mJsonObjectProperties != null) {
                                EventBus.getDefault().post((Object)new EventMessage(EventMessage.MessageType.INIT_FEED_BUTTON));
                                if (FeedView.this.mOnFeedViewEventListener != null) {
                                    FeedView.this.mOnFeedViewEventListener.onViewReady();
                                } else {
                                    FeedView.this.mIsViewReadyCalled = true;
                                }
                                if (FeedView.this.mShowWhenInitiated) {
                                    FeedView.this.showView();
                                }
                            }
                        }
                    }
                });
            }
            finally {
                this.raceConditionLock.unlock();
            }
        }
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                FeedView.this.mFamilyViewDialog.setContentData(contentData);
                SdkCookieManager.resetStorage(FeedView.this.mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED.getStringValue(), StorageLife.WIDGET);
            }

            @Override
            public void onLoadContentFailed() {
            }

            @Override
            public void onNoContentOffers() {
            }
        });
    }

    public void showView() {
        this.showViewInner();
    }

    private void showViewInner() {
        if (KidozSDK.isInitialised()) {
            this.mIsAutomaticInvocation = true;
            if (this.mJsonObjectProperties == null) {
                this.mJsonObjectProperties = DatabaseManager.getInstance(this.mBuilder.mContext).getConfigTable().loadProperties(TAG);
            }
            if (this.mJsonObjectProperties != null) {
                this.openSimpleDialog();
            } else {
                this.mShowWhenInitiated = true;
            }
        } else {
            this.mShowWhenInitiated = true;
        }
    }

    protected synchronized void openSimpleDialog() {
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.register();
        }
        if (this.mJsonObjectProperties != null && this.mBuilder.mContext != null && this.mBuilder.mContext instanceof Activity && !((Activity)this.mBuilder.mContext).isFinishing()) {
            if (this.mFamilyViewDialog == null || !this.mFamilyViewDialog.isShowing() && !this.mFamilyViewDialog.isWaitingToOpen()) {
                this.mFamilyViewDialog = new FeedFamilyViewDialog(this.mBuilder.mContext, this.mOnFeedViewEventListener, this.mIsAutomaticInvocation, this.mJsonObjectProperties);
                this.mFamilyViewDialog.setOnDismissListener(this.dismissListener);
                this.mFamilyViewDialog.setOnCloseButtonClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FeedView.this.dismissView();
                        FeedView.this.unregisterEventBus();
                    }
                });
                if (this.mOnFeedViewEventListener != null) {
                    this.mOnFeedViewEventListener.onReadyToShow();
                } else {
                    this.mIsReadyToShowCalled = true;
                }
                this.mFamilyViewDialog.openDialog();
                if (this.mJsonObjectProperties != null) {
                    this.mContentLogicLoader.loadContent(this.mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED.getStringValue(), this.mJsonObjectProperties.optString("style_id"));
                }
            }
            this.mShowWhenInitiated = false;
        }
    }

    public void dismissView() {
        if (this.mFamilyViewDialog != null) {
            this.mFamilyViewDialog.closeDialog();
        }
    }

    public void setOnFeedViewEventListener(IOnFeedViewEventListener listener) {
        this.mOnFeedViewEventListener = listener;
        if (this.mFamilyViewDialog != null) {
            this.mFamilyViewDialog.setOnInterstitialViewEventListener(this.mOnFeedViewEventListener);
        }
        if (this.mIsViewReadyCalled) {
            this.mIsViewReadyCalled = false;
            this.mOnFeedViewEventListener.onViewReady();
        }
        if (this.mIsReadyToShowCalled) {
            this.mIsReadyToShowCalled = false;
            this.mOnFeedViewEventListener.onReadyToShow();
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context context) {
            this.mContext = context;
        }

        public FeedView build() {
            return new FeedView(this);
        }
    }
}

