/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.video_unit;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.structure.IsEventRecord;
import java.util.List;
import org.json.JSONObject;

public class RedirectManager {
    private final String TAG = RedirectManager.class.getSimpleName();
    private final long MAX_REDIRECT_TIME = 5000L;
    private String[] mAppStoreArray;
    private FullScreenVideoEnabledWebView mWebView;
    private String mGooglePlayAppPrefix = "market://details?id=";
    private String mGooglePlayWebsitePrefix = "https://play.google.com/store/apps/details?id=";
    private String mYoutubePrefix = "youtube.com";
    private Handler mHandler;
    private Runnable mHandlerRunnable;
    private String mLastLoadedURL;
    private IsEventRecord mIsEventRecord;
    private RedirectManagerListener mRedirectManagerListener;

    public RedirectManager(Context context) {
        this.init(context);
    }

    public void setRedirectManagerListener(RedirectManagerListener redirectManagerListener) {
        this.mRedirectManagerListener = redirectManagerListener;
    }

    public void setItemDetails(String itemDetailsJson) {
        this.mIsEventRecord = null;
        try {
            if (itemDetailsJson != null) {
                JSONObject json = new JSONObject(itemDetailsJson);
                this.mIsEventRecord = new IsEventRecord();
                this.mIsEventRecord.setPackageName(json.optString("packageName"));
                this.mIsEventRecord.setContentType(json.optString("contentType"));
                this.mIsEventRecord.setName(json.optString("name"));
                this.mIsEventRecord.setPositionIndex(json.optInt("position"));
                this.mIsEventRecord.setAdvertiserId(json.optString("advertiserId"));
                this.mIsEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                this.mIsEventRecord.setWidgetType(json.optString("widgetType"));
                this.mIsEventRecord.setStyleId(json.optString("styleId"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopRedirectHandler() {
        this.mHandler.removeCallbacks(this.mHandlerRunnable);
    }

    private void init(Context context) {
        this.mAppStoreArray = new String[]{this.mGooglePlayAppPrefix, this.mGooglePlayWebsitePrefix};
        this.mHandler = new Handler();
        this.mHandlerRunnable = new Runnable(){

            @Override
            public void run() {
                RedirectManager.this.launchURLIntent(RedirectManager.this.mLastLoadedURL);
            }
        };
        this.initWebView(context);
    }

    private boolean getIsAppStoreLink(String url) {
        boolean result = false;
        if (this.mIsEventRecord != null && this.mIsEventRecord.getPackageName() != null) {
            for (String nextStorePrefix : this.mAppStoreArray) {
                if (!url.contains(nextStorePrefix)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void initWebView(Context context) {
        this.mWebView = new FullScreenVideoEnabledWebView(context);
        this.mWebView.initWebViewSettings();
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                boolean result = false;
                RedirectManager.this.mLastLoadedURL = url;
                RedirectManager.this.stopRedirectHandler();
                if (RedirectManager.this.getIsAppStoreLink(url)) {
                    RedirectManager.this.launchURLIntent(url);
                    result = true;
                } else {
                    RedirectManager.this.restartRedirectHandler();
                }
                return result;
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                RedirectManager.this.stopRedirectHandler();
                RedirectManager.this.notifyRedirectFinished(true);
            }
        });
    }

    private void restartRedirectHandler() {
        this.stopRedirectHandler();
        this.mHandler.postDelayed(this.mHandlerRunnable, 5000L);
    }

    private void notifyRedirectFinished(boolean isError) {
        if (this.mRedirectManagerListener != null) {
            this.mRedirectManagerListener.onRedirectEnd(isError);
        }
    }

    private void launchURLIntent(String url) {
        boolean isCanLaunchIntent = false;
        if (this.mIsEventRecord == null || this.mIsEventRecord.getPackageName() == null) {
            isCanLaunchIntent = true;
        } else if (url.contains(this.mIsEventRecord.getPackageName())) {
            isCanLaunchIntent = true;
            if (url.contains(this.mGooglePlayWebsitePrefix)) {
                String googlePlayAppURL = url.replace(this.mGooglePlayWebsitePrefix, this.mGooglePlayAppPrefix);
                Intent googlePlayAppIntent = new Intent("android.intent.action.VIEW");
                googlePlayAppIntent.setData(Uri.parse((String)googlePlayAppURL));
                List intentArray = this.mWebView.getContext().getPackageManager().queryIntentActivities(googlePlayAppIntent, 0);
                if (intentArray != null || !intentArray.isEmpty()) {
                    url = googlePlayAppURL;
                }
            }
        }
        if (isCanLaunchIntent) {
            this.saveItemDetailsToDataBase();
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.mWebView.getContext().startActivity(intent);
            this.notifyRedirectFinished(false);
        } else {
            this.notifyRedirectFinished(true);
        }
    }

    private void saveItemDetailsToDataBase() {
        try {
            if (this.mIsEventRecord != null) {
                DatabaseManager.getInstance(this.mWebView.getContext()).getIsEventTable().insertRecord(this.mIsEventRecord);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadURL(String url) {
        this.mLastLoadedURL = url;
        this.stopRedirectHandler();
        if (!url.contains(this.mYoutubePrefix)) {
            if (this.mRedirectManagerListener != null) {
                this.mRedirectManagerListener.onRedirectStarted();
            }
            if (this.getIsAppStoreLink(url)) {
                this.launchURLIntent(url);
            } else {
                this.restartRedirectHandler();
                this.mWebView.loadUrl(url);
            }
        }
    }

    public static interface RedirectManagerListener {
        public void onRedirectStarted();

        public void onRedirectEnd(boolean var1);
    }
}

