/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.one_item_view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Looper;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.AnotherInterface;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.html_view.MaximizedViewDialog;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.panel_view.OneContentItemView;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class OneItemFamilyView
extends RelativeLayout {
    private Lock mLock;
    protected static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.35f;
    protected static final int ITEM_CONTAINER_STROKE_WIDTH = 4;
    protected int AUTO_SCROLL_DELAY = 12000;
    public AutoScrollViewPager mViewPager;
    protected LoadingProgressView mLoadingProgressView;
    protected AssetView mMaximizeBtn;
    protected HtmlViewWrapper mHtmlDefaultView;
    protected HtmlViewWrapper mHtmlSpecialView;
    public KidozCardView mViewPagerCardContainerView;
    private Utils.StaticHandler staticHandler;
    protected ItemViewPagerAdapter mAdapter;
    protected HashMap<String, Integer> mContentDisplayed = new HashMap();
    protected ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    protected String mMaximizeBtnUrl;
    protected int mThumbContainerBgColor;
    protected JSONObject mProperties;
    protected String mWidgetType;
    protected String mStyleId;
    protected boolean mIsEnabled = false;
    protected PlaybackState mPlaybackState = PlaybackState.STOPED;
    protected ContentItem mCurrentItemInView;
    protected int mCurrentViewPagerIndexInFocus = 0;
    protected int mPreviousViewPagerIndexInFocus = -1;
    protected MaximizedViewDialog mMaximizedViewDialog;
    protected IOnOneItemActionListener mOneItemActionListener;
    protected int mWidth;
    protected int mHeight;
    private IOnRefreshListener mRefreshListener;
    private AnotherInterface mAnotherInterface;

    public OneItemFamilyView(Context context, String widgetType, String styleId, JSONObject properties, IOnOneItemActionListener listener) {
        super(context);
        this.staticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        this.mLock = new ReentrantLock();
        this.mProperties = properties;
        this.mWidgetType = widgetType;
        this.mStyleId = styleId;
        this.mOneItemActionListener = listener;
        this.applyStyleProperties();
        this.initView();
        Utils.setOnGlobalLayoutFinishListener((View)this, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                int size;
                OneItemFamilyView.this.mWidth = OneItemFamilyView.this.getMeasuredWidth();
                OneItemFamilyView.this.mHeight = OneItemFamilyView.this.getMeasuredHeight();
                OneItemFamilyView.this.mAdapter = new ItemViewPagerAdapter(OneItemFamilyView.this.mProperties, OneItemFamilyView.this.mWidth, OneItemFamilyView.this.mHeight);
                OneItemFamilyView.this.mAdapter.setViewPagerItemClickListener(OneItemFamilyView.this.mViewPagerItemClickListener);
                OneItemFamilyView.this.mViewPager.setAdapter(OneItemFamilyView.this.mAdapter);
                OneItemFamilyView.this.mAdapter.setContent(new ArrayList<ContentItem>());
                OneItemFamilyView.this.mAdapter.notifyDataSetChanged();
                OneItemFamilyView.this.mAdapter.setOnItemInstantiateFinishListener(new ItemViewPagerAdapter.IOnItemInstaniateFinishListener(){

                    @Override
                    public void onFirstItemReady() {
                        if (OneItemFamilyView.this.mWidgetType.equals(WidgetType.WIDGET_TYPE_FEED.getStringValue())) {
                            OneItemFamilyView.this.refreshNextViewItem(0);
                        }
                    }
                });
                OneItemFamilyView.this.mMaximizeBtn.getLayoutParams().width = size = (int)((float)OneItemFamilyView.this.mWidth * 0.22f);
                OneItemFamilyView.this.mMaximizeBtn.getLayoutParams().height = size;
            }
        });
    }

    protected void applyStyleProperties() {
        if (this.mProperties != null) {
            this.mMaximizeBtnUrl = this.mProperties.optString("htmlMaximizeBtn", null);
            this.AUTO_SCROLL_DELAY = this.mProperties.optInt("swapContentRefreshRateSec", 12) * 1000;
            this.mThumbContainerBgColor = Color.parseColor((String)this.mProperties.optString("thumbBgColor", "#ccffffff"));
        }
    }

    protected void initView() {
        this.initPagerContainerCard();
        this.initViewPager();
        this.initHtmlDefaultWebView();
        this.initHtmlSpecialWebView();
        this.initLoadingProgressView();
        this.initMaximizeButton();
    }

    private void initPagerContainerCard() {
        this.mViewPagerCardContainerView = new KidozCardView(this.getContext());
        this.mViewPagerCardContainerView.setId(Utils.generateViewId());
        this.mViewPagerCardContainerView.setRadius(Utils.dpTOpx(this.getContext(), 4.0f));
        this.mViewPagerCardContainerView.setCardBackgroundColor(this.mThumbContainerBgColor);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mViewPagerCardContainerView, (ViewGroup.LayoutParams)params);
    }

    private void initHtmlDefaultWebView() {
        this.mHtmlDefaultView = HtmlManager.getDefaultHtmlView(this.getContext());
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.setInFocusActivityContext(this.getContext());
            this.mHtmlDefaultView.setWidgetType(this.mWidgetType);
            this.mHtmlDefaultView.setStyleID(this.mStyleId);
            this.applyListenerToDefaultHtmlView();
        }
    }

    private void applyListenerToDefaultHtmlView() {
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void toggleWidgetState(boolean isEnabled) {
                    if (OneItemFamilyView.this.mAnotherInterface != null) {
                        OneItemFamilyView.this.mAnotherInterface.toggleWidgetState(isEnabled);
                    }
                }

                @Override
                public void onOpenMaximized() {
                    OneItemFamilyView.this.openMaximizedDialogVew(OneItemFamilyView.this.mCurrentItemInView);
                }

                @Override
                public void onDonePlayBack() {
                    OneItemFamilyView.this.startAutoScroll();
                    OneItemFamilyView.this.nextPagerItem();
                }

                @Override
                public void onHtmlFinishedLoading() {
                    super.onHtmlFinishedLoading();
                    OneItemFamilyView.this.staticHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (OneItemFamilyView.this.mRefreshListener != null) {
                                OneItemFamilyView.this.mRefreshListener.onRefreshDrawRequest();
                            }
                        }
                    }, 100L);
                }
            });
        }
    }

    private void initHtmlSpecialWebView() {
        this.mHtmlSpecialView = new HtmlViewWrapper(this.getContext(), false);
        this.mHtmlSpecialView.setInFocusActivityContext(this.getContext());
        this.mHtmlSpecialView.setWidgetType(this.mWidgetType);
        this.mHtmlSpecialView.setStyleID(this.mStyleId);
        this.applyListenerToSpecialHtmlView();
        this.mHtmlSpecialView.setVisibility(8);
    }

    private void applyListenerToSpecialHtmlView() {
        if (this.mHtmlSpecialView != null) {
            this.mHtmlSpecialView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void toggleWidgetState(boolean isEnabled) {
                    if (OneItemFamilyView.this.mAnotherInterface != null) {
                        OneItemFamilyView.this.mAnotherInterface.toggleWidgetState(isEnabled);
                    }
                }

                @Override
                public void onHtmlStartLoading() {
                    if (OneItemFamilyView.this.mHtmlSpecialView.getVisibility() == 0) {
                        OneItemFamilyView.this.mHtmlSpecialView.showLoadingProgressView();
                    }
                    OneItemFamilyView.this.mMaximizeBtn.setVisibility(4);
                }

                @Override
                public void onHtmlFinishedLoading() {
                    if (OneItemFamilyView.this.mHtmlSpecialView.getVisibility() == 0) {
                        OneItemFamilyView.this.mHtmlSpecialView.hideLoadingProgressView();
                    }
                    if (OneItemFamilyView.this.mCurrentItemInView != null) {
                        if (OneItemFamilyView.this.mCurrentItemInView.getShouldDisplayMaximizeButton()) {
                            OneItemFamilyView.this.mMaximizeBtn.setVisibility(0);
                        } else {
                            OneItemFamilyView.this.mMaximizeBtn.setVisibility(4);
                        }
                    }
                }
            });
        }
    }

    private void initMaximizeButton() {
        this.mMaximizeBtn = new AssetView(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(7, this.mViewPagerCardContainerView.getId());
        params.addRule(8, this.mViewPagerCardContainerView.getId());
        params.setMargins(0, 0, Utils.dpTOpx(this.getContext(), 5.0f), Utils.dpTOpx(this.getContext(), 5.0f));
        this.addView((View)this.mMaximizeBtn, (ViewGroup.LayoutParams)params);
        this.mMaximizeBtn.setVisibility(4);
        this.mMaximizeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 70, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        OneItemFamilyView.this.openMaximizedDialogVew(OneItemFamilyView.this.mCurrentItemInView);
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        this.mMaximizeBtn.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mMaximizeBtnUrl), null);
    }

    private void refreshNextViewItem(int viewPagerIndex) {
        if (this.mAdapter.getRealCount() > 0) {
            int realContentPosition = viewPagerIndex % this.mAdapter.getRealCount();
            if (this.mIsEnabled) {
                this.stopAutoScroll();
                this.mCurrentViewPagerIndexInFocus = viewPagerIndex;
                this.sendImpressionLog(realContentPosition);
                if (this.mPreviousViewPagerIndexInFocus != -1 && this.mPreviousViewPagerIndexInFocus != this.mCurrentViewPagerIndexInFocus) {
                    View view;
                    ContentItem prevItem = this.mAdapter.getContentItem(this.mPreviousViewPagerIndexInFocus % this.mAdapter.getRealCount());
                    if (prevItem != null && prevItem.getContentType() == ContentType.HTML) {
                        if (prevItem.getIsNonDefaultHtml()) {
                            this.mHtmlSpecialView.clearHtmlView();
                        } else {
                            this.mHtmlDefaultView.requestFocusOff();
                        }
                    }
                    if ((view = this.mViewPager.findViewWithTag(this.mPreviousViewPagerIndexInFocus)) != null && view != null) {
                        ((OneContentItemView)view).clearActiveWebView();
                    }
                    this.mPreviousViewPagerIndexInFocus = -1;
                }
                this.mCurrentItemInView = this.mAdapter.getContentItem(realContentPosition);
                if (this.mCurrentItemInView != null && this.mCurrentItemInView.getContentType() == ContentType.HTML) {
                    View view = this.mViewPager.findViewWithTag(this.mCurrentViewPagerIndexInFocus);
                    if (view != null) {
                        OneContentItemView panelContentItem = (OneContentItemView)view;
                        if (this.mCurrentItemInView.getIsNonDefaultHtml()) {
                            if (panelContentItem != null) {
                                panelContentItem.setActiveWebView(this.mHtmlSpecialView);
                            }
                            this.mHtmlDefaultView.setVisibility(4);
                            this.mHtmlSpecialView.setVisibility(0);
                            this.mHtmlSpecialView.clearHtmlView();
                            this.mHtmlSpecialView.setData(this.mCurrentItemInView);
                            this.mHtmlSpecialView.reloadHtml();
                            if (this.mOneItemActionListener != null) {
                                this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
                            }
                        } else {
                            this.mHtmlSpecialView.setVisibility(4);
                            if (this.mHtmlDefaultView != null) {
                                this.mHtmlDefaultView.setData(this.mCurrentItemInView);
                                if (panelContentItem != null) {
                                    panelContentItem.setActiveWebView(this.mHtmlDefaultView);
                                }
                                this.mHtmlDefaultView.setVisibility(0);
                                this.staticHandler.postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (OneItemFamilyView.this.mRefreshListener != null) {
                                            OneItemFamilyView.this.mRefreshListener.onRefreshDrawRequest();
                                        }
                                        OneItemFamilyView.this.mHtmlDefaultView.requestFocusOn(false);
                                    }
                                }, 100L);
                            }
                            if (this.mOneItemActionListener != null) {
                                this.mOneItemActionListener.onAction(OneItemAction.STOP_ANY_ANIMATION);
                            }
                        }
                        if (this.mCurrentItemInView.getShouldDisplayMaximizeButton()) {
                            this.mMaximizeBtn.setVisibility(0);
                        } else {
                            this.mMaximizeBtn.setVisibility(4);
                        }
                        this.mPreviousViewPagerIndexInFocus = this.mCurrentViewPagerIndexInFocus;
                    }
                } else {
                    this.startAutoScroll();
                    if (this.mHtmlDefaultView != null) {
                        this.mHtmlDefaultView.setVisibility(4);
                    }
                    this.mHtmlSpecialView.setVisibility(4);
                    this.mMaximizeBtn.setVisibility(4);
                    if (this.mOneItemActionListener != null) {
                        this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
                    }
                }
            }
        }
    }

    private void initLoadingProgressView() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        this.mLoadingProgressView.setVisibility(8);
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.35f);
        LinearLayout layout = new LinearLayout(this.getContext());
        layout.setGravity(17);
        layout.addView((View)this.mLoadingProgressView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(size, size));
        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(-1, -1);
        prParams.addRule(5, this.mViewPagerCardContainerView.getId());
        prParams.addRule(7, this.mViewPagerCardContainerView.getId());
        this.addView((View)layout, (ViewGroup.LayoutParams)prParams);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int size;
        super.onSizeChanged(w, h, oldw, oldh);
        this.mLoadingProgressView.getLayoutParams().height = size = (int)((float)Math.min(w, h) * 0.35f);
        this.mLoadingProgressView.getLayoutParams().width = size;
        this.mLoadingProgressView.setCircleWidthRelativeToSize(w);
    }

    private void initViewPager() {
        this.mViewPager = new AutoScrollViewPager(this.getContext());
        this.mViewPager.setInterval(this.AUTO_SCROLL_DELAY);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (OneItemFamilyView.this.mRefreshListener != null) {
                    OneItemFamilyView.this.mRefreshListener.onRefreshDrawRequest();
                }
            }

            public void onPageSelected(int position) {
                if (OneItemFamilyView.this.mAdapter.getRealCount() > 0) {
                    OneItemFamilyView.this.mAdapter.toggleIsClickable(false);
                    OneItemFamilyView.this.staticHandler.removeCallbacks(null);
                    OneItemFamilyView.this.staticHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            OneItemFamilyView.this.mAdapter.toggleIsClickable(true);
                        }
                    }, 750L);
                    OneItemFamilyView.this.refreshNextViewItem(position);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mViewPager.setId(Utils.generateViewId());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mViewPager.setPageMargin(Utils.dpTOpx(this.getContext(), 3.0f));
        this.mViewPager.setClipToPadding(false);
        int margin = Utils.dpTOpx(this.getContext(), 4.0f);
        this.mViewPagerCardContainerView.setContentPadding(margin, margin, margin, margin);
        this.mViewPagerCardContainerView.addView((View)this.mViewPager, (ViewGroup.LayoutParams)params);
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = this.mAdapter.getContentItem(position);
        if (contentItem != null && this.mContentDisplayed != null && !this.mContentDisplayed.containsKey(contentItem.getId()) && !contentItem.getIsAvoidAutoImpression()) {
            if (contentItem.isPromoted()) {
                EventManager.getInstance(this.getContext()).logSponsoredContentImpressionEvent(this.getContext(), this.mWidgetType, this.mStyleId, "Impression", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
            } else {
                EventManager.getInstance(this.getContext()).logOrganicContentImpressionEvent(this.getContext(), this.mWidgetType, this.mStyleId, "Impression", contentItem.getName(), contentItem.getId(), position);
            }
            this.mContentDisplayed.put(contentItem.getId(), position);
            if (contentItem.getThirdPartyImpressionBeacon() != null) {
                BaseConnectionClient.makeAsyncGet(contentItem.getThirdPartyImpressionBeacon(), null);
            }
        }
    }

    public void showLoadingProgressView(boolean show) {
        if (show) {
            this.mLoadingProgressView.startLoadingAnimation();
        } else {
            this.mLoadingProgressView.stopLoadingAnimation();
        }
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener) {
        this.mViewPagerItemClickListener = viewPagerItemClickListener;
        this.mHtmlDefaultView.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
        this.mHtmlSpecialView.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
    }

    public void setContent(ArrayList<ContentItem> content) {
        if (this.mLock.tryLock()) {
            this.mCurrentViewPagerIndexInFocus = 0;
            this.mPreviousViewPagerIndexInFocus = -1;
            try {
                this.mContentDisplayed.clear();
                if (this.mAdapter != null) {
                    this.mAdapter.setContent(content);
                    this.mViewPager.setCurrentItem(0);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    public void clearContent() {
        this.mContentDisplayed.clear();
        if (this.mAdapter != null) {
            this.mAdapter.clearContent();
        }
    }

    public void startAutoScroll() {
        if (!this.mViewPager.isAutoScrollOn()) {
            this.mViewPager.startAutoScroll(this.AUTO_SCROLL_DELAY);
        }
    }

    public void stopAutoScroll() {
        this.mViewPager.stopAutoScroll();
    }

    public boolean isEmpty() {
        if (this.mAdapter == null) {
            return true;
        }
        return this.mAdapter.isAdapterEmpty();
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event != null && event.getMessageType() == EventMessage.MessageType.HTML_FULL_VIEW_CLOSE && event.getAdditionalParam() != null && event.getAdditionalParam().equals(this.mWidgetType)) {
            this.onMaximizedScreenPlayerViewClosed();
        }
    }

    protected void openMaximizedDialogVew(ContentItem contentItem) {
        this.stopAutoScroll();
        if (contentItem != null) {
            this.mMaximizedViewDialog = contentItem.getIsNonDefaultHtml() ? new MaximizedViewDialog(this.getContext(), this.mWidgetType, this.mStyleId, this.mHtmlSpecialView) : new MaximizedViewDialog(this.getContext(), this.mWidgetType, this.mStyleId, this.mHtmlDefaultView);
            this.mMaximizedViewDialog.loadHtmlView(contentItem);
            this.mMaximizedViewDialog.openDialog();
        }
        if (this.mOneItemActionListener != null) {
            this.mOneItemActionListener.onAction(OneItemAction.STOP_ANY_ANIMATION);
        }
    }

    protected void onMaximizedScreenPlayerViewClosed() {
        if (this.mCurrentItemInView.getIsNonDefaultHtml()) {
            this.applyListenerToSpecialHtmlView();
            this.mHtmlSpecialView.reloadHtml();
            if (this.mOneItemActionListener != null) {
                this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
            }
        } else {
            this.applyListenerToDefaultHtmlView();
            if (this.mCurrentViewPagerIndexInFocus != -1) {
                View view = this.mViewPager.findViewWithTag(this.mCurrentViewPagerIndexInFocus);
                if (view != null) {
                    OneContentItemView panelContentItem = (OneContentItemView)view;
                    panelContentItem.setActiveWebView(this.mHtmlDefaultView);
                    this.mHtmlDefaultView.requestMinimize();
                    if (this.mCurrentItemInView != null && this.mCurrentItemInView.getContentType() != ContentType.HTML && this.mOneItemActionListener != null) {
                        this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
                    }
                }
            } else if (this.mOneItemActionListener != null) {
                this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.mHtmlSpecialView != null) {
            this.mHtmlSpecialView.stopAndReleaseWebView();
        }
        this.staticHandler.removeCallbacksAndMessages(null);
    }

    public void nextPagerItem() {
        this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.handleVisibilityChange(visibility);
    }

    public synchronized void handleVisibilityChange(int visibility) {
        if (visibility == 0) {
            this.mHtmlSpecialView.setInFocusActivityContext(this.getContext());
            this.mHtmlDefaultView.setInFocusActivityContext(this.getContext());
            this.startPlaybackAction();
        } else {
            try {
                this.stopPlaybackAction(true);
                this.staticHandler.removeCallbacksAndMessages(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void previousItem() {
        this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() - 1);
    }

    public synchronized void stopPlaybackAction(boolean focusOff) {
        this.stopAutoScroll();
        if (this.mIsEnabled && this.mPlaybackState == PlaybackState.PLAYING) {
            ContentItem item;
            this.mPlaybackState = PlaybackState.STOPED;
            if (this.mAdapter.getRealCount() > 0 && (item = this.mAdapter.getContentItem(this.mCurrentViewPagerIndexInFocus % this.mAdapter.getRealCount())) != null && item.getContentType() == ContentType.HTML) {
                if (item.getIsNonDefaultHtml()) {
                    this.mHtmlSpecialView.clearHtmlView();
                } else if (focusOff) {
                    this.mHtmlDefaultView.requestFocusOff();
                }
            }
        }
    }

    public synchronized void startPlaybackAction() {
        if (this.getVisibility() == 0 && this.mIsEnabled && this.mPlaybackState == PlaybackState.STOPED) {
            this.mPlaybackState = PlaybackState.PLAYING;
            if (this.mAdapter != null && this.mAdapter.getRealCount() > 0) {
                this.refreshNextViewItem(this.mCurrentViewPagerIndexInFocus);
            }
        }
    }

    public void setOnRefreshDrawRequestListener(IOnRefreshListener requestListener) {
        this.mRefreshListener = requestListener;
    }

    public void invokeWidgetOpen() {
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.requestWidgetOpen(this.mWidgetType);
        }
    }

    public void invokeWidgetClose() {
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.requestWidgetClose(this.mWidgetType);
        }
    }

    public void setAnotherInterface(AnotherInterface anotherInterface) {
        this.mAnotherInterface = anotherInterface;
    }

    public void setOneItemEnableState(boolean enableState) {
        this.mIsEnabled = enableState;
    }

    public static interface IOnRefreshListener {
        public void onRefreshDrawRequest();
    }

    public static interface IOnOneItemActionListener {
        public void onAction(OneItemAction var1);
    }

    public static enum OneItemAction {
        STOP_ANY_ANIMATION,
        RESTART_ANY_ANIMATION,
        ON_RESET_AUTO_LAUNCH;

    }

    public static enum PlaybackState {
        PLAYING,
        STOPED;

    }
}

