/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.CloseButtonView;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;

public class BaseInterstitialDialog
extends BaseDialog {
    protected HtmlViewWrapper mWebView;
    protected CloseButtonView mCloseButtonView;
    protected RelativeLayout mInnerContainer;
    protected String mWidgetType;
    protected String mStyleID;
    protected ContentItem mContentItem;

    public BaseInterstitialDialog(Context context, String widgetType, String styleId, HtmlViewWrapper htmlViewWrapper) {
        super(context, 0x1030011, true);
        this.mWidgetType = widgetType;
        this.mStyleID = styleId;
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(false);
        this.mWebView = htmlViewWrapper;
        this.mWebView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

            @Override
            public void onHtmlStartLoading() {
                BaseInterstitialDialog.this.onHtmlStart();
            }

            @Override
            public void onHtmlFinishedLoading() {
                BaseInterstitialDialog.this.onHtmlFinish();
            }

            @Override
            public void onOpenMaximized() {
                BaseInterstitialDialog.this.openMaximized();
            }

            @Override
            public void onClose() {
                BaseInterstitialDialog.this.close();
            }

            @Override
            public void onDonePlayBack() {
                BaseInterstitialDialog.this.donePlayback();
            }

            @Override
            public void onViewReady() {
                BaseInterstitialDialog.this.viewReady();
            }

            @Override
            public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID) {
                if (BaseInterstitialDialog.this.getOwnerActivity() != null) {
                    BaseInterstitialDialog.this.getOwnerActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ContentItem contentItem = new ContentItem();
                            contentItem.setId(appID);
                            contentItem.setName("");
                            contentItem.setData(googlePlayLink);
                            contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                            contentItem.setAdvertiserID(advertiserID);
                            contentItem.setIsPromoted(true);
                            ContentExecutionHandler.handleContentItemClick(BaseInterstitialDialog.this.getContext(), contentItem, widgetType, styleID, 0, false, null);
                        }
                    });
                }
            }
        });
        ViewGroup group = (ViewGroup)this.mWebView.getParent();
        if (group != null) {
            group.removeView((View)this.mWebView);
        }
        this.mInnerContainer = new RelativeLayout(this.getContext());
        this.setContentView((View)this.mInnerContainer, new ViewGroup.LayoutParams(-1, -1));
        this.mInnerContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.initCloseButton();
    }

    protected void onHtmlStart() {
        this.mWebView.showLoadingProgressView();
    }

    protected void onHtmlFinish() {
        if (this.mWebView.isShowClose()) {
            this.mCloseButtonView.setVisibility(0);
        }
        this.mWebView.hideLoadingProgressView();
    }

    protected void openMaximized() {
    }

    protected void close() {
        this.closeDialog();
    }

    protected void donePlayback() {
    }

    protected void viewReady() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    private void initCloseButton() {
        this.mCloseButtonView = new CloseButtonView(this.getContext(), Color.parseColor((String)"#ffffff"));
        this.mCloseButtonView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(-2, -2);
        relParams.addRule(11);
        relParams.setMargins(0, Utils.dpTOpx(this.getContext(), 5.0f), Utils.dpTOpx(this.getContext(), 5.0f), 0);
        this.mCloseButtonView.setPadding(Utils.dpTOpx(this.getContext(), 12.0f), 0, 0, Utils.dpTOpx(this.getContext(), 12.0f));
        this.mInnerContainer.addView((View)this.mCloseButtonView, (ViewGroup.LayoutParams)relParams);
        this.mCloseButtonView.setVisibility(4);
        this.mCloseButtonView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 70, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        BaseInterstitialDialog.this.closeDialog();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }
}

