/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.flexi_view;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.media.ThumbnailUtils;
import com.squareup.imagelib.Transformation;

public class RoundedCornerTransformation
implements Transformation {
    private int mBorder = 0;
    private int mRoundingCorners = 0;
    private int mContainerSize = 0;
    private String mBorderColor;
    private String mFillColor;

    public RoundedCornerTransformation(int borderWith, String borderColor, String fillColor, int roundedRadius, int containerSize) {
        this.mBorder = borderWith;
        this.mBorderColor = borderColor;
        this.mRoundingCorners = roundedRadius;
        this.mContainerSize = containerSize;
        this.mFillColor = fillColor;
    }

    @Override
    public Bitmap transform(Bitmap source) {
        Bitmap squaredBitmap = ThumbnailUtils.extractThumbnail((Bitmap)source, (int)this.mContainerSize, (int)this.mContainerSize);
        source.recycle();
        Bitmap bitmap = Bitmap.createBitmap((int)squaredBitmap.getWidth(), (int)squaredBitmap.getHeight(), (Bitmap.Config)squaredBitmap.getConfig());
        Paint borderPaint = new Paint();
        try {
            borderPaint.setColor(Color.parseColor((String)this.mFillColor));
        }
        catch (Exception e) {
            borderPaint.setColor(-1);
        }
        borderPaint.setStyle(Paint.Style.FILL);
        borderPaint.setAntiAlias(true);
        borderPaint.setFilterBitmap(true);
        Canvas canvas = new Canvas(bitmap);
        int mMargin = 0;
        RectF rectF = new RectF((float)(mMargin + this.mBorder), (float)(mMargin + this.mBorder), (float)(squaredBitmap.getWidth() - mMargin - this.mBorder), (float)(squaredBitmap.getHeight() - mMargin - this.mBorder));
        canvas.drawRoundRect(rectF, (float)this.mRoundingCorners, (float)this.mRoundingCorners, borderPaint);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setFilterBitmap(true);
        paint.setAntiAlias(true);
        canvas.drawRoundRect(rectF, (float)this.mRoundingCorners, (float)this.mRoundingCorners, paint);
        if (this.mBorder != 0) {
            borderPaint.setStyle(Paint.Style.STROKE);
            borderPaint.setStrokeWidth((float)this.mBorder);
            try {
                borderPaint.setColor(Color.parseColor((String)this.mBorderColor));
            }
            catch (Exception e) {
                borderPaint.setColor(-1);
            }
            canvas.drawRoundRect(rectF, (float)this.mRoundingCorners, (float)this.mRoundingCorners, borderPaint);
        }
        if (!squaredBitmap.isRecycled()) {
            squaredBitmap.recycle();
        }
        if (!source.isRecycled()) {
            source.recycle();
        }
        return bitmap;
    }

    @Override
    public String key() {
        return "roundedFlexiTransform";
    }
}

