/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import android.graphics.Color;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentData
implements Serializable {
    private static final String VIEW_ITEM_BG_COLOR_KEY = "viewItemBgColor";
    private static String VIEW_ITEM_CORENR_RADIUS_PX_KEY = "viewItemCorenrRadiusPx";
    private static String CONTAINER_VIEW_BG_COLOR_KEY = "containerViewBgColor";
    private static String HEADER_VIEW_BG_COLOR_KEY = "headerColor";
    private static String FOOTER_VIEW_BG_COLOR_KEY = "footerColor";
    private static String HEADER_TEXT_KEY = "headerText";
    private static String POWERED_BY_URL_KEY = "powerd_by_url";
    private static String DATA_KEY = "data";
    private static String CONTENT_ITEMS_KEY = "content_items";
    private ArrayList<ContentItem> mItems;
    private JSONArray mItemsJsonArray = new JSONArray();
    public int mViewItemBgColor;
    public int mViewItemCorenrRadiusPx;
    public int mContainerViewBgColor;
    public int mHeaderViewBgColor;
    public int mFooterViewBgColor;
    public String mHeaderTextStr = "";
    public String mPowerByUrl = "";
    public String mBackgroundURL = "";
    private String mWidgetType = null;
    private String mStyleID = null;
    private HashMap<String, Integer> mKeysMap;

    public boolean isHasContentToShow() {
        return this.mItems != null && !this.mItems.isEmpty();
    }

    public ArrayList<ContentItem> getContentDataItems() {
        return this.mItems;
    }

    public void decodeResponse(String data) {
        try {
            JSONObject genDataObj;
            JSONObject contentData = new JSONObject(data);
            boolean isSuccess = contentData.optBoolean("success");
            if (isSuccess && (genDataObj = contentData.optJSONObject(DATA_KEY)) != null) {
                this.mViewItemBgColor = Color.parseColor((String)genDataObj.optString(VIEW_ITEM_BG_COLOR_KEY, "#ffffffff"));
                this.mViewItemCorenrRadiusPx = genDataObj.optInt(VIEW_ITEM_CORENR_RADIUS_PX_KEY, 20);
                this.mContainerViewBgColor = Color.parseColor((String)genDataObj.optString(CONTAINER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                this.mHeaderViewBgColor = Color.parseColor((String)genDataObj.optString(HEADER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                this.mFooterViewBgColor = Color.parseColor((String)genDataObj.optString(FOOTER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                this.mHeaderTextStr = genDataObj.optString(HEADER_TEXT_KEY, "More Cool Stuff");
                this.mPowerByUrl = genDataObj.optString(POWERED_BY_URL_KEY, "");
                if (genDataObj.has(CONTENT_ITEMS_KEY)) {
                    this.mItems = new ArrayList();
                    this.mItemsJsonArray = genDataObj.optJSONArray(CONTENT_ITEMS_KEY);
                    if (this.mItemsJsonArray != null && this.mItemsJsonArray.length() > 0) {
                        LinkedHashMap<String, Integer> keysMap = new LinkedHashMap<String, Integer>();
                        JSONArray keysArray = this.mItemsJsonArray.getJSONArray(0);
                        if (keysArray != null && keysArray.length() > 0) {
                            for (int i = 0; i < keysArray.length(); ++i) {
                                keysMap.put(keysArray.getString(i), i);
                            }
                        }
                        if (!keysMap.isEmpty()) {
                            this.mKeysMap = keysMap;
                            for (int i = 1; i < this.mItemsJsonArray.length(); ++i) {
                                try {
                                    ContentItem item = new ContentItem(this.mItemsJsonArray.getJSONArray(i), keysMap);
                                    this.mItems.add(item);
                                    continue;
                                }
                                catch (JSONException e) {
                                    SDKLogger.printDebbugLog("Error parsing Content data item!");
                                }
                            }
                        }
                    }
                    for (int i = 0; i < this.mItems.size(); ++i) {
                        this.mItems.get(i).setRealViewIndex(i);
                    }
                }
            }
        }
        catch (Exception e) {
            SDKLogger.printDebbugLog("Error parsing Content data object!\n" + e.getMessage());
        }
    }

    public int getHeaderViewBgColor() {
        return this.mHeaderViewBgColor;
    }

    public int getContainerViewBgColor() {
        return this.mContainerViewBgColor;
    }

    public int getViewItemCorenrRadiusPx() {
        return this.mViewItemCorenrRadiusPx;
    }

    public int getViewItemBgColor() {
        return this.mViewItemBgColor;
    }

    public int getFooterViewBgColor() {
        return this.mFooterViewBgColor;
    }

    public String getHeaderTextStr() {
        return this.mHeaderTextStr;
    }

    public String getPowerByUrl() {
        return this.mPowerByUrl;
    }

    public String getSourceWidgetType() {
        return this.mWidgetType;
    }

    public void setWidgetType(String widgetType) {
        this.mWidgetType = widgetType;
    }

    public String getStyleID() {
        return this.mStyleID;
    }

    public void setStyleID(String styleID) {
        this.mStyleID = styleID;
    }

    public void setContentItems(ArrayList<ContentItem> contentItems) {
        this.mItems = contentItems;
    }

    public JSONArray getItemsJsonArray() {
        return this.mItemsJsonArray;
    }

    public HashMap<String, Integer> getmKeysMap() {
        return this.mKeysMap;
    }
}

