/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.ContentValues;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import java.util.Set;

public class SDKLogger {
    public static final String GENERAL_TAG = "[KIDOZ SDK]";
    protected static boolean IS_DEBUG_MODE = ConstantDef.DGM;
    public static final boolean IS_PICASSO_DEBUG_MODE = false;

    public static void printInfoLog(String msg) {
        if (IS_DEBUG_MODE) {
            Log.i((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static void printInfoLog(String tag, String msg) {
        if (IS_DEBUG_MODE) {
            Log.i((String)tag, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static void printWarningLog(String msg) {
        if (IS_DEBUG_MODE) {
            Log.w((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static void printWarningLog(String tag, String msg) {
        if (IS_DEBUG_MODE) {
            Log.w((String)tag, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static void printErrorLog(String msg) {
        if (IS_DEBUG_MODE) {
            Log.e((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static void printErrorLog(String tag, String msg) {
        if (IS_DEBUG_MODE) {
            Log.e((String)tag, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static void printDebbugLog(String msg) {
        if (IS_DEBUG_MODE) {
            Log.d((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static void printDebugToast(Context context, String msg) {
        if (IS_DEBUG_MODE) {
            Toast.makeText((Context)context, (CharSequence)msg, (int)0).show();
        }
    }

    public static void printDebbugLog(String tag, String msg) {
        if (IS_DEBUG_MODE) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void printGetRequestDebugLog(String url, ContentValues contentValues, String requestType) {
        if (IS_DEBUG_MODE && contentValues != null) {
            Log.d((String)GENERAL_TAG, (String)"|\n|");
            Log.d((String)GENERAL_TAG, (String)("| \n <<<<< |KIDOZ SDK| **[REQUEST]** API : [GET] , RequestType :  [" + requestType + "] >>>>>\n"));
            Log.d((String)GENERAL_TAG, (String)("[WEBSITE_URL] :" + url + "\n"));
            Log.d((String)GENERAL_TAG, (String)"[PARAMETERS] : \n");
            Set set = contentValues.keySet();
            if (set.size() > 0) {
                for (String key : set) {
                    Log.d((String)GENERAL_TAG, (String)("-- " + key + " = " + contentValues.getAsString(key)));
                    Log.d((String)GENERAL_TAG, (String)"\n");
                }
            }
            Log.d((String)GENERAL_TAG, (String)"|\n|");
        }
    }

    public static void printPostRequestDebugLog(String url, ContentValues contentValues, String requestType) {
        if (IS_DEBUG_MODE && contentValues != null) {
            Log.d((String)GENERAL_TAG, (String)"|\n|");
            Log.d((String)GENERAL_TAG, (String)("\n<<<<< |KIDOZ SDK| **[REQUEST]** API : [POST] , RequestType :  [" + requestType + "] >>>>>\n\n"));
            Log.d((String)GENERAL_TAG, (String)"[WEBSITE_URL] :\n");
            Log.d((String)GENERAL_TAG, (String)"[PARAMETERS] : \n");
            Set set = contentValues.keySet();
            if (set.size() > 0) {
                for (String key : set) {
                    Log.d((String)GENERAL_TAG, (String)"\n");
                    Log.d((String)GENERAL_TAG, (String)("-- " + key + " = " + contentValues.getAsString(key)));
                }
            }
            Log.d((String)GENERAL_TAG, (String)"|\n|");
        }
    }

    public static void printResponse(String responce, String requestType, String apiType) {
        if (IS_DEBUG_MODE) {
            Log.d((String)GENERAL_TAG, (String)"|\n|");
            Log.d((String)GENERAL_TAG, (String)("<<<<< |KIDOZ SDK| **[RESPONSE]** API : [" + requestType + "] , RequestType :  [" + apiType + "] >>>>>\n"));
            Log.d((String)GENERAL_TAG, (String)"[RESPONSE STRING] : \n");
            if (responce != null) {
                Log.d((String)GENERAL_TAG, (String)(responce + ""));
            }
            Log.d((String)GENERAL_TAG, (String)"|\n|");
        }
    }

    public static void printToast(Context context, String msg) {
        if (IS_DEBUG_MODE) {
            Toast.makeText((Context)context, (CharSequence)msg, (int)0).show();
        }
    }
}

