/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general;

import android.content.Context;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;

public class ContentLogicLoader {
    IOnContentDataReadyCallback mDataReadyCallback;
    private boolean mIsLoadContentIsInProgress;

    public ContentLogicLoader(IOnContentDataReadyCallback dataReadyCallback) {
        this.mDataReadyCallback = dataReadyCallback;
    }

    public void loadContent(final Context context, final String widgetType, final String styleId) {
        if (!this.mIsLoadContentIsInProgress) {
            this.mIsLoadContentIsInProgress = true;
            SdkAPIManager.getSdkApiInstance(context).loadContent(context, styleId, widgetType, new ApiResultCallback<ContentData>(){

                @Override
                public void onServerResult(ResultData<?> result) {
                    if (result != null && result.getData() != null) {
                        ContentData contentData = (ContentData)result.getData();
                        contentData.setWidgetType(widgetType);
                        contentData.setStyleID(styleId);
                        int servedCounter = 0;
                        if (contentData != null) {
                            if (contentData.isHasContentToShow()) {
                                for (ContentItem nextContentItem : contentData.getContentDataItems()) {
                                    if (!nextContentItem.isPromoted()) continue;
                                    ++servedCounter;
                                }
                            }
                            EventManager.getInstance(context).LogEventWithIntField(context, widgetType, styleId, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Impression Served", null, servedCounter);
                        }
                        if (contentData.isHasContentToShow()) {
                            if (ContentLogicLoader.this.mDataReadyCallback != null) {
                                ContentLogicLoader.this.mDataReadyCallback.onDataReady(contentData);
                            }
                        } else if (ContentLogicLoader.this.mDataReadyCallback != null) {
                            ContentLogicLoader.this.mDataReadyCallback.onLoadContentFailed();
                        }
                    } else if (ContentLogicLoader.this.mDataReadyCallback != null) {
                        ContentLogicLoader.this.mDataReadyCallback.onLoadContentFailed();
                    }
                    ContentLogicLoader.this.mIsLoadContentIsInProgress = false;
                }

                @Override
                public void onFailed() {
                    if (ContentLogicLoader.this.mDataReadyCallback != null) {
                        ContentLogicLoader.this.mDataReadyCallback.onLoadContentFailed();
                    }
                    ContentLogicLoader.this.mIsLoadContentIsInProgress = false;
                }
            });
        }
    }

    public void loadWaterfall(final Context context, final String widgetType, final String styleId, String rewarded) {
        if (!this.mIsLoadContentIsInProgress) {
            this.mIsLoadContentIsInProgress = true;
            SdkAPIManager.getSdkApiInstance(context).loadWaterfall(context, styleId, widgetType, rewarded, new ApiResultCallback<ContentData>(){

                @Override
                public void onServerResult(ResultData<?> result) {
                    if (result != null && result.getData() != null) {
                        ContentData contentData = (ContentData)result.getData();
                        contentData.setWidgetType(widgetType);
                        contentData.setStyleID(styleId);
                        int servedCounter = 0;
                        if (contentData != null) {
                            if (contentData.isHasContentToShow()) {
                                for (ContentItem nextContentItem : contentData.getContentDataItems()) {
                                    if (!nextContentItem.isPromoted()) continue;
                                    ++servedCounter;
                                }
                            }
                            EventManager.getInstance(context).LogEventWithIntField(context, widgetType, styleId, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Impression Served", null, servedCounter);
                        }
                        if (contentData.isHasContentToShow()) {
                            if (ContentLogicLoader.this.mDataReadyCallback != null) {
                                ContentLogicLoader.this.mDataReadyCallback.onDataReady(contentData);
                            }
                        } else if (ContentLogicLoader.this.mDataReadyCallback != null) {
                            ContentLogicLoader.this.mDataReadyCallback.onLoadContentFailed();
                        }
                    } else if (ContentLogicLoader.this.mDataReadyCallback != null) {
                        ContentLogicLoader.this.mDataReadyCallback.onLoadContentFailed();
                    }
                    ContentLogicLoader.this.mIsLoadContentIsInProgress = false;
                }

                @Override
                public void onFailed() {
                    if (ContentLogicLoader.this.mDataReadyCallback != null) {
                        ContentLogicLoader.this.mDataReadyCallback.onLoadContentFailed();
                    }
                    ContentLogicLoader.this.mIsLoadContentIsInProgress = false;
                }
            });
        }
    }

    protected void loadRefreshebleContent(WidgetType view_style) {
    }

    public static interface IOnContentDataReadyCallback {
        public void onDataReady(ContentData var1);

        public void onLoadContentFailed();
    }
}

