/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.fullscreen_video_layer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebChromeClient;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import java.util.Map;

public class FullScreenVideoEnabledWebView
extends WebView {
    private FullScreenVideoEnabledWebChromeClient videoEnabledWebChromeClient;
    private boolean addedJavascriptInterface = false;

    public FullScreenVideoEnabledWebView(Context context) {
        super(context);
    }

    public FullScreenVideoEnabledWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FullScreenVideoEnabledWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void initWebViewSettings() {
        this.getSettings().setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.setDrawingCacheBackgroundColor(0);
        this.setBackgroundColor(Color.argb((int)1, (int)0, (int)0, (int)0));
        this.setFocusableInTouchMode(true);
        this.setFocusable(true);
        if (Build.VERSION.SDK_INT < 23) {
            this.setAnimationCacheEnabled(true);
        }
        this.setDrawingCacheEnabled(true);
        if (Build.VERSION.SDK_INT < 19) {
            this.getSettings().setDatabasePath(this.getContext().getCacheDir() + "/databases");
        }
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        this.getSettings().setBuiltInZoomControls(false);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setGeolocationDatabasePath(this.getContext().getFilesDir().toString());
        this.getSettings().setAppCachePath(this.getContext().getCacheDir().toString());
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setDefaultTextEncodingName("utf-8");
        this.getSettings().setUserAgentString(ConstantDef.USER_AGENT);
        this.getSettings().setGeolocationEnabled(true);
        this.getSettings().setSupportMultipleWindows(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.getSettings().setBlockNetworkImage(false);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setPluginState(WebSettings.PluginState.ON);
            this.getSettings().setSavePassword(false);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAllowFileAccess(true);
        this.getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(true);
            this.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        this.getSettings().setSaveFormData(false);
        this.getSettings().setLoadWithOverviewMode(false);
        this.getSettings().setUseWideViewPort(false);
        this.getSettings().setCacheMode(-1);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setLayerType(2, null);
        }
        this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        if (Build.VERSION.SDK_INT >= 19) {
            FullScreenVideoEnabledWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
    }

    public boolean isVideoFullscreen() {
        return this.videoEnabledWebChromeClient != null && this.videoEnabledWebChromeClient.isVideoFullscreen();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setWebChromeClient(WebChromeClient client) {
        this.getSettings().setJavaScriptEnabled(true);
        if (client instanceof FullScreenVideoEnabledWebChromeClient) {
            this.videoEnabledWebChromeClient = (FullScreenVideoEnabledWebChromeClient)client;
        }
        super.setWebChromeClient(client);
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.addJavascriptInterface();
        super.loadData(data, mimeType, encoding);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.addJavascriptInterface();
        super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    public void loadUrl(String url) {
        this.addJavascriptInterface();
        super.loadUrl(url);
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.addJavascriptInterface();
        super.loadUrl(url, additionalHttpHeaders);
    }

    private void addJavascriptInterface() {
        if (!this.addedJavascriptInterface) {
            this.addJavascriptInterface(new JavascriptInterface(), "_VideoEnabledWebView");
            this.addedJavascriptInterface = true;
        }
    }

    public class JavascriptInterface {
        @android.webkit.JavascriptInterface
        public void notifyVideoEnd() {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (FullScreenVideoEnabledWebView.this.videoEnabledWebChromeClient != null) {
                        FullScreenVideoEnabledWebView.this.videoEnabledWebChromeClient.onHideCustomView();
                    }
                }
            });
        }
    }
}

