/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import android.widget.Toast;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.receivers.SdkReceiver;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.interstitial.IntrstWrapper;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnitActivity;
import java.io.BufferedInputStream;
import java.io.InputStream;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

public final class KidozSDK {
    public static final String TAG = KidozSDK.class.getSimpleName();
    private static boolean isInitialized = false;
    private static String mPublisherId = null;
    private static String mSecurityKey = null;
    private static boolean isDeveloperLoggingON = false;

    private static void validateParameters(Context context, String publisher_id, String token) {
        SDKLogger.printDebbugLog(TAG, "validateParameters");
        if (context == null) {
            throw new RuntimeException("Context can't be null!");
        }
        if (token == null || token.length() > 48) {
            throw new RuntimeException("Invalid Security Token! Please recheck you security token..");
        }
        if (publisher_id == null) {
            throw new RuntimeException("Invalid publisher id! Please check you publisher id..");
        }
        try {
            Long.parseLong(publisher_id);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid publisher id! Please check you publisher id..");
        }
    }

    private static void notifyUserUsingDemoPublisherID(final Context context, String publisher_id) {
        SDKLogger.printDebbugLog(TAG, "notifyUserUsingDemoPublisherID");
        if (publisher_id.equals("5") || publisher_id.equals("7") || publisher_id.equals("8")) {
            if (context instanceof Activity) {
                ((Activity)context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)context, (CharSequence)("Notice ! You are using Demo PUBLISHER ID ! " + context.getPackageName()), (int)1).show();
                    }
                });
            } else {
                Log.e((String)"[KIDOZ SDK]", (String)("Notice ! You are using Demo PUBLISHER ID ! , Package Name :" + context.getPackageName()));
            }
        }
    }

    public static void initialize(Context context, String publisher_id, String token) {
        SharedPreferencesUtils.saveSharedPreferencesData(context, "PUBLISHER_ID", publisher_id);
        mPublisherId = publisher_id;
        mSecurityKey = token;
        SDKLogger.printDebbugLog(TAG, "initialize : " + isInitialized);
        long startTime = System.currentTimeMillis();
        KidozSDK.validateParameters(context, publisher_id, token);
        SDKLogger.printDebbugLog(TAG, "CT validateParameters time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        KidozSDK.notifyUserUsingDemoPublisherID(context, publisher_id);
        SDKLogger.printDebbugLog(TAG, "CT notifyUserUsingDemoPublisherID time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        KidozSDK.checkManifestDeclarations(context);
        SDKLogger.printDebbugLog(TAG, "CT checkManifestDeclarations time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        SDKLogger.printDebbugLog(TAG, "CT VideoManager.getInstance time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        try {
            SdkDeviceUtils.getGoogleAdvertisingID(context);
            SDKLogger.printDebbugLog(TAG, "CT getGoogleAdvertisingID time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            Utils.preInitiate(context);
            SDKLogger.printDebbugLog(TAG, "CT preInitiate time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            SharedPreferences eventsPref = context.getSharedPreferences("events_shared_preferences", 0);
            long sessionID = eventsPref.getLong("last_session_id", 0L);
            SharedPreferences.Editor editor = eventsPref.edit();
            editor.putLong("last_session_id", ++sessionID);
            editor.apply();
            SDKLogger.printDebbugLog(TAG, "CT SharedPreferences time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            JSONObject eventParams = new JSONObject();
            eventParams.put("DeveloperID", (Object)publisher_id);
            eventParams.put("log_level", EventManager.LOG_NORMAL_LEVEL);
            eventParams.put("SessionID", sessionID);
            EventManager.getInstance(context).init(context, eventParams);
            EventManager.getInstance(context).logEvent(context, null, null, EventManager.LOG_CRITICAL_LEVEL, "Session", "Session Start", publisher_id);
            if (isInitialized) {
                EventManager.getInstance(context).logEvent(context, null, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "SDK Already Initiated", publisher_id);
            }
            SDKLogger.printDebbugLog(TAG, "CT EventManager time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            SdkCookieManager.resetStorage(context, null, StorageLife.SESSION);
            SdkAPIManager.init(context, publisher_id, token, isDeveloperLoggingON);
            KidozSDK.validateSDK(context, publisher_id);
            SDKLogger.printDebbugLog(TAG, "CT initialize time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to init SDK: " + ex.getMessage());
        }
    }

    private static void validateSDK(final Context context, final String publisher_id) {
        SDKLogger.printDebbugLog(TAG, "validateSDK");
        final long startTime = System.currentTimeMillis();
        try {
            if (context != null) {
                PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
                if (appConfig != null) {
                    EventManager.SDK_STYLE_VERSION_NUM = appConfig.getSdkStyleVersion();
                }
                KidozSDK.getApiManager(context).initSdk(context, new ApiResultCallback<PropertiesObj>(){

                    @Override
                    public void onServerResult(ResultData<?> result) {
                        if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() && result.getData() != null && result.getData() instanceof PropertiesObj) {
                            PropertiesObj serverConfig = (PropertiesObj)result.getData();
                            EventManager.SDK_STYLE_VERSION_NUM = serverConfig.getSdkStyleVersion();
                            SdkAPIManager.updateDomain(serverConfig.getGPSFeedApiDomain());
                            SdkAPIManager.updateWaterfallDomain(serverConfig.getWaterfallDomain());
                            PropertiesObj savedConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
                            boolean clearHtmlCache = true;
                            if (savedConfig != null) {
                                String savedUrl = savedConfig.getHtmlLoaderDefaultLink();
                                String newServerUrl = serverConfig.getHtmlLoaderDefaultLink();
                                if (savedConfig != null && savedUrl != null && savedUrl.equals(newServerUrl)) {
                                    clearHtmlCache = false;
                                }
                            }
                            KidozSDK.initHtmlWrapper(context, serverConfig, clearHtmlCache);
                            DatabaseManager.getInstance(context).getConfigTable().insertAppProperties(serverConfig);
                            VideoUnitActivity.parseVideoUnitStyle(context, serverConfig.getProperties());
                            AssetUtil.parseStyleAsync(context, AssetUtil.ParserAsyncTask.StyleType.GLOBAL_PARAMS_STYLE, null);
                            isInitialized = true;
                            EventManager.getInstance(context).logEvent(context, null, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "SDK Init", publisher_id);
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.INIT_SDK);
                            EventBus.getDefault().post((Object)eventMessage);
                            SDKLogger.printDebbugLog(TAG, "CT validateSDK time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
                            if (isDeveloperLoggingON) {
                                Log.d((String)"[KIDOZ SDK]", (String)"Kidoz SDK has been successfully Initialized !");
                            }
                        }
                    }

                    @Override
                    public void onFailed() {
                    }
                });
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to validateSDK: " + ex.getMessage());
        }
    }

    private static void initHtmlWrapper(final Context context, PropertiesObj serverConfig, boolean clearHtmlCache) {
        SDKLogger.printDebbugLog(TAG, "initHtmlWrapper");
        final long startTime = System.currentTimeMillis();
        HtmlViewWrapper viewWrapper = HtmlManager.initDefaultHtmlView(context, clearHtmlCache);
        viewWrapper.setSdkInitListener(new HtmlViewWrapper.IOnInitFinishedListener(){

            @Override
            public void onInitFinished() {
                IntrstWrapper.initInstance(context);
                SDKLogger.printDebbugLog(TAG, "CT initHtmlWrapper time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            }
        });
        viewWrapper.loadHtml(serverConfig.getHtmlLoaderDefaultLink());
    }

    private static SdkAPIManager getApiManager(Context context) {
        SdkAPIManager.init(context, mPublisherId, mSecurityKey, isDeveloperLoggingON);
        return SdkAPIManager.getSdkApiInstance(context);
    }

    public static boolean isInitialised() {
        return isInitialized;
    }

    private static void checkManifestDeclarations(Context context) {
        SDKLogger.printDebbugLog(TAG, "checkManifestDeclarations");
        if (ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_ANDROID || ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_ECLIPSE || ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_COCOS_DX) {
            boolean hasReceiver = false;
            try {
                PackageManager pm = context.getPackageManager();
                PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 2);
                ActivityInfo[] receivers = packageInfo.receivers;
                String receiverClassName = SdkReceiver.class.getName();
                if (receivers != null) {
                    for (ActivityInfo activityInfo : receivers) {
                        if (!activityInfo.name.equals(receiverClassName)) continue;
                        hasReceiver = true;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                hasReceiver = false;
            }
            if (!hasReceiver) {
                Log.e((String)"KIDOZ SDK", (String)"IMPORTANT !!! Missing Android Manifest declaration !!! \nPlease add the following lines to your Manifest.xml file..\n...\n\n<receiver android:name=\"com.kidoz.sdk.api.receivers.SdkReceiver\">\n    <intent-filter>\n         <action android:name=\"android.intent.action.PACKAGE_ADDED\" />\n         <data android:scheme=\"package\" />\n    </intent-filter>\n</receiver> \n...\n");
            }
        }
    }

    public static void setLoggingEnabled(boolean enabled) {
        isDeveloperLoggingON = enabled;
    }

    public static String getPublisherID() {
        return mPublisherId;
    }

    public static String getAuthToken() {
        return mSecurityKey;
    }

    public static String getSDKVersion() {
        return "0.7.4";
    }

    static {
        try {
            InputStream is = KidozSDK.class.getClassLoader().getResourceAsStream("build_properties.txt");
            if (is != null) {
                String value = StreamToStringConverter.readStream(new BufferedInputStream(is), null, false);
                ConstantDef.SDK_EXTENSION_TYPE = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            ConstantDef.SDK_EXTENSION_TYPE = ConstantDef.EXTENSION_TYPE_ANDROID;
        }
    }
}

