package com.kidoz.sdk.api.ui_views.video_unit;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;

import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.utils.Utils;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class VideoUnit
{
    public static final String TAG = VideoUnit.class.getSimpleName();

    private Context mContext;
    private FullScreenVideoEnabledWebView sWebViewInstance;
    private VideoUnitListener mVideoUnitListener;
    private Utils.StaticHandler mStaticHandler;
    public static boolean misLoaded = false;

    public VideoUnit(Context context)
    {
        mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        mContext = context;
        misLoaded = false;
        if (sWebViewInstance == null)
        {
            sWebViewInstance = new FullScreenVideoEnabledWebView(mContext);
        }
        if (getIsReady() == false)
        {
            if (EventBus.getDefault().isRegistered(this) == false)
            {
                EventBus.getDefault().register(this);
            }
        }
    }

    public void setVideoUnitListener(VideoUnitListener videoUnitListener)
    {
        mVideoUnitListener = videoUnitListener;
        if (getIsReady() == true)
        {
            if (mVideoUnitListener != null)
            {
                mStaticHandler.post(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mVideoUnitListener.onReady();
                    }
                });
            }
        }
    }

    public boolean getIsReady()
    {
        return KidozSDK.isInitialised();
    }

    public void show()
    {
        Intent intent = new Intent(mContext, VideoUnitActivity.class);
        intent.putExtra("isLoaded", misLoaded);
        intent.addFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_SINGLE_TOP);
        VideoUnitActivity.mWebView = sWebViewInstance;
        VideoUnitActivity.sVideoUnitListener = mVideoUnitListener;
        mContext.startActivity(intent);
    }

    @Subscribe
    public void onHandleEvent(EventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK)
        {
            if (EventBus.getDefault().isRegistered(this))
            {
                EventBus.getDefault().unregister(this);
            }
            if (mVideoUnitListener != null)
            {
                mStaticHandler.post(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mVideoUnitListener.onReady();
                    }
                });
            }
        }
    }

    public interface VideoUnitListener
    {
        void onReady();

        void onOpen();

        void onClose();
    }
}
