package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Looper;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.assets_handling.StyleParser;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.interstitial.LocalIntrst;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;

public abstract class AbstractPanelView extends RelativeLayout
{
    private static final String TAG = AbstractPanelView.class.getSimpleName();
    private static final String PANEL_SHARED_PREFERENCES = "panel_shared_pref";
    private static final String FIRST_TIME_LAST_LAUNCH_KEY = "fistTimeLastLounch";
    private static final int TIME_MULT_FACTOR = 1000 * 60 * 60;

    public enum PanelViewState
    {
        OPEN, CLOSED
    }

    protected PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
    protected HANDLE_POSITION mHandlePosition = HANDLE_POSITION.START;

    protected RelativeLayout mContainer;
    protected RelativeLayout mInnerContainer;
    protected ContentLogicLoader mContentLogicLoader;
    protected ArrayList<ContentItem> mContentItems = new ArrayList<>();

    public AssetView mParentalLockButton;
    public AssetView mAboutKidozButton;

    public PanelHandle mPanelHandle;
    protected TextView mPoweredByTextView;
    protected RelativeLayout mBottomBarContainer;
    public OneItemFamilyView mOneItemFamilyView;
    protected IOnPanelViewEventListener mIOnPanelViewEventListener;

    protected PanelViewState mPanelState = PanelViewState.CLOSED;
    protected boolean mIsAnimationRunning;
    protected boolean mIsClicksBlocked;
    protected boolean mAllowClickHandling = true;
    protected boolean mIsPanelPrepared = false;
    private long mLastInterceptTS = 0; // User to prevent ,multiple invocations

    protected ShadowView mShadowView;
    protected JSONObject mWidgetProperties;

    protected String mLegacyBtnCloseUrl = null;
    protected String mLegacyBtnOpenUrl = null;
    protected String mLegacyBtnOpenSponsoredUrl = null;

    protected String mBtnCloseBgUrl = null;
    protected String mBtnCloseFrgUrl = null;
    protected String mBtnOpenBgUrl = null;
    protected String mBtnOpenFrgUrl = null;

    protected float mBtnScaleSize = 0.15f;
    protected int mPanelBgColor = Color.WHITE;
    protected String mLabelText = "";
    protected int mLabelColor = Color.BLACK;
    // Time in second of showing (Expanding the panel on first launch per session)
    protected float mFirstLaunchOpenPeriod = -1;
    protected float mFirstLaunchOpenRepeatTimeFarme = -1;
    protected float mFirstLaunchStartDelay = -1;

    protected Utils.StaticHandler mStaticHandler;
    protected SharedPreferences mSharedPreferences;
    protected LocalIntrst mInterstitial;

    // The style id of the widget
    protected String mStyleId = null;

    public AbstractPanelView(Context context, JSONObject jsonObject)
    {
        super(context);
        mWidgetProperties = jsonObject;
        prepareProperties();

        initView();
    }

    protected void prepareProperties()
    {
        mStyleId = mWidgetProperties.optString(StyleParser.STYLE_ID, null);

        //mAnimType = mWidgetProperties.optInt(StyleParser.BTN_ANIMATION_TYPE, 1);
        mLegacyBtnCloseUrl = mWidgetProperties.optString(StyleParser.LEGACY_BTN_CLOSE_URL, null);
        mLegacyBtnOpenUrl = mWidgetProperties.optString(StyleParser.LEGACY_BTN_OPEN_URL, null);
        mLegacyBtnOpenSponsoredUrl = mWidgetProperties.optString(StyleParser.LEGACY_DEFAULT_OPEN_BTN_SPOSORED_URL, null);

        mBtnScaleSize = (float) mWidgetProperties.optDouble(StyleParser.BTN_SCALE_SIZE, 0.15f);
        mLabelText = mWidgetProperties.optString(StyleParser.LABEL_TEXT, "");

        mFirstLaunchOpenPeriod = (float) mWidgetProperties.optDouble(StyleParser.FIRST_LAUNCH_STAY_OPEN_PERIOD_SECONDS, -1);
        mFirstLaunchStartDelay = (float) mWidgetProperties.optDouble(StyleParser.FIRST_LAUNCH_OPEN_START_DELAY_SECONDS, -1);
        mFirstLaunchOpenRepeatTimeFarme = (float) mWidgetProperties.optDouble(StyleParser.FIRST_LAUNCH_OPEN_PANEL_EVEY_X_HOURS, -1);

        mBtnCloseBgUrl = mWidgetProperties.optString(StyleParser.BTN_CLOSE_BG_URL, null);
        mBtnCloseFrgUrl = mWidgetProperties.optString(StyleParser.BTN_CLOSE_FRG_URL, null);
        mBtnOpenBgUrl = mWidgetProperties.optString(StyleParser.BTN_OPEN_BG_URL, null);
        mBtnOpenFrgUrl = mWidgetProperties.optString(StyleParser.BTN_OPEN_FRG_URL, null);

         ///DDDDDDDDDDDDDDDDDDDDDDDDD
        //SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY)

        try
        {
            mPanelBgColor = Color.parseColor(mWidgetProperties.optString(StyleParser.PANEL_BG_COLOR, "#FFFFFF"));
        } catch (Exception e)
        {
            mPanelBgColor = Color.WHITE;
        }

        try
        {
            mLabelColor = Color.parseColor(mWidgetProperties.optString(StyleParser.LABEL_TEXT_COLOR, "#000000"));
        } catch (Exception e)
        {
            mLabelColor = Color.BLACK;
        }

        mSharedPreferences = getContext().getSharedPreferences(PANEL_SHARED_PREFERENCES, Context.MODE_PRIVATE);

        // Init interstitial if needed
        if (mWidgetProperties.optInt(StyleParser.LAUNCH_INTERSTITIAL_ON_OPEN, 0) == 1)
        {
            if (mInterstitial == null)
            {
                mInterstitial = new LocalIntrst(getContext());
            }
        }
    }

    protected void initView()
    {
        initPanelContainer();
        initPanelHandleBtn();
        initInnerPanelView();
        initBottomBar();
        initPanelViewsRules();
        initContentLogicLoader();
        preparePanel();
    }

    protected abstract void initInnerPanelView();

    protected abstract void initPanelViewsRules();

    protected abstract void initShadowView();

    protected abstract void setContentAndRefresh(ArrayList<ContentItem> content);

    protected abstract void onContentDataLoadStarted();

    protected abstract void onContentDataLoadEnded();

    protected abstract void onContentDataLoadFailed();

    protected abstract void clearPanelContent();

    protected abstract void onCollapsePanelAnimationEnded();

    protected abstract void onExpandPanelAnimationStarted();

    public abstract void setPanelEnabled(boolean enabled);

    private void initPanelContainer()
    {
        mContainer = new RelativeLayout(getContext());
        mContainer.setBackgroundColor(Color.TRANSPARENT);
        mContainer.setId(Utils.generateViewId());
        setLayoutParams(new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));

        initShadowView();

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        addView(mContainer, params);

        mInnerContainer = new RelativeLayout(getContext());
        mInnerContainer.setId(Utils.generateViewId());
        mInnerContainer.setBackgroundColor(Color.WHITE);

        params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mInnerContainer, params);

        mInnerContainer.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
            }
        });

        mInnerContainer.setSoundEffectsEnabled(false);
    }

    private void initPanelHandleBtn()
    {
        Point point = Utils.getScreenSize(getContext());
        int size = (int) (Math.min(point.x, point.y) * mBtnScaleSize);

        mPanelHandle = new PanelHandle(getContext(), mPanelType, size, new PanelHandle.IOnPanelHandleClickListener()
        {
            @Override
            public void onHandleClick()
            {
                toggleAnimation();

                if (mPanelState == PanelViewState.CLOSED)
                {
                    if (mWidgetProperties != null && mWidgetProperties.optInt(StyleParser.LAUNCH_INTERSTITIAL_ON_OPEN, 0) == 1)
                    {
                        if (mInterstitial != null)
                        {
                            mInterstitial.loadAd();
                        }
                    }
                }
            }
        });

        if (mBtnScaleSize == 0)
        {
            mPanelHandle.setVisibility(View.GONE);
        }

        // Default handle button
        mPanelHandle.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mPanelHandle, params);
    }

    protected void initBottomBar()
    {
        mBottomBarContainer = new RelativeLayout(getContext());
        mBottomBarContainer.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

        int margin = Utils.dpTOpx(getContext(), 3);
        params.setMargins(margin, 0, margin, margin);
        mInnerContainer.addView(mBottomBarContainer, params);

        initParentalLockButton();
        initAboutKidozButton();

        int size = (int) (70 * ScreenUtils.getScaleFactor(getContext()));

        LayoutParams parentalLockParams = (LayoutParams) mParentalLockButton.getLayoutParams();
        parentalLockParams.width = size;
        parentalLockParams.height = size;

        LayoutParams aboutKidozParams = (LayoutParams) mAboutKidozButton.getLayoutParams();
        aboutKidozParams.width = size;
        aboutKidozParams.height = size;

        mPoweredByTextView = new TextView(getContext());
        mPoweredByTextView.setText(mLabelText);
        mPoweredByTextView.setTextColor(mLabelColor);
        mPoweredByTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
        mPoweredByTextView.setLines(1);
        mPoweredByTextView.setEllipsize(TextUtils.TruncateAt.END);
        mPoweredByTextView.setGravity(Gravity.LEFT | Gravity.BOTTOM);
        mPoweredByTextView.setShadowLayer(3, 2, 2, Color.parseColor("#44000000"));

        params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_BOTTOM, mAboutKidozButton.getId());
        params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
        params.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
        params.setMargins(Utils.dpTOpx(getContext(), 3), 0, Utils.dpTOpx(getContext(), 4), 0);
        mBottomBarContainer.addView(mPoweredByTextView, params);
    }

    private void initParentalLockButton()
    {
        mParentalLockButton = new AssetView(getContext());
        mParentalLockButton.setId(Utils.generateViewId());
        mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mParentalLockButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                if (mIsClicksBlocked == false)
                {
                    GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener()
                    {
                        @Override
                        public void onAnimationEnd()
                        {
                            mIsClicksBlocked = true;

                            ParentalLockDialog.startParentalDialog(getContext(), false, 0.5f, 0.5f, new ParentalLockDialog.IOnParentalDialogListener()
                            {
                                @Override
                                public void onCloseDialog()
                                {
                                    //Refresh the parental lock icon
                                    boolean isLockActive = ParentalLockDialog.isParentalLockActive(getContext());
                                    setParentalLocIConkState(isLockActive);
                                    mIsClicksBlocked = false;
                                }

                                @Override
                                public void onInputPass(boolean isCorrectPass)
                                {
                                    boolean isLockActive = ParentalLockDialog.isParentalLockActive(getContext());
                                    setParentalLocIConkState(isLockActive);
                                }
                            });
                        }

                        @Override
                        public void onAnimationStart()
                        {
                        }
                    });
                }
            }
        });

        mParentalLockButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        params.addRule(RelativeLayout.CENTER_VERTICAL);
        mBottomBarContainer.addView(mParentalLockButton, params);

        boolean isLockActive = ParentalLockDialog.isParentalLockActive(getContext());
        setParentalLocIConkState(isLockActive);
    }

    private void initAboutKidozButton()
    {
        mAboutKidozButton = new AssetView(getContext());
        mAboutKidozButton.setId(Utils.generateViewId());
        mAboutKidozButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mAboutKidozButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener()
                {
                    @Override
                    public void onAnimationEnd()
                    {
                        int[] popLocation = new int[2];
                        popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                        popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                        AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                        aboutKidozDialog.openDialog();
                    }

                    @Override
                    public void onAnimationStart()
                    {
                    }
                });
            }
        });

        mAboutKidozButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.CENTER_VERTICAL);
        params.setMargins(Utils.dpTOpx(getContext(), 1), 0, 0, 0);
        mBottomBarContainer.addView(mAboutKidozButton, params);

        mAboutKidozButton.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(StyleParser.KIDOZ_LOGO_ICON)), null);
    }

    // long time = 0;
    protected void initContentLogicLoader()
    {
        //  time = System.currentTimeMillis();
        // SDKLogger.printDebbugLog("PanelLog - Start Content Loading");
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override
            public void onDataReady(ContentData contentData)
            {
                // SDKLogger.printDebbugLog("PanelLog - Content loaded - Time : " + (System.currentTimeMillis() - time)/1000f + "s");
                onContentDataLoadEnded();
                if (contentData != null && contentData.isHasContentToShow())
                {
                    // Reset The storage of the impressions for the HTML content
                    SdkCookieManager.resetStorage(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), StorageLife.WIDGET);

                    mContentItems.clear();
                    clearPanelContent();

                    mContentItems.addAll(contentData.getContentDataItems());
                    setContentAndRefresh(mContentItems);

                    if (mIsPanelPrepared == false)
                    {
                        prepareHandle(null);
                    }
                }
            }

            @Override
            public void onLoadContentFailed()
            {
                onContentDataLoadFailed();
            }
        });
    }

    private void setParentalLocIConkState(boolean isLockActive)
    {
        if (isLockActive)
        {
            mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(StyleParser.BTN_LOCK_CLOSED)), null);
        } else
        {
            mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(StyleParser.BTN_LOCK_OPEN)), null);
        }
    }

    /**
     * Set panel color
     *
     * @param color set panel color
     */
    public void setPanelColor(int color)
    {
        if (color != Color.TRANSPARENT)
        {
            mPanelBgColor = color;
        }

        if (mInnerContainer != null)
        {
            mInnerContainer.setBackgroundColor(mPanelBgColor);
        }

        if (mPanelHandle != null)
        {
            mPanelHandle.setBaseColor(mPanelBgColor);
        }
    }

    private void toggleAnimation()
    {
        if (mPanelState == PanelViewState.OPEN)
        {
            collapsePanelView();
        } else
        {
            expandPanelViewInternal(true);
        }
    }

    /**
     * Collapse panel view
     */

    public void collapsePanelView()
    {
        if (KidozSDK.isInitialised())
        {
            if (mIsAnimationRunning == false && mPanelState == PanelViewState.OPEN && mContainer != null)
            {
                GenAnimator.closePanelView(mContainer, 200, mInnerContainer, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        GenAnimator.animateHandleClose(mPanelHandle, null);

                        onContentDataLoadStarted();
                        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId);
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);
                        mIsAnimationRunning = false;

                        onCollapsePanelAnimationEnded();
                        mPanelState = PanelViewState.CLOSED;

                        if (mIOnPanelViewEventListener != null)
                        {
                            mIOnPanelViewEventListener.onPanelViewCollapsed();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        }
    }

    /**
     * Expand (Open) Panel view
     */
    public void expandPanelView()
    {
        if (KidozSDK.isInitialised())
        {
            expandPanelViewInternal(true);
        }
    }

    /**
     * Expand (Open) Panel view
     *
     * @param byUserAction if invoked by user action or automatically
     */
    private void expandPanelViewInternal(boolean byUserAction)
    {
        if (mIsAnimationRunning == false && mPanelState == PanelViewState.CLOSED && getVisibility() == View.VISIBLE)
        {
            // Send log
            Event event = new Event();
            if (byUserAction)
            {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.MANUAL_OPEN);
            } else
            {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.AUTOMATIC_OPEN);
            }
            event.addParameterToJsonObject(EventParameters.LABEL_PANEL_VIEW_TYPE, mPanelType.ordinal());

            EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.PANEL_VIEW);

            //Refresh the parental lock icon
            boolean isLockActive = ParentalLockDialog.isParentalLockActive(getContext());
            setParentalLocIConkState(isLockActive);

            if (mContainer != null)
            {
                GenAnimator.openPanelView(mContainer, mInnerContainer, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.OPENED);
                        GenAnimator.animateHandleOpen(mPanelHandle, null);
                        onExpandPanelAnimationStarted();
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        mIsAnimationRunning = false;
                        mPanelState = PanelViewState.OPEN;

                        if (mIOnPanelViewEventListener != null)
                        {
                            mIOnPanelViewEventListener.onPanelViewExpanded();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {
                    }
                });
            }
        }
    }

    /**
     * Set panel view configuration
     *
     * @param panelType      panel view type (Possible values <code> PANEL_TYPE.TOP, PANEL_TYPE.BOTTOM, PANEL_TYPE.LEFT ,PANEL_TYPE.RIGHT </code>
     * @param handlePosition handle position  (Possible values <code> HANDLE_POSITION.START, HANDLE_POSITION.CENTER, HANDLE_POSITION.END </code>
     */
    public void setPanelConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handlePosition)
    {
        if (KidozSDK.isInitialised())
        {
            mPanelType = panelType;
            mHandlePosition = handlePosition;
            mPanelHandle.setPanelType(mPanelType);

            resetPanelState();

            if (mHandlePosition == HANDLE_POSITION.NONE)
            {
                mPanelHandle.setVisibility(View.INVISIBLE);
            } else
            {
                if (mBtnScaleSize != 0)
                {
                    mPanelHandle.setVisibility(View.VISIBLE);
                }
            }
        }
    }

    private void resetPanelState()
    {
        initPanelViewsRules();

        if (mIsPanelPrepared)
        {
            if (mPanelState == PanelViewState.CLOSED)
            {
                GenAnimator.closePanelView(mContainer, 0, mInnerContainer, mPanelType, null);
                requestFocus();
                bringToFront();
            }
        }
    }

    /**
     * Set panel events listener
     *
     * @param iOnPanelViewEventListener listener
     */
    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener)
    {
        mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }

    /**
     * Get panel view state
     *
     * @return panel view state
     */
    public PanelViewState getPanelViewState()
    {
        return mPanelState;
    }

    @Override
    protected void onDetachedFromWindow()
    {
        getStaticHandler().removeCallbacksAndMessages(null);
        super.onDetachedFromWindow();
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility)
    {
        super.onVisibilityChanged(changedView, visibility);

        if (KidozSDK.isInitialised())
        {
            if (visibility == View.VISIBLE)
            {

            } else if (!isInEditMode() && (visibility == View.GONE || visibility == View.INVISIBLE))
            {
                getStaticHandler().removeCallbacksAndMessages(null);
            }
        }
        mAllowClickHandling = true;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus)
    {
        super.onWindowFocusChanged(hasWindowFocus);

        if (hasWindowFocus)
        {
            mAllowClickHandling = true;
        } else
        {
            mAllowClickHandling = false;
        }
    }

    /**
     * Prepare panel handle for view
     */
    private void prepareHandle(final String url)
    {
        // time = System.currentTimeMillis();
        // SDKLogger.printDebbugLog("PanelLog - Start Handle Prepare");

        LocalAssetHelper localAssetHelper = new LocalAssetHelper();
        // Legacy values for sdk < 0.7.0
        localAssetHelper.legacyBtnCloseAsset = AssetUtil.getAssetFile(getContext(), mLegacyBtnCloseUrl);
        localAssetHelper.legacyBtnOpenAsset = AssetUtil.getAssetFile(getContext(), mLegacyBtnOpenUrl);
        localAssetHelper.legacyBtnDefaultOpenSponsoredAsset = AssetUtil.getAssetFile(getContext(), mLegacyBtnOpenSponsoredUrl);

        localAssetHelper.openBtnAssetBg = AssetUtil.getAssetFile(getContext(), mBtnOpenBgUrl);
        localAssetHelper.openBtnAssetFrg = AssetUtil.getAssetFile(getContext(), mBtnOpenFrgUrl);
        localAssetHelper.closeBtnAssetBg = AssetUtil.getAssetFile(getContext(), mBtnCloseBgUrl);
        localAssetHelper.closeBtnAssetFrg = AssetUtil.getAssetFile(getContext(), mBtnCloseFrgUrl);

        // Load proper handle button image for close and open state
        mPanelHandle.loadAssets(localAssetHelper, new PanelHandle.IonPanelHandlePreparedListener()
        {
            @Override
            public void onPanelPrepared()
            {
                // SDKLogger.printDebbugLog("PanelLog - Handle Prepared - Time : " + (System.currentTimeMillis() - time)/1000f + "s");
                mIsPanelPrepared = true;
                GenAnimator.playGrowAnimation(mPanelHandle, 350, 0, null, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);

                        requestFocus();
                        bringToFront();
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        mIsAnimationRunning = false;

                        requestFocus();
                        bringToFront();

                        mPanelState = PanelViewState.CLOSED;

                        if (getVisibility() == VISIBLE)
                        {
                            openPanelForDefinedAmountOfTime();
                        }

                        if (mIOnPanelViewEventListener != null)
                        {
                            mIOnPanelViewEventListener.onPanelReady();
                        }

                        EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SDK, EventParameters.ACTION_BUTTON_VIEW, EventParameters.LABEL_PANEL_BUTTON_VIEW);
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {
                    }
                });
            }
        });
    }

    /**
     * Prepare panel view
     */
    private void preparePanel()
    {
        setPanelColor(mPanelBgColor);

        mPanelState = PanelViewState.CLOSED;
        mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener(this, new Utils.OnGlobalLayoutFinishedListener()
        {
            @Override
            public void onLayoutFinished()
            {
                GenAnimator.closePanelView(mContainer, 0, mInnerContainer, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        GenAnimator.animateHandleClose(mPanelHandle, null);
                        requestFocus();
                        bringToFront();
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        clearPanelContent();
                        onContentDataLoadStarted();
                        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId);
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {
                    }
                });
            }
        });
    }

    /**
     * Open (Show) the panel for predefined amount of time if needed
     * Used to make user notice that there is a panel and its content
     */
    private void openPanelForDefinedAmountOfTime()
    {
        final long lastLaunchTime = mSharedPreferences.getLong(FIRST_TIME_LAST_LAUNCH_KEY, -1);

        if (mFirstLaunchStartDelay >= 0)
        {
            if (getVisibility() == View.VISIBLE)
            {
                getStaticHandler().postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        if (mFirstLaunchOpenRepeatTimeFarme == -1 ||
                                (lastLaunchTime == -1 || (lastLaunchTime + mFirstLaunchOpenRepeatTimeFarme * TIME_MULT_FACTOR) > System.currentTimeMillis()))
                        {
                            expandPanelViewInternal(false);

                            SharedPreferences.Editor editor = mSharedPreferences.edit();
                            editor.putLong(FIRST_TIME_LAST_LAUNCH_KEY, System.currentTimeMillis());
                            editor.apply();

                            if (mFirstLaunchOpenPeriod > 0)
                            {
                                getStaticHandler().postDelayed(new Runnable()
                                {
                                    @Override
                                    public void run()
                                    {
                                        collapsePanelView();
                                    }
                                }, (long) (mFirstLaunchOpenPeriod * 1000));
                            }
                        }
                    }
                }, (long) (mFirstLaunchStartDelay * 1000));
            }
        }
    }

    // Sequential handler
    protected Utils.StaticHandler getStaticHandler()
    {
        if (mStaticHandler == null)
        {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        }
        return mStaticHandler;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev)
    {
        if (System.currentTimeMillis() - mLastInterceptTS > 1000)
        {
            mLastInterceptTS = System.currentTimeMillis();
            // Disable any post delayed task. such as automatic open/close if any panel interaction was made by user
            getStaticHandler().removeCallbacksAndMessages(null);
        }
        return super.onInterceptTouchEvent(ev);
    }
}

class LocalAssetHelper
{
    // Used for SDK version < 0.7.0
    public File legacyBtnOpenAsset;
    public File legacyBtnCloseAsset;
    public File legacyBtnDefaultOpenSponsoredAsset;

    // Used for SDK version >= 0.7.0
    public File openBtnAssetBg;
    public File openBtnAssetFrg;
    public File closeBtnAssetBg;
    public File closeBtnAssetFrg;

    public boolean isLegacyParams()
    {
        if ((legacyBtnOpenAsset != null && legacyBtnOpenAsset.exists())
                || (legacyBtnCloseAsset != null && legacyBtnCloseAsset.exists())
                || (legacyBtnDefaultOpenSponsoredAsset != null && legacyBtnDefaultOpenSponsoredAsset.exists()))

        {
            return true;
        } else
        {
            return false;
        }
    }
}