package com.kidoz.sdk.api.ui_views.one_item_view;

import android.animation.Animator;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;

import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.OneContentItemView;

import org.json.JSONObject;

import java.util.ArrayList;

public class ItemViewPagerAdapter extends PagerAdapter
{
    private ArrayList<ContentItem> mContent;
    private ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick;

    protected int mWidth;
    protected int mHeight;

    private IOnItemInstaniateFinishListener mItemInstaniateListener;
    private boolean mFirstItemCreated = false;

    private JSONObject mProperties;

    public ItemViewPagerAdapter(JSONObject properties, int width, int height)
    {
        mContent = new ArrayList<>();
        mIsCanClick = true;
        mWidth = width;
        mHeight = height;
        mProperties = properties;
    }

    public void toggleIsClickable(boolean isCanClick)
    {
        mIsCanClick = isCanClick;
    }

    public void setViewPagerItemClickListener(ViewPagerItemClickListener viewPagerItemClickListener)
    {
        mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    @Override
    public int getCount()
    {
        int result = 0;
        if (mContent != null && mContent.size() > 0)
        {
            if (mContent.size() == 1)
            {
                result = 1;
            }
            else
            {
                result = 100;
            }
        }
        return result;
    }

    public int getRealCount()
    {
        return mContent.size();
    }

    public void setContent(ArrayList<ContentItem> content)
    {
        mContent = content;
        notifyDataSetChanged();
    }

    public void clearContent()
    {
        mContent.clear();
        notifyDataSetChanged();
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position)
    {
        //SDKLogger.printWarningLog("###@@@###  Instaniate Item : " + position);

        final int contentItemPosition = position % mContent.size();
        final ContentItem contentItem = mContent.get(contentItemPosition);
        OneContentItemView panelContentItem = new OneContentItemView(mProperties, container.getContext(), mWidth, mHeight);
        panelContentItem.setTag(position);

        panelContentItem.applyViewSettingsByContentType(contentItem.getContentType());

        panelContentItem.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                if (mIsCanClick == true)
                {
                    mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                    {
                        @Override
                        public void onAnimationStart(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationEnd(Animator animation)
                        {
                            mViewPagerItemClickListener.onClickEnd(contentItem, contentItemPosition);
                            mIsCanClick = true;
                        }

                        @Override
                        public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override
                        public void onAnimationRepeat(Animator animation)
                        {

                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null)
        {
            panelContentItem.setData(contentItem);
        }
        container.addView(panelContentItem);

        if (position == 0 && mFirstItemCreated == false && contentItem != null)
        {
            mFirstItemCreated = true;
            if (mItemInstaniateListener != null)
            {
                mItemInstaniateListener.onFirstItemReady();
            }
        }

        return panelContentItem;
    }

    @Override
    public boolean isViewFromObject(View view, Object object)
    {
        return view == object;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object)
    {
        //SDKLogger.printWarningLog("###@@@###  Destroy Item : " + position);
        container.removeView((OneContentItemView) object);
    }

    public interface ViewPagerItemClickListener
    {
        void onClickEnd(ContentItem contentItem, int position);
    }

    public ContentItem getContentItem(int position)
    {
        ContentItem result = null;
        if (mContent != null && mContent.size() > position)
        {
            result = mContent.get(position);
        }
        return result;
    }

    public boolean isAdapterEmpty()
    {
        if (mContent == null)
        {
            return true;
        }
        else
        {
            return mContent.isEmpty();
        }
    }

    public void setOnItemInstantiateFinishListener(IOnItemInstaniateFinishListener listener)
    {
        mItemInstaniateListener = listener;
    }

    public interface IOnItemInstaniateFinishListener
    {
        void onFirstItemReady();
    }

    @Override
    public int getItemPosition(Object object)
    {
        return POSITION_NONE;
    }
}
