package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class KidozAdActivity extends Activity
{
    public static final String STYLE_ID_KEY = "styleId";
    public static final String DISABLE_BACK_KEY = "disableBack";

    protected HtmlViewWrapper mWebView;
    protected RelativeLayout mInnerContainer;
    protected int mBgColor = Color.BLACK;
    private boolean mIsImmersive = true;
    private boolean mIsFirstLaunch = true;
    private boolean mIsBackDisabled = false;

    private Utils.StaticHandler mHandler;
    private IntrstWrapper.InnerHelperInterface mInnerHelperInterface;

    private int mPreviousOrientation;
    @Override
    public void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        if (Build.VERSION.SDK_INT < 18)
        {
            mWebView.setVisibility(View.INVISIBLE);
            mHandler.postDelayed(new Runnable()
            {
                @Override
                public void run()
                {
                    mWebView.setVisibility(View.VISIBLE);
                    mWebView.bringToFront();
                }
            }, 500);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }


        setTheme(android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);

        getWindow().setFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED, WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED);

        mHandler = new Utils.StaticHandler(getMainLooper());
        Intent intent = getIntent();
        if (intent != null)
        {
            mInnerHelperInterface = IntrstWrapper.initInstance(this).getHelperInterface();

            String styleId = intent.getStringExtra(STYLE_ID_KEY);
            mIsBackDisabled = intent.getBooleanExtra(DISABLE_BACK_KEY, false);

            mWebView = HtmlManager.getIntrstDefaultHtmlView(this);
            if (mWebView != null)
            {

                if (mWebView.getWidgetType() != null && mWebView.getWidgetType().equals(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue()))
                {
                    mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                }
                else
                {
                    mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                }
                mWebView.setStyleID(styleId);
                mWebView.setInFocusActivityContext(KidozAdActivity.this);
                if (Build.VERSION.SDK_INT < 16)
                {
                    mWebView.setLayerType(View.LAYER_TYPE_NONE, null);
                }
                mInnerContainer = new RelativeLayout(this);
                mInnerContainer.setBackgroundColor(mBgColor);
                mInnerContainer.addView(mWebView, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));
                setContentView(mInnerContainer, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
                if (mWebView.getWidgetType() != null && mWebView.getWidgetType().equals(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue()))
                {
                    EventManager.getInstance(this).logEvent(this, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(), styleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.INTERSTITIAL_VIEW);
                }
                else
                {
                    EventManager.getInstance(this).logEvent(this, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), styleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.INTERSTITIAL_VIEW);
                }
            } else
            {
                finish();
            }
        } else
        {
            finish();
        }

    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus)
    {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus)
        {
            if (mIsImmersive)
            {
                applyImmersiveMode();
            }
        }
    }

    private void applyImmersiveMode()
    {
        /*int flags = View.SYSTEM_UI_FLAG_HIDE_NAVIGATION;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            flags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN;
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT)
        {
            flags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        }

        getWindow().getDecorView().setSystemUiVisibility(flags);*/

        if (Build.VERSION.SDK_INT < 16)
        {
            getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        } else
        {
            if (Build.VERSION.SDK_INT < 18)
            {
                View decorView = getWindow().getDecorView();
                int uiOptions = View.SYSTEM_UI_FLAG_FULLSCREEN;
                decorView.setSystemUiVisibility(uiOptions);
            } else
            {
                final View decorView = getWindow().getDecorView();
                decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener()
                {
                    @Override
                    public void onSystemUiVisibilityChange(int visibility)
                    {
                        if ((visibility & View.SYSTEM_UI_FLAG_FULLSCREEN) == 0)
                        {
                            decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                        }
                    }
                });
            }
        }
    }

    @Override
    protected void onResume()
    {


        super.onResume();
        mPreviousOrientation = this.getRequestedOrientation();
        if (mWebView != null)
        {
            if (mIsFirstLaunch == true)
            {
                mIsFirstLaunch = false;
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mWebView.startAd();
                    }
                },100);
            } else
            {
                mWebView.resumeVastAd();
            }

            if (Build.VERSION.SDK_INT < 18)
            {
                mWebView.setVisibility(View.INVISIBLE);
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mWebView.setVisibility(View.VISIBLE);
                        mWebView.bringToFront();
                    }
                }, 500);
            } else
            {
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mWebView.bringToFront();
                    }
                }, 200);
            }
        }
    }

    @Override
    protected void onPause()
    {
        mHandler.removeCallbacksAndMessages(null);
        if (mWebView != null)
        {
            try {
                mWebView.pauseVastAd();
            }
            catch (Exception e)
            {

            }
            try {
                mWebView.pauseAd();
            }
            catch (Exception e)
            {

            }


        }

        super.onPause();
    }

    @Override
    protected void onDestroy()
    {
        if (mWebView != null)
        {
            try {
                mWebView.stopVastAd();
            }
            catch (Exception e)
            {

            }
            try {
                mWebView.stopAd();
            }
            catch (Exception e)
            {

            }
        }

        if (mInnerHelperInterface != null)
        {
            mInnerHelperInterface.onAdClose();
        }

        if (EventBus.getDefault().isRegistered(this) == true)
        {
            EventBus.getDefault().unregister(this);
        }

        this.setRequestedOrientation(mPreviousOrientation);

        super.onDestroy();
    }

    @Subscribe
    public void onHandleEvent(WidgetEventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE)
        {
            mHandler.removeCallbacksAndMessages(null);
            if (isFinishing() == false)
            {
                finish();
            }
        }else if(event.getMessageType() == EventMessage.MessageType.PARENTAL_DIALOG_CLOSE) {
            onResume();
        }
    }

    @Override
    public void onBackPressed()
    {
        if (mIsBackDisabled == false)
        {
            super.onBackPressed();
        }
    }

    /**
     * Restore user original orientation
     */
    /*public void restoreUserOriginalOrientation()
    {
        if (isFinishing() == false)
        {
            switch (mCurrentOrientationState)
            {
                case Configuration.ORIENTATION_LANDSCAPE:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                    break;
                }
                case Configuration.ORIENTATION_PORTRAIT:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
                    break;
                }
                case Configuration.ORIENTATION_UNDEFINED:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                    break;
                }
            }
        }
    }*/
}
