package com.kidoz.sdk.api.ui_views.interstitial;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.assets_handling.StyleParser;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class IntrstWrapper
{
    protected static final int REQUEST_FILTER_TIMEOUT = 1000 * 5; //5 seconds

    public enum InterstitialEvents
    {
        OPENED, CLOSED, READY, LOAD_FAILED, REWARDED, REWARDED_VIDEO_STARTED
    }
    private ArrayList<ContentItem> mContentList = new ArrayList<>();

    protected static IntrstWrapper mInstance = null;

    protected Context mContext;
    protected HtmlViewWrapper webView;
    protected ContentLogicLoader mContentLogicLoader;
    protected ContentData mContentData;
    protected String mStyleId;

    protected boolean mIsInitializationFinished = false;
    protected boolean mIsLoaded = false;

    protected boolean mIsShowRequested = false; // Used for avoiding multiple calls of show for short amount of time
    protected boolean mIsLoadRequested = false; // Used for avoiding multiple calls of load for short amount of time
    protected long mLoadRequestTM = 0;

    protected boolean mIsLoadRequestedWhileNotReady;

    protected JSONObject mProperties;
    protected Lock mLaunchLock;
    protected InnerHelperInterface mInnerHelperInterface;
    protected KidozInterstitial.AD_TYPE mAdRequestType = KidozInterstitial.AD_TYPE.INTERSTITIAL;
    protected Lock raceConditionLock = new ReentrantLock();

    protected JSONObject mAdProperties;

    private int mCurrentIndex;

    //Flag used to differ the source of interstitial request developer or local
    private boolean mIsLocal = false;

    public static IntrstWrapper initInstance(Context context)
    {
        if (mInstance == null)
        {
            return mInstance = new IntrstWrapper(context);
        }
        else
        {
            mInstance.validateIfPrepared();
            return mInstance;
        }
    }

    protected IntrstWrapper(Context context)
    {
        mContext = context;

        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }

        mLaunchLock = new ReentrantLock();

        // Has been initialised
        if (KidozSDK.isInitialised() == true)
        {
            validateLayoutAndAssets();
        }

        mInnerHelperInterface = new InnerHelperInterface()
        {
            @Override
            public void onAdOpen()
            {
                if (!mIsLocal)
                {
                    EventBus.getDefault().post(InterstitialEvents.OPENED);
                }
            }

            @Override
            public void onAdClose()
            {
                if (!mIsLocal)
                {
                    EventBus.getDefault().post(InterstitialEvents.CLOSED);
                }
                mIsShowRequested = false;

                mIsLoaded = false;
                if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
                {
                    SdkCookieManager.resetStorage(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(), StorageLife.WIDGET);
                }
                else
                {
                    SdkCookieManager.resetStorage(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), StorageLife.WIDGET);
                }
            }
        };
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override
            public void onDataReady(ContentData contentData)
            {
                mContentData = contentData;
                mContentList = new ArrayList<>();
                mContentList.addAll(contentData.getContentDataItems());
                if (mContentList.size()>0)
                {
                    mCurrentIndex = 0;
                    ContentItem contentItem = mContentList.get(mCurrentIndex);
                    String urlToLoad = getUrlFromContent(contentItem);
                    PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
                    if (urlToLoad == null)
                    {
                        urlToLoad = appConfig.getInterstitialHtmlLink();


                    }
                    if(urlToLoad !=null)
                    {
                        prepareWebViewWithLink(urlToLoad);
                    }
                }

            }

            @Override
            public void onLoadContentFailed()
            {

                EventBus.getDefault().post(InterstitialEvents.LOAD_FAILED);
            }
        });
    }

    public InnerHelperInterface getHelperInterface()
    {
        return mInnerHelperInterface;
    }

    /**
     * Validate resources
     */
    private void validateLayoutAndAssets()
    {
        if (raceConditionLock.tryLock())
        {
            try
            {
                AssetUtil.parseStyleAsync(mContext, AssetUtil.ParserAsyncTask.StyleType.INTERSTITIAL_STYLE, new AssetUtil.ParserAsyncTask.IOnStyleParseListener()
                {
                    @Override
                    public void onParseFinished(boolean success)
                    {
                        if (success)
                        {
                            mProperties = DatabaseManager.getInstance(mContext).getConfigTable().loadProperties(KidozInterstitial.TAG);
                            if (mProperties != null)
                            {
                                mStyleId = mProperties.optString(StyleParser.STYLE_ID);
                            }
                            PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
                            if (appConfig != null)
                            {
                                prepareWebViewWithLink(appConfig.getInterstitialHtmlLink());

                            }
                        }
                        else
                        {
                            EventBus.getDefault().post(InterstitialEvents.LOAD_FAILED);
                        }
                    }
                });
            }
            finally
            {
                raceConditionLock.unlock();
            }
        }
    }


    /**
     * Create and generate html view
     */
    protected void generateHtmlView()
    {
        webView = HtmlManager.initIntrstDefaultHtmlView(mContext);
    }

    /**
     * Initiate and  Prepare webview for work
     */
    private synchronized void prepareWebView()
    {
        if (webView == null)
        {
            generateHtmlView();
            webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface()
            {
                @Override
                public void onHtmlFinishedLoading()
                {
                    super.onHtmlFinishedLoading();
                }

                @Override
                public void onNotifyVastReady(boolean isVastReady, JSONObject vast_properties)
                {
                    super.onNotifyVastReady(isVastReady, vast_properties);

                    mAdProperties = vast_properties;
                    mIsLoadRequested = false;
                    if (isVastReady)
                    {
                        mIsLoaded = true;
                        mIsInitializationFinished = true;
                        if (!mIsLocal)
                        {
                            EventBus.getDefault().post(InterstitialEvents.READY);
                        }
                        else
                        {
                            show();
                        }
                    }
                    else
                    {
                        mIsLoaded = false;
                        if (!mIsLocal)
                        {
                            EventBus.getDefault().post(InterstitialEvents.LOAD_FAILED);
                        }
                    }
                    if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
                    {
                        webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    }
                    else
                    {
                        webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }

                @Override
                public void onViewReady()
                {
                    super.onViewReady();
                    mIsInitializationFinished = true;

                    if (mIsLoadRequestedWhileNotReady)
                    {
                        mIsLoadRequestedWhileNotReady = false;
                        load(mAdRequestType);
                    }
                }

                @Override
                public void onClose()
                {
                    super.onClose();
                    WidgetEventMessage eventMessage = null;
                    if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
                    {
                        eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED);
                    }
                    else
                    {
                        eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    }
                    EventBus.getDefault().post(eventMessage);
                }

                @Override
                public void onRewarded()
                {
                    super.onRewarded();
                    EventBus.getDefault().post(InterstitialEvents.REWARDED);
                }

                @Override
                public void onRewardedVideoStarted()
                {
                    super.onRewardedVideoStarted();
                    EventBus.getDefault().post(InterstitialEvents.REWARDED_VIDEO_STARTED);
                }
            });
        }
        if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
        {
            webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
        }
        else
        {
            webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        }

        PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
        if (appConfig != null)
        {
            webView.loadHtml(appConfig.getInterstitialHtmlLink());
        }
    }


    /**
     * Initiate and  Prepare webview for work
     */
    private synchronized void prepareWebViewWithLink(String url)
    {

        if (webView == null)
        {
            generateHtmlView();
            webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface()
            {
                @Override
                public void onHtmlFinishedLoading()
                {
                    super.onHtmlFinishedLoading();
                }

                @Override
                public void onNotifyVastReady(boolean isVastReady, JSONObject vast_properties)
                {
                    super.onNotifyVastReady(isVastReady, vast_properties);

                    mAdProperties = vast_properties;
                    mIsLoadRequested = false;
                    if (isVastReady)
                    {
                        mIsLoaded = true;

                        if (!mIsLocal)
                        {
                            EventBus.getDefault().post(InterstitialEvents.READY);
                        }
                        else
                        {
                            show();
                        }
                    }
                    else
                    {
                        //oooOri
                        if(mCurrentIndex<mContentList.size()-1)
                        {
                            mCurrentIndex +=1;

                            ContentItem contentItem = mContentList.get(mCurrentIndex);

                            String urlToLoad = getUrlFromContent(contentItem);

                            PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
                            if (urlToLoad == null)
                            {
                                urlToLoad = appConfig.getInterstitialHtmlLink();


                            }
                            if (urlToLoad != null)
                            {
                                prepareWebViewWithLink(urlToLoad);
                            }
                        }
                        else
                        {
                            mIsLoaded = false;
                            if (!mIsLocal)
                            {
                                EventBus.getDefault().post(InterstitialEvents.LOAD_FAILED);
                            }
                        }
                    }
                    if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
                    {
                        webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    }
                    else
                    {
                        webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }

                @Override
                public void onViewReady()
                {
                    super.onViewReady();
                    if (mContentList.size()>mCurrentIndex)
                    {
                        ContentItem contentItem = mContentList.get(mCurrentIndex);
                        HashMap<String, Integer> keysMap = mContentData.getmKeysMap();
                        String item = contentItem.getJSONitem().toString();
                        String map = (new JSONObject(keysMap)).toString();
                        webView.loadContent(map,item); //oooOri set the item for the selected item

                    }
                    mIsInitializationFinished = true;
//
//                    if (mIsLoadRequestedWhileNotReady)
//                    {
//                        mIsLoadRequestedWhileNotReady = false;
//                        load(mAdRequestType);
//                    }
                }

                @Override
                public void onClose()
                {
                    super.onClose();
                    WidgetEventMessage eventMessage = null;
                    if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
                    {
                        eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED);
                    }
                    else
                    {
                        eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    }
                    EventBus.getDefault().post(eventMessage);
                }

                @Override
                public void onRewarded()
                {
                    super.onRewarded();
                    EventBus.getDefault().post(InterstitialEvents.REWARDED);
                }

                @Override
                public void onRewardedVideoStarted()
                {
                    super.onRewardedVideoStarted();
                    EventBus.getDefault().post(InterstitialEvents.REWARDED_VIDEO_STARTED);
                }

                @Override
                public void onNotifyAdReady(boolean isAdReady, JSONObject adProperties)
                {
                    super.onNotifyAdReady(isAdReady,adProperties);
                    mAdProperties = adProperties;
                    mIsLoadRequested = false;
                    if (isAdReady)
                    {
                        mIsLoaded = true;

                        if (!mIsLocal)
                        {
                            EventBus.getDefault().post(InterstitialEvents.READY);
                        }
                        else
                        {
                            show();
                        }
                    }
                    else
                    {
                        mIsLoaded = false;
                        if (!mIsLocal)
                        {
                            EventBus.getDefault().post(InterstitialEvents.LOAD_FAILED);
                        }
                    }
                    if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
                    {
                        webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    }
                    else
                    {
                        webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }
            });
        }
        if (mAdRequestType != null && mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
        {
            webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
        }
        else
        {
            webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        }


//        if (appConfig != null)
//        {
        webView.loadHtml(url);
//        }
    }

    /**
     * Load interstitial content
     **/
    public synchronized void load(KidozInterstitial.AD_TYPE ad_type)
    {
        mIsShowRequested = false;
        mAdRequestType = ad_type;

        //request content from server
        if (mAdRequestType == KidozInterstitial.AD_TYPE.INTERSTITIAL)
        {
            mContentLogicLoader.loadWaterfall(mContext,WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(),mStyleId,"0");
//            loadWaterfall
//            mContentLogicLoader.loadContent(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), mStyleId);
        }
        else
        {
            mContentLogicLoader.loadWaterfall(mContext,WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(),mStyleId,"1");
//            mContentLogicLoader.loadContent(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(), mStyleId);
        }
        mCurrentIndex = 0;
        //oooOri debug lines those lines should be called from the get content response

//        this.prepareWebViewWithLink("http://kidoz.test.bucket.s3.amazonaws.com/ori/requirejs/endcard.html");


        //ooooOri end debug code


//        if (mIsInitializationFinished == true)
//        {
//            // Reset loading request flag in case something got wrong an we never accepted any answer from the HTML
//            if (System.currentTimeMillis() - mLoadRequestTM > REQUEST_FILTER_TIMEOUT)
//            {
//                mIsLoadRequested = false;
//            }
//
//            if (mIsLoadRequested == false)
//            {
//                mIsLoaded = false;
//                mIsLoadRequested = true;
//                mLoadRequestTM = System.currentTimeMillis();
//                if (webView != null)
//                {
//                    webView.requestVastAds(ad_type.getValue());
//                }
//            }
//        }
//        else
//        {
//            mIsLoadRequestedWhileNotReady = true;
//        }
    }

    public synchronized void show()
    {
        if (mIsLoaded)
        {
            if (mIsShowRequested == false)
            {
                mIsShowRequested = true;
                openView();
            }
        }
        else
        {
            Log.w("KidozInterstitial", "Interstitial Ad is not loaded! Please call loadAd() first.");
        }
    }

    public boolean isInterstitialLoaded()
    {
        return mIsLoaded;
    }

    /**
     * Prepare correct interstitial dialog depending on the type of the HTML used
     * I both cases of Default and non default HTMl we need to wait until loading is finished before showing
     * the interstitial view for correct flow
     */
    protected synchronized void openView()
    {
        if (mLaunchLock.tryLock())
        {
            try
            {
                try
                {
                    Intent intent = new Intent(mContext, KidozAdActivity.class);
                    intent.putExtra(KidozAdActivity.STYLE_ID_KEY, mStyleId);

                    if (mAdProperties != null)
                    {
                        intent.putExtra(KidozAdActivity.DISABLE_BACK_KEY, mAdProperties.optBoolean("interstitial_lock", false));
                    }

                    if (mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO)
                    {
                        intent.putExtra(KidozAdActivity.DISABLE_BACK_KEY, true);
                    }

                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_REORDER_TO_FRONT | Intent.FLAG_ACTIVITY_SINGLE_TOP);


                    if (mInnerHelperInterface != null)
                    {
                        mInnerHelperInterface.onAdOpen();
                    }

                    mContext.startActivity(intent);
                }
                catch (Exception e)
                {
                }
            }
            finally
            {
                mLaunchLock.unlock();
            }
        }
    }

    // Event bus callback
    @Subscribe
    public void onHandleEvent(EventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK)
        {
            validateLayoutAndAssets();
        }
    }

    public void validateIfPrepared()
    {
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }

        if (mIsInitializationFinished == false)
        {

            PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
            if (appConfig != null)
            {
                prepareWebViewWithLink(appConfig.getInterstitialHtmlLink());

            }


        }
    }

    private String getUrlFromContent(ContentItem item)
    {
        String url;
        PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
        url = item.getHTMLUrl();
        if(url == null)
        {
            switch (item.getHtmlType())
            {
                case NONE:
                    break;
                case VAST:
                    url = appConfig.getInterstitialDefaultLinkForType("vast");
                    break;
                case MRAID:
                    url = appConfig.getInterstitialDefaultLinkForType("mraid");
                    break;
                case DOUBLE_CLICK:
                    url = appConfig.getInterstitialDefaultLinkForType("double_click");
                    break;
                case SUPER_AWESOME:
                    url = appConfig.getInterstitialDefaultLinkForType("super_awesome");
                    break;
                case JAVASCRIPT:
                    url = appConfig.getInterstitialDefaultLinkForType("javascript");
                    break;
            }
        }

        return url;
    }
    public interface InnerHelperInterface
    {
        void onAdOpen();

        void onAdClose();
    }

    public void setIsLocalRequest(boolean local)
    {
        mIsLocal = local;
    }

    public boolean getIsLocal()
    {
        return mIsLocal;
    }
}
