package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.VideoUnitDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnitActivity;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

import java.io.File;

/**
 * Created by RonyBrosh on 10/30/2016.
 */

public class KidozButton extends RelativeLayout
{
    public static final String TAG = KidozButton.class.getSimpleName();
    private final float BUTTON_SIZE_RATIO = 0.20f;
    private AssetView mAssetView;
    private KidozButtonListener mKidozButtonListener;
    private WidgetType mWidgetType;
    private boolean mIsButtonReady;
    private boolean mIsAlreadySentButtonReady;

    public KidozButton(Context context)
    {
        super(context);
        initView();
    }

    public KidozButton(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    public KidozButton(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        initView();
    }

    public void setKidozButtonListener(KidozButtonListener kidozButtonListener)
    {
        mKidozButtonListener = kidozButtonListener;
        if (mKidozButtonListener != null && mIsAlreadySentButtonReady == false && mIsButtonReady == true)
        {
            mIsAlreadySentButtonReady = true;
            mKidozButtonListener.onButtonReady();
        }
    }

    public void setWidgetType(WidgetType widgetType)
    {
        mWidgetType = widgetType;
        loadAssetView();
    }

    private void initView()
    {
        setVisibility(View.INVISIBLE);

        Point point = Utils.getScreenSize(getContext());
        int size = (int) (Math.min(point.x, point.y) * BUTTON_SIZE_RATIO);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);

        // 1. Init View.
        initRootView(params);

        // 2. Init asset view.
        initAssetView(params);

        // 3. Load asset view.
        loadAssetView();
    }

    private void initRootView(RelativeLayout.LayoutParams params)
    {
        setLayoutParams(params);
        setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(final View view)
            {
                view.setClickable(false);
                GenAnimator.clickItemAnimation(KidozButton.this, 70, new GenAnimator.ViewAnimationListener()
                {
                    @Override
                    public void onAnimationEnd()
                    {
                        view.setClickable(true);
                        mKidozButtonListener.onClick();
                    }

                    @Override
                    public void onAnimationStart()
                    {

                    }
                });
            }
        });
    }


    private void initAssetView(RelativeLayout.LayoutParams params)
    {
        mAssetView = new AssetView(getContext());
        mAssetView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        addView(mAssetView, params);
    }

    private void loadAssetView()
    {
        setVisibility(View.INVISIBLE);
        File assetFile = null;
        if (mWidgetType != null)
        {
            switch (mWidgetType)
            {
                case WIDGET_TYPE_VIDEO_UNIT:
                {
                    JSONObject jsonObject = DatabaseManager.getInstance(getContext()).getConfigTable().loadProperties(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG);
                    if (jsonObject != null)
                    {
                        try
                        {
                            assetFile = AssetUtil.getAssetFile2(getContext(), jsonObject.getString(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG));
                        }
                        catch (Exception ex)
                        {
                        }
                    }
                    break;
                }
            }
        }

        if (assetFile != null)
        {
            mAssetView.loadAsset(assetFile, new VideoUnitDrawable(), new AssetView.IOnAssetLoadedListener()
            {
                @Override
                public void onAssetLoaded(boolean successful)
                {
                    GenAnimator.playGrowAnimation(KidozButton.this, 350, 0, null, new Animator.AnimatorListener()
                    {
                        @Override
                        public void onAnimationStart(Animator animation)
                        {
                            setVisibility(View.VISIBLE);
                            requestFocus();
                            bringToFront();
                        }

                        @Override
                        public void onAnimationEnd(Animator animation)
                        {
                            requestFocus();
                            bringToFront();
                            mIsButtonReady = true;
                            if (mKidozButtonListener != null && mIsAlreadySentButtonReady == false)
                            {
                                mIsAlreadySentButtonReady = true;
                                mKidozButtonListener.onButtonReady();
                            }
                        }

                        @Override
                        public void onAnimationCancel(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationRepeat(Animator animation)
                        {
                        }
                    });
                }
            });
        }
        else
        {
            if (EventBus.getDefault().isRegistered(this) == false)
            {
                EventBus.getDefault().register(this);
            }
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY)
        {
            loadAssetView();

            if (EventBus.getDefault().isRegistered(this) == true)
            {
                EventBus.getDefault().unregister(this);
            }
        }
    }

    public interface KidozButtonListener
    {
        void onClick();

        void onButtonReady();
    }

    @Override
    protected void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();

        if (EventBus.getDefault().isRegistered(this) == true)
        {
            EventBus.getDefault().unregister(this);
        }
    }
}
