package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;

import com.kidoz.sdk.api.general.utils.SDKLogger;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;

/**
 * {@code BaseConnectionClient} Responsible for making a connection to a remote server via different approach methods SOAP and REST
 */
@SuppressLint("NewApi")
public class BaseConnectionClient
{
    protected static String mPublicherId = null;
    protected static String mSecurityToken = null;

    protected static final String HTTP_SCHEME = "https://";
    protected static String DOMAIN = "sdk.kidoz.net";
    protected static final String MAIN_API = "/api/sdk";
    protected static final String KIDOZ_ANALITYCS_SERVER_URL = "analytics.kidoz.net/parents/KidozRestMobile.php";
    protected static final String SDK_API_URL = "sdk-api.kidoz.net/api/";
    protected static String WATERFALL_URL = "/api/waterfall";
    protected static String WATERFALL_DOMAIN = null;

    public static void updateDomain(String domain)
    {
        if (domain != null && !domain.equals(""))
        {
            DOMAIN = domain;
        }
    }

    public static void updateWaterfallDomain(String domain)
    {
        if (domain != null && !domain.equals(""))
        {
            WATERFALL_DOMAIN = domain;
        }
    }

    protected final static String TAG = BaseConnectionClient.class.getSimpleName();

    protected enum CONNECTION_TYPE
    {
        POST, GET
    }

    //  private static OkHttpClient client;
    // private static final MediaType JSON = MediaType.parse("application/x-www-form-urlencoded; charset=utf-8");

    /**
     * Initiate http conn ection client
     */
    protected static void initConnectionClient(Context context)
    {
        // getOkHttpClient();
        initCookieManager();
        // initSSLCertificate();
    }

    /**
     * Initiate cookie manager
     */
    private static void initCookieManager()
    {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }

    /**
     * Make Post connection // Uses MORE preferable HTTP connection library
     *
     * @param url           url
     * @param contentValues http parameters
     */
    public static String makePostConnection(String url, final ContentValues contentValues)
    {
        String response = null;

        try
        {
            URL mUrl = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection) mUrl.openConnection();
            httpConnection.setRequestMethod("POST");
            httpConnection.setChunkedStreamingMode(0);
            httpConnection.setUseCaches(false);
            httpConnection.setAllowUserInteraction(false);
            httpConnection.setConnectTimeout(10000);
            httpConnection.setReadTimeout(10000);
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setDoInput(true);
            httpConnection.setDoOutput(true);

            BufferedOutputStream os = new BufferedOutputStream(httpConnection.getOutputStream());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(getPostDataString(contentValues));

            writer.flush();
            writer.close();
            os.close();

            httpConnection.connect();

            int responseCode = httpConnection.getResponseCode();

            if (responseCode == HttpURLConnection.HTTP_OK)
            {
                response = StreamToStringConverter.readStream(new BufferedInputStream(httpConnection.getInputStream()), null, false);
            }

            httpConnection.disconnect();
        } catch (IOException e)
        {
            SDKLogger.printErrorLog(" \n IO Exception POST request! \n" + e.getMessage());
        }

        return response;
    }

    private static String getPostDataString(ContentValues contentValues) throws UnsupportedEncodingException
    {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        Set<String> set = contentValues.keySet();
        Iterator<String> iter = set.iterator();
        while (iter.hasNext())
        {
            String val = iter.next();

            if (first)
                first = false;
            else
                result.append("&");

            result.append(val);
            result.append("=");
            result.append(contentValues.getAsString(val));
        }
        return result.toString();
    }

    /**
     * Make GET connection
     *
     * @param url           url
     * @param contentValues http parameters
     */
    public static String makeGetConnection(String url, ContentValues contentValues)
    {
        String response = null;

        StringBuilder sb = new StringBuilder(url);
        if (contentValues != null && contentValues.size() > 0)
        {
            sb.append("?");

            Set<String> set = contentValues.keySet();
            Iterator<String> iter = set.iterator();
            if (iter.hasNext())
            {
                String val = iter.next();
                sb.append(val).append("=").append(Uri.encode(contentValues.getAsString(val)));
            }
            while (iter.hasNext())
            {
                String val = iter.next();
                sb.append("&");
                sb.append(val).append("=").append(Uri.encode(contentValues.getAsString(val)));
            }
        }

        try
        {
            URL mUrl = new URL(sb.toString());
            HttpURLConnection httpConnection = (HttpURLConnection) mUrl.openConnection();
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("Content-length", "0");
            httpConnection.setChunkedStreamingMode(0);
            httpConnection.setUseCaches(false);
            httpConnection.setAllowUserInteraction(false);
            httpConnection.setConnectTimeout(10000);
            httpConnection.setReadTimeout(10000);
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setRequestProperty("Access-Key", mPublicherId + "::" + mSecurityToken);
            //params.put("Accept", "*/*");

            httpConnection.connect();

            int responseCode = httpConnection.getResponseCode();

            if (responseCode == HttpURLConnection.HTTP_OK)
            {
                response = StreamToStringConverter.readStream(new BufferedInputStream(httpConnection.getInputStream()), null, false);
            }

            httpConnection.disconnect();
        } catch (IOException e)
        {
            SDKLogger.printErrorLog(" \n IO Exception GET request! \n" + e.getMessage());
        }

        return response;
    }

    public static boolean downloadAndSaveFile(String fileURL, File destinationFile)
    {
        boolean result = false;
        try
        {
            SDKLogger.printDebbugLog(TAG, "Downloading file url: " + fileURL);

            URL mUrl = new URL(fileURL);
            HttpURLConnection httpConnection = (HttpURLConnection) mUrl.openConnection();
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("Content-length", "0");
            httpConnection.setChunkedStreamingMode(0);
            httpConnection.setUseCaches(false);
            httpConnection.setAllowUserInteraction(false);
            httpConnection.setConnectTimeout(10000);
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setRequestProperty("Access-Key", mPublicherId + "::" + mSecurityToken);
            //params.put("Accept", "*/*");
            httpConnection.setReadTimeout(10000);

            httpConnection.connect();

            int responseCode = httpConnection.getResponseCode();

            if (responseCode == HttpURLConnection.HTTP_OK)
            {

                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpConnection.getInputStream());
                FileOutputStream outputStream = new FileOutputStream(destinationFile);
                byte[] buf = new byte[1024];
                int len;
                while ((len = bufferedInputStream.read(buf)) > 0)
                {
                    outputStream.write(buf, 0, len);
                }
                outputStream.close();
                bufferedInputStream.close();
                result = true;
            }

            httpConnection.disconnect();
        } catch (Exception ex)
        {
            SDKLogger.printDebbugLog(TAG, "Error when trying download file: " + ex.getMessage());
        }
        return result;
    }

    public interface IOnImageRequestCallback
    {
        void onImageRecieved(InputStream inputStream) throws IOException;
    }

    public static void makeAsyncGet(final String url, final ContentValues contentValues)
    {
        new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                makeGetConnection(url, contentValues);
            }
        }).start();
    }
}

