package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.os.AsyncTask;
import android.os.AsyncTask.Status;
import android.os.Build;

import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentData;

import org.json.JSONObject;

import java.util.HashMap;

@SuppressLint("NewApi")
class BaseAPIManager extends BaseConnectionClient
{
    private static final String TAG = BaseAPIManager.class.getSimpleName();
    private HashMap<SdkRequestType, RequestAsyncTask> runningTaskList = new HashMap<>();

    /**
     * Launch specific API request
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    protected void startServerConnection(Context context, String serverUrl, CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog, boolean removePrevRequest)
    {
        if (removePrevRequest)
        {
            try
            {
                if (runningTaskList.containsKey(requestType))
                {
                    if (runningTaskList.get(requestType) != null)
                    {
                        RequestAsyncTask task = runningTaskList.get(requestType);
                        if (task.getStatus() != Status.FINISHED)
                        {
                            task.cancel(true);
                        } else
                        {
                            runningTaskList.remove(requestType);
                        }
                    }
                }
            } catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, " \n Unable to finish Running Request asyncTask ! \n\n " + ex.getMessage());
            }
        }

        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(context, serverUrl, type, requestType, contentValues, numOfReconnecsOnFail, resultCallback, devLog);
        runningTaskList.put(requestType, requestAsyncTask);

        if (Build.VERSION.SDK_INT < 11)
        {
            requestAsyncTask.execute();
        } else
        {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
    }

    /**
     * Background Async Task executor for HTTP server requests
     */
    class RequestAsyncTask extends AsyncTask<Void, Void, ResultData<?>>
    {

        private CONNECTION_TYPE restRequestType = CONNECTION_TYPE.POST;
        private ApiResultCallback<?> mResultCallback;
        private int numOfReconnectionsOnFail = 0;
        private SdkRequestType sdkRequestType;
        private ContentValues mContentValues;
        private Context mContext;
        private boolean mDeveloperLogging = false;
        private String mServerUrl;

        public RequestAsyncTask(Context context, String serverUrl, CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog)
        {
            mContext = context;
            restRequestType = type;
            sdkRequestType = requestType;
            mContentValues = contentValues;
            mResultCallback = resultCallback;
            numOfReconnectionsOnFail = numOfReconnecsOnFail;
            mDeveloperLogging = devLog;
            mServerUrl = serverUrl;
        }

        @Override
        protected ResultData<?> doInBackground(Void... params)
        {
            String dataResponce = null;
            ResultData<?> webServiceResult = null;

            int mReconnectionTries = 0;
            if (!isCancelled())
            {
                //  Response response = null;
                while (mReconnectionTries <= numOfReconnectionsOnFail) // make reconnection tries
                {
                    mReconnectionTries = mReconnectionTries + 1;
                    if (!isCancelled())
                    {
                        try
                        {
                            if (restRequestType == CONNECTION_TYPE.POST)
                            {
                                dataResponce = makePostConnection(mServerUrl, mContentValues);
                            } else if (restRequestType == CONNECTION_TYPE.GET)
                            {
                                dataResponce = makeGetConnection(mServerUrl, mContentValues);
                            }
                        } catch (Exception e)
                        {
                            if (sdkRequestType != null)
                            {
                                SDKLogger.printErrorLog(" \n IO Exception On [" + sdkRequestType.name() + "] request! \n" + e.getMessage());
                            }
                        }
                    } else
                    {
                        break;
                    }

                    if (!isCancelled())
                    {
                        if (dataResponce != null)
                        {
                            break;
                        }
                    } else
                    {
                        break;
                    }

                    try
                    {
                        if (!isCancelled())
                        {
                            Thread.sleep(300 * mReconnectionTries * 2);
                        } else
                        {
                            break;
                        }
                    } catch (Exception e)
                    {
                        break;
                    }
                }
            }

            // Print server response string before parsing data response
            if (sdkRequestType != null)
            {
                if (restRequestType == CONNECTION_TYPE.POST)
                {
                    SDKLogger.printPostRequestDebugLog(mServerUrl, mContentValues, sdkRequestType.name());
                } else if (restRequestType == CONNECTION_TYPE.GET)
                {
                    SDKLogger.printGetRequestDebugLog(mServerUrl, mContentValues, sdkRequestType.name());
                }

                SDKLogger.printResponse(dataResponce, restRequestType.name(), sdkRequestType.name());
            }

            if (isCancelled())
            {
                return null;
            }

            if (dataResponce != null)
            {
                if (!isCancelled())
                {
                    if (mContext != null)
                    {
                        try
                        {
                            webServiceResult = parseWebServiceResponse(mContext, sdkRequestType, dataResponce, mDeveloperLogging);
                        } catch (Exception ex)
                        {
                            SDKLogger.printErrorLog(TAG, "Error when trying to parse service response: " + ex.getMessage());
                        }
                    }
                }
                return webServiceResult;
            } else
            {
                return null;
            }
        }

        @Override
        protected void onPostExecute(ResultData<?> result)
        {
            if (!isCancelled())
            {
                if (result == null)
                {
                    if (mResultCallback != null)
                    {
                        mResultCallback.onFailed();
                    }
                } else
                {
                    if (mResultCallback != null)
                    {
                        mResultCallback.onServerResult(result);
                    }
                }
            }
            runningTaskList.remove(sdkRequestType);
        }

        @Override
        protected void onCancelled()
        {
            super.onCancelled();
            if (sdkRequestType != null && runningTaskList != null)
            {
                runningTaskList.remove(sdkRequestType);
            }
        }
    }

    /**
     * Handle the paesing of web service requests
     */
    private ResultData<?> parseWebServiceResponse(Context context, SdkRequestType sdkRequestType, String dataResponce, boolean devLog)
    {

        ResultData<?> webServiceResult = null;
        if (sdkRequestType != null && context != null)
        {
            switch (sdkRequestType)
            {
                case GET_COUNTRY_CODE:
                {
                    try
                    {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<String> resultData = new ResultData<>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful() == true)
                        {
                            JSONObject jSONObject = new JSONObject(dataResponce);
                            JSONObject countryCodeJson = jSONObject.optJSONObject("data");
                            resultData.setData(countryCodeJson.optString("country_code"));
                        }
                        webServiceResult = resultData;
                    } catch (Exception ex)
                    {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse GET_COUNTRY_CODE: " + ex.getMessage());
                    }
                    break;
                }

                //Parsers
                case LOAD_SDK_CONTENT:
                case LOAD_WATERFALL:
                {
                    ContentData contentData = new ContentData();
                    contentData.decodeResponse(dataResponce);
                    ResultData<ContentData> resultData = new ResultData<>();
                    resultData.setData(contentData);
                    webServiceResult = resultData;
                    break;
                }
                case VALIDATE_SDK:
                {
                    try
                    {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<PropertiesObj> resultData = new ResultData<>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful() == true)
                        {
                            JSONObject jSONObject = new JSONObject(dataResponce);
                            PropertiesObj propertiesObj = new PropertiesObj(jSONObject.optJSONObject("data"));
                            resultData.setData(propertiesObj);
                        }
                        webServiceResult = resultData;
                    } catch (Exception ex)
                    {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse validate SDK: " + ex.getMessage());
                    }
                    break;
                }
            }
        }

        return webServiceResult;
    }
}
