package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebChromeClient;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;

public class WebPlayerView extends RelativeLayout
{
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.35f;

    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;

    private LoadingProgressView mLoadingProgressView;
    private Window mWindow;
    private RelativeLayout mNonVideoLayout;
    private boolean mUseNativeTopBar = true;
    private ContentItem mContentItem;

    public WebPlayerView(Window window, Context context, WebPlayerType webPlayerType, boolean useNativeTopBar)
    {
        super(context);
        mWindow = window;
        mWebPlayerType = webPlayerType;
        mUseNativeTopBar = useNativeTopBar;

        initiateView();
    }

    private void initiateView()
    {
        initLayout();
        if (mWebPlayerType != null && mWebPlayerType == WebPlayerType.EXTERNAL_LINK)
        {
            mKidozWebView.setAlpha(0);
            mLoadingProgressView = new LoadingProgressView(getContext());

            Point point = Utils.getScreenSize(getContext());
            int size = (int) (Math.min(point.x, point.y) * LOADING_PROGRESS_DEFAULT_RATIO);
            RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
            mLoadingProgressView.setCircleWidthRelativeToSize(size);
            prParams.addRule(RelativeLayout.CENTER_IN_PARENT);
            addView(mLoadingProgressView, prParams);
            mLoadingProgressView.startLoadingAnimation();
        }
    }

    public void setFullScreenWebChromeClient(ViewGroup viewGroup)
    {
        FullScreenVideoEnabledWebChromeClient mWebChromeClient = new FullScreenVideoEnabledWebChromeClient(mNonVideoLayout, viewGroup, null, mKidozWebView)
        {
            @Override
            public void onProgressChanged(WebView view, int progress)
            {

            }
        };
        mWebChromeClient.setOnToggledFullscreen(new FullScreenVideoEnabledWebChromeClient.ToggledFullscreenCallback()
        {
            @Override
            public void toggledFullscreen(boolean fullscreen)
            {
                if (mWindow != null)
                {
                    if (fullscreen)
                    {
                        WindowManager.LayoutParams attrs = mWindow.getAttributes();
                        attrs.flags |= WindowManager.LayoutParams.FLAG_FULLSCREEN;
                        attrs.flags |= WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;

                        mWindow.setAttributes(attrs);

                        int flag = View.SYSTEM_UI_FLAG_HIDE_NAVIGATION;
                        if (Build.VERSION.SDK_INT >= 16)
                        {
                            if (Build.VERSION.SDK_INT < 19)
                            {
                                flag = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN;
                            }
                            else
                            {
                                flag = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE;
                            }
                        }
                        mWindow.getDecorView().setSystemUiVisibility(flag);
                    }
                    else
                    {
                        WindowManager.LayoutParams attrs = mWindow.getAttributes();
                        attrs.flags &= ~WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
                        mWindow.setAttributes(attrs);
                        if (android.os.Build.VERSION.SDK_INT >= 14)
                        {
                            mWindow.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
                        }
                    }
                }
            }
        });
        mKidozWebView.setWebChromeClient(mWebChromeClient);
    }

    private void initLayout()
    {
        // 1. Create Relative layout container for webview.
        mNonVideoLayout = new RelativeLayout(getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        if (mWebPlayerType != null && mWebPlayerType != WebPlayerType.ROVIO || mUseNativeTopBar)
        {
            Point point = Utils.getScreenSize(getContext());
            params.topMargin = (int) (Math.max(point.x, point.y) * KidozTopBar.BACKGROUND_RATIO);
        }
        mNonVideoLayout.setId(Utils.generateViewId());
        addView(mNonVideoLayout, params);

        // 2. Create webview.
        params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        mKidozWebView = new KidozWebView(getContext(), mWebPlayerType);
        mKidozWebView.setId(Utils.generateViewId());
        mNonVideoLayout.addView(mKidozWebView, params);
        mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener()
        {
            @Override
            public void onLounch()
            {
                if (mRemoveViewRequestListener != null)
                {
                    mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
    }

   /* public void loadWebUrl(String url, String googlePlayAppId)
    {
        mKidozWebView.loadWebUrl(url, googlePlayAppId);
    }*/

    public void loadWebUrlWithAllowedDomains(String[] allowedDomains, String url, String googlePlayAppId)
    {
        mKidozWebView.loadWebUrl(allowedDomains, url, googlePlayAppId);
    }

    @Override
    protected void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();

        if (mKidozWebView != null)
        {
            mKidozWebView.stopLoading();
        }
    }

    /**
     * Set on remove view request listener
     *
     * @param listener click listener
     */
    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener)
    {
        mRemoveViewRequestListener = listener;
    }

    /**
     * Close the view and release inner resources
     */
    public void releaseAndcloseView()
    {
        if (mKidozWebView != null)
        {
            mKidozWebView.stopAndReleaseWebView();
        }

        if (mLoadingProgressView != null)
        {
            mLoadingProgressView.stopLoadingAnimation();
        }
    }

    /**
     * Request remove view listener
     */
    public interface IOnRemoveViewRequestListener
    {
        void onRemoveView();
    }

    public KidozWebView getKidozWebView()
    {
        return mKidozWebView;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh)
    {
        super.onSizeChanged(w, h, oldw, oldh);

        int size = (int) (Math.min(w, h) * LOADING_PROGRESS_DEFAULT_RATIO);
        if (mLoadingProgressView != null)
        {
            mLoadingProgressView.getLayoutParams().height = size;
            mLoadingProgressView.getLayoutParams().width = size;
            mLoadingProgressView.setCircleWidthRelativeToSize(size);
        }
    }


    public void setContentItem(ContentItem contentItem)
    {
        mContentItem = contentItem;
        if (mKidozWebView != null)
        {
            mKidozWebView.setContentItem(mContentItem);
        }
    }
}
