package com.kidoz.sdk.api.platforms;

import android.content.Context;

import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.unity3d.player.UnityPlayer;

/**
 * Helper class for Unity vs android communication handling
 */
public final class KidozUnityBridge extends BasePlatformsBridge
{
    private String mGameObject;

    // Feed view callback methods
    private String mShowMethodName;
    private String mDismissMethodName;
    private String mFeedReadyMethodName;

    // Panel callback methods
    private String mExpandMethodName;
    private String mCollapseMethodName;
    private String mReadyMethodName;

    // FlexiView callback methods
    private String mFlexiViewReadyMethodName;
    private String mFlexiViewVisibleMethodName;
    private String mFlexiViewHiddenMethodName;

    //General callback methods
    private String mGenPlyerOpenMethodName;
    private String mGenPlyerCloseMethodName;

    // Interstitial callback methods
    private String mInterstReadyMethodName;
    private String mInterstOpenedMethodName;
    private String mInterstClosedMethodName;
    private String mInterstFailedLoadMethodName;

    private String mInterstRewardedMethodName;
    private String mInterstRewardedVideoStarted;

    private String mVideoUnitReadyMethodName;
    private String mVideoUnitOpenMethodName;
    private String mVideoUnitCloseMethodName;

    public KidozUnityBridge(Context context)
    {
        super(context);

        ConstantDef.SDK_EXTENSION_TYPE = ConstantDef.EXTENSION_TYPE_UNITY;
    }

    public static KidozUnityBridge getInstance(Context context)
    {
        return new KidozUnityBridge(context);
    }

    @Override
    public void onClbkFeedDismissView()
    {
        if (mGameObject != null && mDismissMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mDismissMethodName, "Dismiss");
        }
    }

    @Override
    public void onClbkFeedReadyToShow()
    {
        if (mGameObject != null && mShowMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mShowMethodName, "Show");
        }
    }

    @Override
    public void onClbkFeedViewReady()
    {
        if (mGameObject != null && mFeedReadyMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mFeedReadyMethodName, "FeedReady");
        }
    }

    @Override
    public void onClbkPanelViewCollapsed()
    {
        if (mGameObject != null && mCollapseMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mCollapseMethodName, "Collapse");
        }
    }

    @Override
    public void onClbkPanelViewReady()
    {
        if (mGameObject != null && mReadyMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mReadyMethodName, "Ready");
        }
    }

    @Override
    public void onClbkPanelViewExpanded()
    {
        if (mGameObject != null && mExpandMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mExpandMethodName, "Expand");
        }
    }

    @Override
    public void onClbkFlexiViewReady()
    {
        if (mGameObject != null && mFlexiViewReadyMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mFlexiViewReadyMethodName, "Flexi view ready");
        }
    }

    @Override
    public void onClbkFlexiViewHidden()
    {
        if (mGameObject != null && mFlexiViewHiddenMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mFlexiViewHiddenMethodName, "Flexi view hidden");
        }
    }

    @Override
    public void onClbkFlexiViewVisible()
    {
        if (mGameObject != null && mFlexiViewVisibleMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mFlexiViewVisibleMethodName, "Flexi view visible");
        }
    }

    @Override
    public void onClbkPlayerOpened()
    {
        if (mGameObject != null && mGenPlyerOpenMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mGenPlyerOpenMethodName, "Player opened");
        }
    }

    @Override
    public void onClbkPlayerClosed()
    {
        if (mGameObject != null && mGenPlyerCloseMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mGenPlyerCloseMethodName, "Player closed");
        }
    }

    @Override
    public void onClbkInterstitialOpened()
    {
        if (mGameObject != null && mInterstOpenedMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mInterstOpenedMethodName, "Interstitial Opened");
        }
    }

    @Override
    public void onClbkInterstitialClosed()
    {
        if (mGameObject != null && mInterstClosedMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mInterstClosedMethodName, "Interstitial Closed");
        }
    }

    @Override
    public void onClbkInterstitialReady()
    {
        if (mGameObject != null && mInterstReadyMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mInterstReadyMethodName, "Interstitial Ready");
        }
    }

    @Override
    public void onClbkInterstitialLoadFailed()
    {
        if (mGameObject != null && mInterstFailedLoadMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mInterstFailedLoadMethodName, "Interstitial Load Failed");
        }
    }

    @Override
    public void onClbkRewarded()
    {
        if (mGameObject != null && mInterstRewardedMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mInterstRewardedMethodName, "Rewarded Video");
        }
    }

    @Override
    public void onClbkRewardedVideoStarted()
    {
        if (mGameObject != null && mInterstRewardedVideoStarted != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mInterstRewardedVideoStarted, "Rewarded Video Started");
        }
    }

    @Override
    public void onClbkVideoUnitReady()
    {
        if (mGameObject != null && mVideoUnitReadyMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mVideoUnitReadyMethodName, "Video Unit Ready");
        }
    }

    @Override
    public void onClbkVideoUnitOpen()
    {
        if (mGameObject != null && mVideoUnitOpenMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mVideoUnitOpenMethodName, "Video Open");
        }
    }

    @Override
    public void onClbkVideoUnitClose()
    {
        if (mGameObject != null && mVideoUnitCloseMethodName != null)
        {
            UnityPlayer.UnitySendMessage(mGameObject, mVideoUnitCloseMethodName, "Video Close");
        }
    }

    /**
     * Set callback for listening feed view events
     *
     * @param gameObject
     */
    public void setFeedViewEventListeners(String gameObject, String showMethodName, String dismissMethodName, String feedReadyMethodName)
    {
        mGameObject = gameObject;
        mShowMethodName = showMethodName;
        mDismissMethodName = dismissMethodName;
        mFeedReadyMethodName = feedReadyMethodName;
    }

    /**
     * Set callback for listening for panel open/close events
     *
     * @param gameObject
     */
    public void setPanelViewEventListeners(String gameObject, String expandMethodName, String collapseMethodName, String readyMethodName)
    {
        mGameObject = gameObject;
        mExpandMethodName = expandMethodName;
        mCollapseMethodName = collapseMethodName;
        mReadyMethodName = readyMethodName;
    }

    /**
     * Set callback for listening flexi view events
     *
     * @param gameObject
     */
    public void setFlexiViewEventListener(String gameObject, String viewReadyMethodName, String viewVisibleMethodName, String viewHiddenMethodName)
    {
        mGameObject = gameObject;
        mFlexiViewReadyMethodName = viewReadyMethodName;
        mFlexiViewHiddenMethodName = viewHiddenMethodName;
        mFlexiViewVisibleMethodName = viewVisibleMethodName;
    }

    /**
     * Set callback for listening player state events
     *
     * @param gameObject
     */
    public void setPlayersEventListener(String gameObject, String playerOpenedMethodName, String playerClosedMethodName)
    {
        mGameObject = gameObject;
        mGenPlyerOpenMethodName = playerOpenedMethodName;
        mGenPlyerCloseMethodName = playerClosedMethodName;
    }

    /**
     * Set callback for listening Interstitial events
     *
     * @param gameObject
     */
    public void setInterstitialEventListener(String gameObject, String openedMethodName, String closedMethodName, String readyMethodName, String failedMethodName)
    {
        mGameObject = gameObject;
        mInterstOpenedMethodName = openedMethodName;
        mInterstClosedMethodName = closedMethodName;
        mInterstReadyMethodName = readyMethodName;
        mInterstFailedLoadMethodName = failedMethodName;
    }

    /**
     * Set callback for listening rewarded video state events
     *
     * @param gameObject
     */
    public void setRewardedVideoEventListener(String gameObject, String rewardedMethodName, String rewardedVideoStarted)
    {
        mGameObject = gameObject;
        mInterstRewardedMethodName = rewardedMethodName;
        mInterstRewardedVideoStarted = rewardedVideoStarted;
    }

    /**
     * Set callback for listening video unit state events
     *
     * @param gameObject
     */
    public void setVideoUnitEventListener(String gameObject, String videoUnitReadyMethodName, String videoUnitOpenMethodName, String videoUnitCloseMethodName)
    {
        mGameObject = gameObject;
        mVideoUnitReadyMethodName = videoUnitReadyMethodName;
        mVideoUnitOpenMethodName = videoUnitOpenMethodName;
        mVideoUnitCloseMethodName = videoUnitCloseMethodName;
    }
}

