package com.kidoz.sdk.api.platforms;

import android.app.Activity;

import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.Utils.StaticHandler;

/**
 * Created by Eugene on 11/30/2016.
 */

public class KidozSDKCocosDxBridge extends BasePlatformsBridge {
	private static KidozSDKCocosDxBridge mInstance;
	private StaticHandler mStaticHandler;

	private static final int FEED_CLOSE_EVENT = 0;
	private static final int FEED_OPEN_EVENT = 1;
	private static final int FEED_READY_EVENT = 2;
	private static final int PANEL_OPENED_EVENT = 3;
	private static final int PANEL_CLOSED_EVENT = 4;
	private static final int PANEL_READY_EVENT = 5;
	private static final int PLAYER_OPEN_EVENT = 6;
	private static final int PLAYER_CLOSE_EVENT = 7;
	private static final int FLEXI_READY_EVENT = 8;
	private static final int FLEXI_VISIBLE_EVENT = 9;
	private static final int FLEXI_HIDDEN_EVENT = 10;
	private static final int INTERSTITIAL_OPENED_EVEN = 11;
	private static final int INTERSTITIAL_CLOSED_EVEN = 12;
	private static final int INTERSTITIAL_READY_EVEN = 13;
	private static final int INTERSTITIAL_FAILED_EVEN = 14;
	private static final int INTERSTITIAL_REWARDED_EVEN = 15;
	private static final int INTERSTITIAL_REWARDED_VIDEO_START_EVEN = 16;
	private static final int VIDEO_UNIT_READY_EVEN = 17;
	private static final int VIDEO_UNIT_OPEN_EVEN = 18;
	private static final int VIDEO_UNIT_CLOSE_EVEN = 19;

	private Activity mActivity;

	public KidozSDKCocosDxBridge(Activity context) {
		super(context);
		mActivity = context;
		mStaticHandler = new StaticHandler(context.getMainLooper());
	}

	public Activity getActivityContext() {
		return mActivity;
	}

	public static void init(final Activity context) {
		mInstance = new KidozSDKCocosDxBridge(context);
	}

	protected static KidozSDKCocosDxBridge getInstance() {
		return mInstance;
	}

	public static void cdx_initialize(String publisher_Id, String token) {
		if (getInstance() != null && getInstance().getActivityContext() != null) {
			KidozSDK.initialize(getInstance().getActivityContext(),
					publisher_Id, token);
		}
	}

	public static void cdx_addFeedButton(final int x, final int y,
			final int size) {
		getInstance().addFeedButton(x, y, size);
	}

	public static void cdx_showFeedView() {
		getInstance().showFeedView();
	}

	public static void cdx_dismissFeedView() {
		getInstance().dismissFeedView();
	}

	public static void cdx_changeFeedButtonVisibility(boolean visible) {
		getInstance().changeFeedButtonVisibility(visible);
	}

	public static void cdx_addPanelToView(int panel_type, int handle_position) {
		getInstance().addPanelToView(panel_type, handle_position);
	}

	public static void cdx_changePanelVisibility(boolean visible) {
		getInstance().changePanelVisibility(visible);
	}

	public static void cdx_expandPanelView() {
		getInstance().expandPanelView();
	}

	public static void cdx_collapsePanelView() {
		getInstance().collapsePanelView();
	}

	public static boolean cdx_getIsPanelExpanded() {
		return getInstance().getIsPanelExpanded();
	}

	public static void cdx_addFlexiView(boolean isAutoShow, int initialPosition) {
		getInstance().addFlexiView(isAutoShow, initialPosition);
	}

	public static void cdx_showFlexiView() {
		getInstance().showFlexiView();
	}

	public static void cdx_hideFlexiView() {
		getInstance().hideFlexiView();
	}

	public static boolean cdx_getIsFlexiViewVisible() {
		return getInstance().getIsFlexiViewVisible();
	}

	public static void cdx_loadInterstitial(int adType, boolean autoShowOnLoad) {
		getInstance().loadInterstitialAd(autoShowOnLoad, adType);
	}

	public static void cdx_showInterstitial() {
		getInstance().showInterstitial();
	}

	public static boolean cdx_getIsInterstitialLoaded() {
		return getInstance().getIsInterstitialLoaded();
	}

	public static void cdx_showVideoUnit() {
		getInstance().showVideoUnit();
	}
	
	public static void cdx_printToastLog(String log) {
		getInstance().printToastLog(log);
	}

	@SuppressWarnings("JniMissingFunction")
	public static native void callbackInvoke(int eventType);

	private void sendEventToCocosJNI(final int evenType) {
		if (mStaticHandler != null) {
			mStaticHandler.post(new Runnable() {

				@Override
				public void run() {
					callbackInvoke(evenType);
				}
			});
		}
	}

	@Override
	public void onClbkFeedDismissView() {
		sendEventToCocosJNI(FEED_CLOSE_EVENT);
	}

	@Override
	public void onClbkFeedReadyToShow() {
		sendEventToCocosJNI(FEED_OPEN_EVENT);
	}

	@Override
	public void onClbkFeedViewReady() {
		sendEventToCocosJNI(FEED_READY_EVENT);
	}

	@Override
	public void onClbkPanelViewCollapsed() {
		sendEventToCocosJNI(PANEL_CLOSED_EVENT);
	}

	@Override
	public void onClbkPanelViewReady() {
		sendEventToCocosJNI(PANEL_READY_EVENT);
	}

	@Override
	public void onClbkPanelViewExpanded() {
		sendEventToCocosJNI(PANEL_OPENED_EVENT);
	}

	@Override
	public void onClbkFlexiViewReady() {
		sendEventToCocosJNI(FLEXI_READY_EVENT);
	}

	@Override
	public void onClbkFlexiViewHidden() {
		sendEventToCocosJNI(FLEXI_HIDDEN_EVENT);
	}

	@Override
	public void onClbkFlexiViewVisible() {
		sendEventToCocosJNI(FLEXI_VISIBLE_EVENT);
	}

	@Override
	public void onClbkPlayerOpened() {
		sendEventToCocosJNI(PLAYER_OPEN_EVENT);
	}

	@Override
	public void onClbkPlayerClosed() {
		sendEventToCocosJNI(PLAYER_CLOSE_EVENT);
	}

	@Override
	public void onClbkInterstitialOpened() {
		sendEventToCocosJNI(INTERSTITIAL_OPENED_EVEN);
	}

	@Override
	public void onClbkInterstitialClosed() {
		sendEventToCocosJNI(INTERSTITIAL_CLOSED_EVEN);
	}

	@Override
	public void onClbkInterstitialReady() {
		sendEventToCocosJNI(INTERSTITIAL_READY_EVEN);
	}

	@Override
	public void onClbkInterstitialLoadFailed() {
		sendEventToCocosJNI(INTERSTITIAL_FAILED_EVEN);
	}

	@Override
	public void onClbkRewarded() {
		sendEventToCocosJNI(INTERSTITIAL_REWARDED_EVEN);
	}

	@Override
	public void onClbkRewardedVideoStarted() {
		sendEventToCocosJNI(INTERSTITIAL_REWARDED_VIDEO_START_EVEN);
	}

	@Override
	public void onClbkVideoUnitReady() {
		sendEventToCocosJNI(VIDEO_UNIT_READY_EVEN);
	}

	@Override
	public void onClbkVideoUnitOpen() {
		sendEventToCocosJNI(VIDEO_UNIT_OPEN_EVEN);
	}

	@Override
	public void onClbkVideoUnitClose() {
		sendEventToCocosJNI(VIDEO_UNIT_CLOSE_EVEN);
	}

}
