package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class SharedPreferencesUtils
{
    private static final String SDK_SHARED_PREFERENCES_FILE_NAME = "SDK_SHARED_PREFERENCES_FILE_NAME";

    public static void saveSharedPreferencesData(Context context, String key, String value)
    {
        if (context != null)
        {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, Context.MODE_PRIVATE);
            try
            {
                if (key != null)
                {
                    SharedPreferences.Editor editor = settings.edit();
                    editor.putString(key, value);
                    editor.apply();
                }
            }
            catch (Exception e)
            {

            }
        }
    }

    public static String loadSharedPreferencesData(Context context, String key)
    {
        String result = null;
        if (context != null)
        {
            try
            {
                if (key != null)
                {
                    SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, Context.MODE_PRIVATE);
                    result = settings.getString(key, null);
                }
            }
            catch (Exception e)
            {

            }
        }
        return result;
    }

    public static void removeSharedPreferencesData(Context context, String key)
    {
        if (context != null)
        {
            if (key != null)
            {
                SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, Context.MODE_PRIVATE);
                SharedPreferences.Editor editor = settings.edit();
                editor.remove(key);
                editor.apply();
            }
        }
    }

    public static void saveBooleanSharedPreferencesData(Context context, String key, boolean value)
    {
        try
        {
            if (context != null)
            {
                SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, Context.MODE_PRIVATE);
                if (key != null)
                {
                    SharedPreferences.Editor editor = settings.edit();
                    editor.putBoolean(key, value);
                    editor.apply();
                }

            }
        }
        catch (Exception ex)
        {

        }
    }

    public static boolean loadBooleanSharedPreferencesData(Context context, String key)
    {
        boolean result = false;
        try
        {
            if (context != null)
            {
                if (key != null)
                {
                    SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, Context.MODE_PRIVATE);
                    result = settings.getBoolean(key, false);
                }
            }
        }
        catch (Exception ex)
        {

        }
        return result;
    }

    public static boolean hasBooleanSharedPreferencesData(Context context, String key)
    {
        boolean result = false;
        try
        {
            if (context != null)
            {
                if (key != null)
                {
                    SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, Context.MODE_PRIVATE);
                    result = settings.contains(key);
                }
            }
        }
        catch (Exception ex)
        {

        }
        return result;
    }
}
