package com.kidoz.sdk.api.general.utils;

import android.content.ContentValues;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import java.util.Set;

public class SDKLogger
{
    public static final String GENERAL_TAG = "[KIDOZ SDK]";
    protected static boolean IS_DEBUG_MODE = ConstantDef.DGM;
    public static final boolean IS_PICASSO_DEBUG_MODE = false;

    public static void printInfoLog(String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.i(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static void printInfoLog(String tag, String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.i(tag, "[KIDOZ SDK] : " + msg);
        }
    }

    public static void printWarningLog(String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.w(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static void printWarningLog(String tag, String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.w(tag, "[KIDOZ SDK] : " + msg);
        }
    }

    public static void printErrorLog(String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.e(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static void printErrorLog(String tag, String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.e(tag, "[KIDOZ SDK] : " + msg);
        }
    }

    public static void printDebbugLog(String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.d(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static void printDebugToast(Context context, String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
        }
    }

    public static void printDebbugLog(String tag, String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Log.d(tag, msg);
        }
    }

    public static void printGetRequestDebugLog(String url, ContentValues contentValues, String requestType)
    {
        if (IS_DEBUG_MODE)
        {
            if (contentValues != null)
            {
                Log.d(GENERAL_TAG, "|\n|");
                Log.d(GENERAL_TAG, "| \n <<<<< |KIDOZ SDK| **[REQUEST]** API : [GET] , RequestType :  [" + requestType + "] >>>>>\n");
                Log.d(GENERAL_TAG, "[WEBSITE_URL] :" + url + "\n");
                Log.d(GENERAL_TAG, "[PARAMETERS] : \n");

                Set<String> set = contentValues.keySet();
                if (set.size() > 0)
                {
                    for (String key : set)
                    {
                        Log.d(GENERAL_TAG, "-- " + key + " = " + contentValues.getAsString(key));
                        Log.d(GENERAL_TAG, "\n");
                    }
                }
                Log.d(GENERAL_TAG, "|\n|");
            }
        }
    }

    public static void printPostRequestDebugLog(String url, ContentValues contentValues, String requestType)
    {
        if (IS_DEBUG_MODE)
        {
            if (contentValues != null)
            {
                Log.d(GENERAL_TAG, "|\n|");
                Log.d(GENERAL_TAG, "\n<<<<< |KIDOZ SDK| **[REQUEST]** API : [POST] , RequestType :  [" + requestType + "] >>>>>\n\n");

                Log.d(GENERAL_TAG, "[WEBSITE_URL] :\n");
                Log.d(GENERAL_TAG, "[PARAMETERS] : \n");

                Set<String> set = contentValues.keySet();
                if (set.size() > 0)
                {
                    for (String key : set)
                    {
                        Log.d(GENERAL_TAG, "\n");
                        Log.d(GENERAL_TAG, "-- " + key + " = " + contentValues.getAsString(key));
                    }
                }
                Log.d(GENERAL_TAG, "|\n|");
            }
        }
    }

    public static void printResponse(String responce,String requestType, String apiType)
    {
        if (IS_DEBUG_MODE)
        {
            Log.d(GENERAL_TAG, "|\n|");
            Log.d(GENERAL_TAG, "<<<<< |KIDOZ SDK| **[RESPONSE]** API : [" + requestType + "] , RequestType :  [" + apiType + "] >>>>>\n");
            Log.d(GENERAL_TAG, "[RESPONSE STRING] : \n");
            if (responce != null)
            {
                Log.d(GENERAL_TAG, responce + "");
            }
            Log.d(GENERAL_TAG, "|\n|");
        }
    }

    public static void printToast(Context context, String msg)
    {
        if (IS_DEBUG_MODE)
        {
            Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
        }
    }
}
