package com.kidoz.sdk.api.general.utils;



import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EncoderUtils
{
	public static final String TAG = EncoderUtils.class.getSimpleName();

	private static final int BYTE_MSK = 0xFF;
	private static final int HEX_DIGIT_MASK = 0xF;
	private static final int HEX_DIGIT_BITS = 4;
	private static final String HEX_DIGITS = "0123456789ABCDEF";
	
 
	/**
	 * Compute the SHA-1 digest of a String and return the bytes in hexadecimal format.
	 * 
	 * @param text
	 *            the UTF-8 String to be encoded
	 * @return a SHA-1 hash
	 * @throws UnsupportedOperationException
	 *             in the case the VM doesn't support UTF-8 which could be caused by a VM bug, you shouldn't bother catching this exception
	 * @throws NullPointerException
	 *             if the String to be encoded is null
	 */
	public static String SHA1(String text)
	{
		String result = null;
		try
		{
			result = computeSha1OfByteArray(text.getBytes(("UTF-8")));
		}
		catch (Exception ex)
		{
			com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to convert string to SHA1: " + ex.getMessage());
		}
		return result;
	}

	/**
	 * Compute the SHA-1 digest of raw bytes and return the bytes in hexadecimal format.
	 * 
	 * @param message
	 *            the raw byte array to be encoded
	 * @return a SHA-1 hash
	 * @throws UnsupportedOperationException
	 *             in the case SHA-1 MessageDigest is not supported, you shouldn't bother catching this exception
	 */
	private static String computeSha1OfByteArray(final byte[] message) throws UnsupportedOperationException
	{
		try
		{
			MessageDigest md = MessageDigest.getInstance("SHA-1");
			md.update(message);
			byte[] res = md.digest();					 
			return toHexString(res);
		}
		catch (NoSuchAlgorithmException ex)
		{
			throw new UnsupportedOperationException(ex);
		}
	}

	/**
	 * Compute a String in HexDigit from the input.
	 * 
	 * @param byteArray
	 *            a row byte array
	 * @return a hex String
	 */
	private static String toHexString(final byte[] byteArray)
	{		
		StringBuilder sb = new StringBuilder(byteArray.length * 2);
		for (byte aByteArray : byteArray) {
			int b = aByteArray & BYTE_MSK;
			sb.append(HEX_DIGITS.charAt(b >>> HEX_DIGIT_BITS)).append(HEX_DIGITS.charAt(b & HEX_DIGIT_MASK));
		}
		return sb.toString();
	}


	/**
	 * Encrypt string with MD5 algorithm
	 * 
	 * @param text
	 *            inpput string
	 * @return encrypted string
	 */
	public static String toMD5(String text)
	{
		String result = null;
		if (text != null)
		{
			try
			{
				MessageDigest messageDigest = MessageDigest.getInstance("MD5");
				messageDigest.reset();
				messageDigest.update(text.getBytes());

				// Encrypting
				final byte[] resultBytes = messageDigest.digest();
				BigInteger number = new BigInteger(1, resultBytes);
				String encriptedResult = number.toString(16);
				// Padding to add the 0 omitted to the beginning of the string by
				// the BigInteger.
				// As MD5 have to be 32 bytes, if the BigInteger we got is less than
				// 32 bytes we know we need to add zeros
				while (encriptedResult.length() < 32)
				{
					encriptedResult = "0" + encriptedResult;
				}
				result = encriptedResult;
			}
			catch (Exception ex)
			{
				com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG,"Can't create MD5: " + ex.getMessage());
			}
		}
		return result;
	}


	public static String encryptWithMD5(String text)
	{
		String result = null;
		if (text != null)
		{
			try
			{
				MessageDigest messageDigest = MessageDigest.getInstance("MD5");
				messageDigest.reset();
				messageDigest.update(text.getBytes());

				// Encrypting
				final byte[] resultBytes = messageDigest.digest();
				BigInteger number = new BigInteger(1, resultBytes);
				String encriptedResult = number.toString(16);
				// Padding to add the 0 omitted to the beginning of the string by
				// the BigInteger.
				// As MD5 have to be 32 bytes, if the BigInteger we got is less than
				// 32 bytes we know we need to add zeros
				while (encriptedResult.length() < 32)
				{
					encriptedResult = "0" + encriptedResult;
				}
				result = encriptedResult;
			}
			catch (Exception ex)
			{
				com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Can't create MD5: " + ex.getMessage());
			}
		}
		return result;
	}
}
