package com.kidoz.sdk.api.general.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.kidoz.sdk.api.structure.IsEventRecord;

public class IsEventTable extends BaseTable
{
    private final String TAG = IsEventTable.class.getName();

    private static final String TABLE_NAME = "InstallEventTable";

    private static final String COLUMN_APP_ID = "COLUMN_APP_ID";
    private static final String COLUMN_PARAMS = "COLUMN_PARAMS";

    public IsEventTable(DatabaseManager databaseManager, Object syncObject)
    {
        super(databaseManager, syncObject);
    }

    public static synchronized void onCreate(SQLiteDatabase database)
    {
        if (database != null)
        {
            String CREATE_TABLE_STATEMENT = "CREATE TABLE " + TABLE_NAME
                    + "(" + COLUMN_APP_ID + " TEXT PRIMARY KEY,"
                    + COLUMN_PARAMS + " TEXT)";
            database.execSQL(CREATE_TABLE_STATEMENT);
        }
    }

    public static synchronized void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion)
    {
        if (database != null && newVersion > oldVersion)
        {

        }
    }

    /**
     * Insert SDK click download application record
     *
     * @param record sdk record
     */
    public synchronized void insertRecord(IsEventRecord record)
    {
        if (mDBmanager != null && record != null)
        {
            synchronized (mSyncObject)
            {
                int rowsCount = 0;

                SQLiteDatabase database = null;
                try
                {
                    database = mDBmanager.handleDatabase(true);
                    database.beginTransaction();

                    ContentValues values = new ContentValues();
                    values.put(IsEventTable.COLUMN_APP_ID, record.getPackageName());
                    values.put(IsEventTable.COLUMN_PARAMS, record.getStringParams());

                    int rowID = (int) database.insertWithOnConflict(TABLE_NAME, null, values, SQLiteDatabase.CONFLICT_REPLACE);
                    if (rowID != -1)
                    {
                        rowsCount++;
                    }

                    database.yieldIfContendedSafely();
                    database.setTransactionSuccessful();
                } catch (Exception ex)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to insert sdk record data: " + ex.getMessage());
                } finally
                {
                    if (database != null)
                    {
                        database.endTransaction();
                    }
                    mDBmanager.handleDatabase(false);
                }
                printDBLog(DBactionType.INSERT, "InsertRecord", TABLE_NAME, rowsCount);
            }
        }
    }

    /**
     * Get SDK click download application record
     *
     * @param packageName
     */
    public synchronized IsEventRecord getRecord(String packageName)
    {
        IsEventRecord record = null;
        if (mDBmanager != null)
        {
            synchronized (mSyncObject)
            {
                int rowsCount = 0;

                try
                {
                    SQLiteDatabase  database = mDBmanager.handleDatabase(true);

                    String selection = null;
                    String[] selectionArgs = null;
                    if (packageName != null)
                    {
                        selection = IsEventTable.COLUMN_APP_ID + "=?";
                        selectionArgs = new String[]{packageName};
                    }
                    Cursor cursor = database.query(TABLE_NAME, null, selection, selectionArgs, null, null, null);
                    if (cursor != null && cursor.getCount() > 0)
                    {
                        rowsCount = cursor.getCount();
                        cursor.moveToFirst();
                        record = new IsEventRecord(cursor.getString(cursor.getColumnIndex(IsEventTable.COLUMN_PARAMS)));
                    }
                    if (cursor != null)
                    {
                        cursor.close();
                    }
                } catch (Exception e)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load install record: " + e.getMessage());
                } finally
                {
                    mDBmanager.handleDatabase(false);
                }
                printDBLog(DBactionType.LOAD, "load sdk record", TABLE_NAME, rowsCount);
            }
        }
        return record;
    }

    /**
     * Delete SDK click download application record
     *
     * @param packageName
     */
    public synchronized void deleteRecord(String packageName)
    {
        if (mDBmanager != null)
        {
            synchronized (mSyncObject)
            {
                int rowsCount = 0;

                if (packageName == null)
                {
                    clearTable(TABLE_NAME);
                } else
                {
                    SQLiteDatabase database = null;
                    try
                    {
                        database = mDBmanager.handleDatabase(true);
                        database.beginTransaction();
                        String selection = IsEventTable.COLUMN_APP_ID + "=?";
                        String[] selectionArgs = new String[]{packageName};
                        int rowID = database.delete(TABLE_NAME, selection, selectionArgs);
                        if (rowID != -1)
                        {
                            rowsCount = rowID;
                        }

                        database.yieldIfContendedSafely();
                        database.setTransactionSuccessful();
                    } catch (Exception e)
                    {
                        if (e != null)
                            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to delete sdk record: " + e.getMessage());
                    } finally
                    {
                        if (database != null)
                        {
                            database.endTransaction();
                        }
                        mDBmanager.handleDatabase(false);
                    }
                    printDBLog(DBactionType.DELETE, "Delete Install App SDK record", TABLE_NAME, rowsCount);
                }
            }
        }
    }
}