package com.kidoz.sdk.api.general.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DatabaseManager extends SQLiteOpenHelper
{
    private static final String TAG = DatabaseManager.class.getSimpleName();
    public static final String DATABASE_NAME = "KIDOZ_SDK_DATATBASE_1";
    private final static int DATABASE_VERSION = 1;

    private IsEventTable mIsEventTable;
    private ConfigurationTable mConfigurationTable;

    protected final Object mSyncObject = new Object();
    private int mOpenCounter;

    private SQLiteDatabase mDatabase;

    private static DatabaseManager mDatabaseManager;

    public DatabaseManager(Context context)
    {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        initDatabase();
    }

    private void initDatabase()
    {
        mIsEventTable = new IsEventTable(this,mSyncObject);
        mConfigurationTable = new ConfigurationTable(this,mSyncObject);
    }

    @Override public void onCreate(SQLiteDatabase db)
    {
        IsEventTable.onCreate(db);
        ConfigurationTable.onCreate(db);
    }

    @Override public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion)
    {
        IsEventTable.onUpgrade(db, oldVersion, newVersion);
        ConfigurationTable.onUpgrade(db, oldVersion, newVersion);
    }

    /**
     * Get install event table
     * */
    public IsEventTable getIsEventTable()
    {
        return mIsEventTable;
    }

    /**
     * Get Config table
     * */
    public ConfigurationTable getConfigTable()
    {
        return mConfigurationTable;
    }

    /**
     * Open isntance of database
     * */
    public synchronized SQLiteDatabase handleDatabase(boolean open)
    {
        if(open) {
            mOpenCounter++;
            if (mOpenCounter == 1)
            {
                try
                {
                    mDatabase = getWritableDatabase();
                }
                catch (Exception ex)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to open database: " + ex.getMessage());
                }
            }
        }else {
            if (mOpenCounter > 0)
            {
                mOpenCounter--;
            }

            if (mOpenCounter == 0)
            {
                try
                {
                    if(mDatabase != null) {
                        mDatabase.close();
                    }
                }
                catch (Exception ex)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to close database: " + ex.getMessage());
                }
            }
        }

        return mDatabase;
    }

    /**
     * Get instance of database manager
     * */
    public static DatabaseManager getInstance(Context context) {
        if(mDatabaseManager == null) {
            mDatabaseManager = new DatabaseManager(context);
        }
        return mDatabaseManager;
    }
}
