package com.kidoz.sdk.api.dialogs;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.os.Build;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.CloseButtonView;

class ParentalLockLayoutGenerator
{
    static int PARENTAL_CARDVIEW_ID;
    static int FEEDBACK_MESSAGE_CONTAINER_ID;
    static int FEEDBACK_MESSAGE_TEXT_VIEW_ID;
    static int FEEDBACK_ACTION_TEXT_VIEW_ID;
    static int INNER_VIEW_CONTAINER_ID;
    static int EQUATION_VIEW_CONTAINER_ID;
    static int PARENTAL_DIALOG_TITLE_ID;
    static int PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID;
    static int EXIT_BUTTON_ID;
    static int ANIMATABLE_VIEW;

    static int EQUATION_TEXT_VIEW_ID;
    static int ANSWER_1_TEXT_VIEW_ID;
    static int ANSWER_2_TEXT_VIEW_ID;
    static int ANSWER_3_TEXT_VIEW_ID;
    static int ANSWER_4_TEXT_VIEW_ID;

    public static View generateParentalLockView(Context context, int size)
    {

        RelativeLayout baseContainer = new RelativeLayout(context);
        baseContainer.setBackgroundColor(Color.parseColor("#50000000"));
        RelativeLayout.LayoutParams baseParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

        baseParams.addRule(RelativeLayout.CENTER_IN_PARENT);
        FrameLayout wrapContainer = new FrameLayout(context);
        ANIMATABLE_VIEW = Utils.generateViewId();
        wrapContainer.setId(ANIMATABLE_VIEW);
        baseContainer.addView(wrapContainer, baseParams);

        // Create Card view
        KidozCardView kidozCardView = new KidozCardView(context);
        PARENTAL_CARDVIEW_ID = Utils.generateViewId();
        kidozCardView.setId(PARENTAL_CARDVIEW_ID);
        int margin = Utils.dpTOpx(context, 10);
        FrameLayout.LayoutParams frameParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.WRAP_CONTENT, FrameLayout.LayoutParams.WRAP_CONTENT);
        frameParams.setMargins(margin, margin, margin, margin);
        wrapContainer.addView(kidozCardView, frameParams);

        // Create main outer container
        RelativeLayout outerContainer = new RelativeLayout(context);
        kidozCardView.addView(outerContainer, new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.WRAP_CONTENT));

        // Create main holder container
        LinearLayout mainViewContainer = new LinearLayout(context);
        outerContainer.addView(mainViewContainer, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT));
        mainViewContainer.setOrientation(LinearLayout.VERTICAL);
        mainViewContainer.setGravity(Gravity.CENTER);

        //Create X close button
        int closBtnSize = size / 17;
        CloseButtonView closeButtonView = new CloseButtonView(context, closBtnSize, closBtnSize,Color.parseColor("#ffffff"));
        EXIT_BUTTON_ID = Utils.generateViewId();
        closeButtonView.setId(EXIT_BUTTON_ID);
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        relParams.setMargins(0, Utils.dpTOpx(context, 5), Utils.dpTOpx(context, 5), 0);
        outerContainer.addView(closeButtonView, relParams);

        // Upper title container
        LinearLayout topContainerView = new LinearLayout(context);
        topContainerView.setOrientation(LinearLayout.HORIZONTAL);
        topContainerView.setGravity(Gravity.CENTER);

        ImageView LockIcon = new ImageView(context);
        topContainerView.addView(LockIcon, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        TextView parentalLockTitle = new TextView(context);
        PARENTAL_DIALOG_TITLE_ID = Utils.generateViewId();
        parentalLockTitle.setId(PARENTAL_DIALOG_TITLE_ID);
        parentalLockTitle.setGravity(Gravity.CENTER_HORIZONTAL);
        parentalLockTitle.setMaxLines(2);
        parentalLockTitle.setMinLines(2);
        parentalLockTitle.setTextColor(Color.WHITE);
        parentalLockTitle.setTextSize(TypedValue.COMPLEX_UNIT_SP, 21);

        LinearLayout.LayoutParams linParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        linParams.setMargins(Utils.dpTOpx(context, 10), 0, 0, 0);
        topContainerView.addView(parentalLockTitle, linParams);

        // Add upper container to main holder
        mainViewContainer.addView(topContainerView, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        View view = new View(context);
        view.setBackgroundColor(Color.parseColor("#86e6fc"));
        linParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, Utils.dpTOpx(context, 1));
        linParams.setMargins(Utils.dpTOpx(context, 5), 0, Utils.dpTOpx(context, 5), 0);
        // Add line to main holder
        mainViewContainer.addView(view, linParams);

        //Parental dialog message
        TextView parentalLockDialogMesssageView = new TextView(context);
        PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID = Utils.generateViewId();
        parentalLockDialogMesssageView.setId(PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID);
        parentalLockDialogMesssageView.setGravity(Gravity.CENTER_HORIZONTAL);
        parentalLockDialogMesssageView.setPadding(
                Utils.dpTOpx(context, 20), // Left
                Utils.dpTOpx(context, 10), // Top
                Utils.dpTOpx(context, 20), // Right
                Utils.dpTOpx(context, 0) // Bottom
        );
        parentalLockDialogMesssageView.setTextColor(Color.WHITE);
        parentalLockDialogMesssageView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 23);
        mainViewContainer.addView(parentalLockDialogMesssageView, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        //View flipper
        RelativeLayout innerViewCotainer = new RelativeLayout(context);
        INNER_VIEW_CONTAINER_ID = Utils.generateViewId();
        innerViewCotainer.setId(INNER_VIEW_CONTAINER_ID);

        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        params.setMargins(Utils.dpTOpx(context, 15), 0, Utils.dpTOpx(context, 15), Utils.dpTOpx(context, 15));
        mainViewContainer.addView(innerViewCotainer, params);

        // Create Proper layout structure for Equation/Answer
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(LinearLayout.VERTICAL);
        linearLayout.setId(EQUATION_VIEW_CONTAINER_ID);
        LinearLayout topLay = new LinearLayout(context);
        topLay.setGravity(Gravity.CENTER);
        topLay.setOrientation(LinearLayout.HORIZONTAL);
        LinearLayout bottomLay = new LinearLayout(context);
        bottomLay.setOrientation(LinearLayout.HORIZONTAL);

        LinearLayout.LayoutParams weightParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        weightParams.weight = 1;

        linearLayout.addView(topLay, weightParams);

        weightParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        weightParams.weight = 1;
        weightParams.setMargins(Utils.dpTOpx(context, 20), 0, Utils.dpTOpx(context, 20), 0);

        linearLayout.addView(bottomLay, weightParams);
        innerViewCotainer.addView(linearLayout, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));

        // Create positioning structure for the answers
        LinearLayout lin1 = new LinearLayout(context);
        lin1.setGravity(Gravity.CENTER);
        LinearLayout lin2 = new LinearLayout(context);
        lin2.setGravity(Gravity.CENTER);
        LinearLayout lin3 = new LinearLayout(context);
        lin3.setGravity(Gravity.CENTER);
        LinearLayout lin4 = new LinearLayout(context);
        lin4.setGravity(Gravity.CENTER);

        weightParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        weightParams.weight = 1;

        bottomLay.addView(lin1, weightParams);
        bottomLay.addView(lin2, weightParams);
        bottomLay.addView(lin3, weightParams);
        bottomLay.addView(lin4, weightParams);

        // Create equetion view
        TextView equationTextView = new TextView(context);
        EQUATION_TEXT_VIEW_ID = Utils.generateViewId();
        equationTextView.setId(EQUATION_TEXT_VIEW_ID);
        equationTextView.setGravity(Gravity.CENTER);
        equationTextView.setSingleLine(true);
        equationTextView.setTextColor(Color.WHITE);
        equationTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 44);
        topLay.addView(equationTextView);
        //equationTextView.setText("6 + 8 = ?");

        ShapeDrawable shapeDrawable = new ShapeDrawable();
        shapeDrawable.setShape(new OvalShape());
        shapeDrawable.getPaint().setColor(Color.WHITE);

        final LinearLayout.LayoutParams answersParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.MATCH_PARENT);
        margin = Utils.dpTOpx(context, 10);
        answersParams.setMargins(margin, margin, margin, margin);
        answersParams.gravity = Gravity.CENTER;

        int mAnswerCircleSize = size / 5;
        answersParams.width = mAnswerCircleSize;
        answersParams.height = mAnswerCircleSize;

        // Create answer 1 view
        final TextView answ1 = new TextView(context);
        ANSWER_1_TEXT_VIEW_ID = Utils.generateViewId();
        answ1.setId(ANSWER_1_TEXT_VIEW_ID);
        answ1.setSingleLine(true);
        answ1.setTextColor(Color.BLACK);
        answ1.setGravity(Gravity.CENTER);
        answ1.setTextSize(TypedValue.COMPLEX_UNIT_SP, 35);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            answ1.setBackground(shapeDrawable);
        } else
        {
            answ1.setBackgroundDrawable(shapeDrawable);
        }
        lin1.addView(answ1, answersParams);


        // Create answer 2 view
        TextView answ2 = new TextView(context);
        ANSWER_2_TEXT_VIEW_ID = Utils.generateViewId();
        answ2.setId(ANSWER_2_TEXT_VIEW_ID);
        answ2.setSingleLine(true);
        answ2.setGravity(Gravity.CENTER);
        answ2.setTextColor(Color.BLACK);
        answ2.setTextSize(TypedValue.COMPLEX_UNIT_SP, 35);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            answ2.setBackground(shapeDrawable);
        } else
        {
            answ2.setBackgroundDrawable(shapeDrawable);
        }
        lin2.addView(answ2, answersParams);

        // Create answer 3 view
        TextView answ3 = new TextView(context);
        ANSWER_3_TEXT_VIEW_ID = Utils.generateViewId();
        answ3.setId(ANSWER_3_TEXT_VIEW_ID);
        answ3.setGravity(Gravity.CENTER);
        answ3.setSingleLine(true);
        answ3.setTextColor(Color.BLACK);
        answ3.setTextSize(TypedValue.COMPLEX_UNIT_SP, 35);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            answ3.setBackground(shapeDrawable);
        } else
        {
            answ3.setBackgroundDrawable(shapeDrawable);
        }
        lin3.addView(answ3, answersParams);

        // Create answer 4 view
        TextView answ4 = new TextView(context);
        ANSWER_4_TEXT_VIEW_ID = Utils.generateViewId();
        answ4.setId(ANSWER_4_TEXT_VIEW_ID);
        answ4.setGravity(Gravity.CENTER);
        answ4.setSingleLine(true);
        answ4.setTextColor(Color.BLACK);
        answ4.setTextSize(TypedValue.COMPLEX_UNIT_SP, 35);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            answ4.setBackground(shapeDrawable);
        } else
        {
            answ4.setBackgroundDrawable(shapeDrawable);
        }
        lin4.addView(answ4, answersParams);

        RelativeLayout feedBackMessageContainer = new RelativeLayout(context);
        FEEDBACK_MESSAGE_CONTAINER_ID = Utils.generateViewId();
        feedBackMessageContainer.setId(FEEDBACK_MESSAGE_CONTAINER_ID);
        feedBackMessageContainer.setPadding(
                Utils.dpTOpx(context, 10), // Left
                Utils.dpTOpx(context, 20), // Top
                Utils.dpTOpx(context, 10), // Right
                Utils.dpTOpx(context, 5) // Bottom
        );

        TextView feedBackMessageView = new TextView(context);
        FEEDBACK_MESSAGE_TEXT_VIEW_ID = Utils.generateViewId();
        feedBackMessageView.setId(FEEDBACK_MESSAGE_TEXT_VIEW_ID);
        feedBackMessageView.setGravity(Gravity.CENTER);
        feedBackMessageView.setSingleLine(true);
        feedBackMessageView.setTextColor(Color.WHITE);
        feedBackMessageView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 22);

        relParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        relParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
        relParams.setMargins(
                Utils.dpTOpx(context, 10), // Left
                0, // Top
                Utils.dpTOpx(context, 10), // Right
                0 // Bottom
        );
        feedBackMessageContainer.addView(feedBackMessageView, relParams);

        TextView feedBackActionView = new TextView(context);
        FEEDBACK_ACTION_TEXT_VIEW_ID = Utils.generateViewId();
        feedBackActionView.setId(FEEDBACK_ACTION_TEXT_VIEW_ID);
        feedBackActionView.setGravity(Gravity.CENTER);
        feedBackActionView.setTextColor(Color.WHITE);
        feedBackActionView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 22);

        relParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        relParams.setMargins(
                0, // Left
                0, // Top
                Utils.dpTOpx(context, 10), // Right
                0 // Bottom
        );
        feedBackMessageContainer.addView(feedBackActionView, relParams);

        innerViewCotainer.addView(feedBackMessageContainer, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));
        feedBackMessageContainer.setVisibility(View.INVISIBLE);

        return baseContainer;
    }
}
