package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.StringAssetsUtils;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkToast;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;

import org.greenrobot.eventbus.EventBus;

import java.util.Random;

public class ParentalLockDialog extends BaseDialog
{
    private static final int DIALOG_BACKGROUND = Color.parseColor("#0fcaf7");
    private static final int DIALOG_BACKGROUND_CORNER_RADIUS = 4; //DP

    public static final float PIVOT_X_FACTOR = 0.722f;
    public static final float PIVOT_Y_FACTOR = 0.04f;

    private final String TAG = ParentalLockDialog.class.getSimpleName();
    public static final String PARENTAL_LOCK_ACTIVE_KEY = "PARENTAL_LOCK_ACTIVE_KEY_BOOLEAN";

    private final int NUMBER_OF_COLUMNS = 4;

    private int[] mPopLocation;

    private View mRootView;
    private TextView mDialogMessage;
    private TextView mDialogTitleTextView;
    private boolean mIsLockActive;
    private ParentLockDialogListener mParentLockDialogListener;
    private boolean mIsGateToGooglePlay;
    private boolean mIsLockChangeSuccessfully;

    private TextView mEquationTextView;
    private LinearLayout mEquationContainerView;
    private TextView mResTextView1;
    private TextView mResTextView2;
    private TextView mResTextView3;
    private TextView mResTextView4;

    // Feedback message related.
    private RelativeLayout mInnerViewContainer;
    private TextView mFeedbackMessage;
    private TextView mFeedbackMessageAction;
    private View mFeedbackMessageContainer;
    private View mAnimatableView;

    private int mCounter;
    private Handler mHandler;

    private int mRightResultIndex;
    private Random random = new Random();
    private int mSize;

    public ParentalLockDialog(Context context, boolean isGateToGooglePlay, int[] popLocation)
    {
        super(context, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);
        mPopLocation = popLocation;

        mIsGateToGooglePlay = isGateToGooglePlay;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        mSize = Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false));
        if (ScreenUtils.getIsTablet(getContext()) == true)
        {
            mSize = (int) (0.8f * mSize);
        }

        mRootView = ParentalLockLayoutGenerator.generateParentalLockView(getContext(),mSize);
        setContentView(mRootView);
        initDialog();
    }

    private void initDialog()
    {
        mHandler = new Handler();
        initDialogBackgroundView();

        // initParameters();
        initTitle();
        initDialogWidth();
        initExitButton();
        initQuestionAnswerView();
        initMessageTextView();
        initFeedbackMessageView();
        prepareDialog();
        mCounter = 0;
    }

    private void initDialogBackgroundView()
    {
        KidozCardView kidozCardView = (KidozCardView) mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_CARDVIEW_ID);
        kidozCardView.setRadius(Utils.dpTOpx(getContext(), DIALOG_BACKGROUND_CORNER_RADIUS));
        kidozCardView.setCardBackgroundColor(DIALOG_BACKGROUND);
    }

    private void initFeedbackMessageView()
    {
        // Init relevant text views and container.
        mFeedbackMessageContainer = mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_CONTAINER_ID);

        mFeedbackMessageContainer.setSoundEffectsEnabled(false);
        mFeedbackMessageContainer.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                prepareDialog();
                if (mIsLockChangeSuccessfully == true)
                {
                    mIsLockChangeSuccessfully = false;
                }
                animateFeedBackMessageBack();
            }
        });

        mFeedbackMessage = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_TEXT_VIEW_ID);
        mFeedbackMessageAction = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_ACTION_TEXT_VIEW_ID);

        mInnerViewContainer = (RelativeLayout) mRootView.findViewById(ParentalLockLayoutGenerator.INNER_VIEW_CONTAINER_ID);
        mInnerViewContainer.getLayoutParams().width = mSize;
       // mInnerViewContainer.getLayoutParams().height = (int) (mSize / NUMBER_OF_COLUMNS * 1.85f);
        mInnerViewContainer.getLayoutParams().height = (int) (mSize / NUMBER_OF_COLUMNS * 1.85f);
    }

    private void initTitle()
    {
        mDialogTitleTextView = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_DIALOG_TITLE_ID);
    }

    private void initDialogWidth()
    {
        mAnimatableView = mRootView.findViewById(ParentalLockLayoutGenerator.ANIMATABLE_VIEW);
        if (ScreenUtils.getIsTablet(getContext()) == false)
        {
            mAnimatableView.getLayoutParams().width = Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false));
        } else
        {
            mAnimatableView.getLayoutParams().width = (int) (0.8f * Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
        }
    }

    private void prepareDialog()
    {
        try
        {
            mIsLockActive = isParentalLockActive(getContext());

            // Init Dialog title.
            if (mIsGateToGooglePlay == true)
            {
                mDialogTitleTextView.setText(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_FOR_GOOGLE_PLAY));
            } else
            {
                if (mIsLockActive == true)
                {
                    mDialogTitleTextView.setText(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_DEACTIVATE));
                } else
                {
                    mDialogTitleTextView.setText(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_ACTIVATE));
                }
            }

            if (mIsGateToGooglePlay == true)
            {
                mDialogMessage.setText(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_GOOGLE_PLAY_GATE_NEW));
            } else
            {
                if (mIsLockActive == true)
                {
                    mDialogMessage.setText(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_LOCK_DEACTIVATION_NEW));
                } else
                {
                    mDialogMessage.setText(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_LOCK_ACTIVATION_NEW));
                }
            }
            //   }
        } catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to prepareDialog: " + ex.getMessage());
        }

        generateQuestionAnswerSequence();
    }

    private void initMessageTextView()
    {
        mDialogMessage = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID);
    }

    private void initExitButton()
    {
        mRootView.findViewById(ParentalLockLayoutGenerator.EXIT_BUTTON_ID).setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        closeParentalDialog();
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
    }

    private void initQuestionAnswerView()
    {

        mEquationContainerView = (LinearLayout) mRootView.findViewById(ParentalLockLayoutGenerator.EQUATION_VIEW_CONTAINER_ID);
        mEquationTextView = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.EQUATION_TEXT_VIEW_ID);

        mResTextView1 = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_1_TEXT_VIEW_ID);
        mResTextView1.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener()
                {
                    @Override
                    public void onClickFinished()
                    {
                        checkResolutionResult(0);
                    }
                });
            }
        });
        mResTextView2 = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_2_TEXT_VIEW_ID);
        mResTextView2.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener()
                {
                    @Override
                    public void onClickFinished()
                    {
                        checkResolutionResult(1);
                    }
                });
            }
        });
        mResTextView3 = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_3_TEXT_VIEW_ID);
        mResTextView3.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener()
                {
                    @Override
                    public void onClickFinished()
                    {
                        checkResolutionResult(2);
                    }
                });
            }
        });
        mResTextView4 = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_4_TEXT_VIEW_ID);
        mResTextView4.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener()
                {
                    @Override
                    public void onClickFinished()
                    {
                        checkResolutionResult(3);
                    }
                });
            }
        });
    }

    private void checkResolutionResult(int index)
    {
        try
        {
            if (index == mRightResultIndex)
            {
                mIsLockChangeSuccessfully = true;
                if (mIsGateToGooglePlay == true)
                {
                    closeParentalDialog();
                } else
                {
                    if (mIsLockActive == true)
                    {
                        saveParentalLockState(getContext(), false);
                        //SharedPreferencesUtils.removeSharedPreferencesData(getContext(), PARENTAL_LOCK_ACTIVE_KEY);
                    } else
                    {
                        saveParentalLockState(getContext(), true);
                        //SharedPreferencesUtils.saveSharedPreferencesData(getContext(), PARENTAL_LOCK_ACTIVE_KEY, PARENTAL_LOCK_ACTIVE_KEY);
                    }
                    animateFeedBackMessageSuccess(mIsLockActive);
                    if (mParentLockDialogListener != null)
                    {
                        mParentLockDialogListener.onPasswordEntered(true);
                        EventManager.getInstance(getContext()).LogEventWithIntField(getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_CORRECT_PASSWORD, null, mCounter);
                    }
                }
                if (mParentLockDialogListener != null)
                {
                    mParentLockDialogListener.onPasswordEntered(true);
                    mCounter += 1;
                    EventManager.getInstance(getContext()).LogEventWithIntField(getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_CORRECT_PASSWORD, null, mCounter);
                }
            } else
            {
                animateFeedBackMessageError();
            }
        } catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to handle lock icon click: " + ex.getMessage());
        }
    }

    private void generateQuestionAnswerSequence()
    {
        int[] temp = new int[20];
        int[] mResults = new int[4];
        int firstNum = random.nextInt(9);
        int secondNum = random.nextInt(9);

        mRightResultIndex = random.nextInt(3);
        mResults[mRightResultIndex] = firstNum + secondNum;
        for (int i = 0; i < mResults.length; i++)
        {
            if (i != mRightResultIndex)
            {
                do
                {
                    mResults[i] = random.nextInt(19);
                } while (temp[mResults[i]] != 0 || mResults[i] == mResults[mRightResultIndex]);
                temp[mResults[i]] = 1;
            }
        }

        mEquationTextView.setText("" + firstNum + " + " + secondNum + " = ?");

        for (int i = 0; i < mResults.length; i++)
        {
            switch (i)
            {
                case 0:
                {
                    mResTextView1.setText("" + mResults[0]);
                    break;
                }

                case 1:
                {
                    mResTextView2.setText("" + mResults[1]);
                    break;
                }

                case 2:
                {
                    mResTextView3.setText("" + mResults[2]);
                    break;
                }

                case 3:
                {
                    mResTextView4.setText("" + mResults[3]);
                    break;
                }
            }
        }
    }

    @Override
    protected void onStart()
    {
        super.onStart();
    }

    // @Override
    public void show()
    {
        super.openDialog();
        EventManager.getInstance(getContext()).LogEventWithIntField(getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_DIALOG_SHOW, null, mCounter);
        mAnimatableView.setVisibility(View.VISIBLE);
        Utils.setOnGlobalLayoutFinishListener(mAnimatableView, new Utils.OnGlobalLayoutFinishedListener()
        {
            @Override
            public void onLayoutFinished()
            {
                if (mPopLocation != null)
                {
                    GenAnimator.playPopInFromRightTop(mAnimatableView, mPopLocation, new Animator.AnimatorListener()
                    {
                        @Override
                        public void onAnimationStart(Animator animation)
                        {
                            mAnimatableView.setVisibility(View.VISIBLE);
                        }

                        @Override
                        public void onAnimationEnd(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationCancel(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationRepeat(Animator animation)
                        {
                        }
                    });
                } else
                {
                    mAnimatableView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    // @Override
    public void closeParentalDialog()
    {
        mHandler.removeCallbacksAndMessages(null);
        if (mParentLockDialogListener != null)
        {
            mParentLockDialogListener.onPasswordEntered(false);
        }
        EventManager.getInstance(mCallingActivity).LogEventWithIntField(mCallingActivity, null, null, EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_DIALOG_DISMISS, null, mCounter);
        closeDialog();
    }

    @Override
    public void closeDialog()
    {
        try
        {
            WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PARENTAL_DIALOG_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
            EventBus.getDefault().post(eventMessage);
        } catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to send parental dialog close message: " + ex.getMessage());
        }
        super.closeDialog();
    }

    public interface ParentLockDialogListener
    {
        void onPasswordEntered(boolean isPasswordCorrect);
    }

    public void setParentLockDialogListener(ParentLockDialogListener parentLockDialogListener)
    {
        mParentLockDialogListener = parentLockDialogListener;
    }

    private void animateFeedBackMessageError()
    {
        mCounter += 1;
        EventManager.getInstance(getContext()).LogEventWithIntField(getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_INCORRECT_PASSWORD, null, mCounter);
        String tryAgain = StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_WRONG_SELECTION_TRY_AGAIN);
        String wrongSelection = StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_WRONG_SELECTION);
        SpannableString messageTextError = new SpannableString(wrongSelection);
        SpannableString messageActionTryAgain = new SpannableString(tryAgain);
        messageActionTryAgain.setSpan(new StyleSpan(Typeface.BOLD), 0, messageActionTryAgain.length(), 0);

        mFeedbackMessage.setText(messageTextError);
        mFeedbackMessageAction.setText(messageActionTryAgain);

        mFeedbackMessageContainer.setVisibility(View.VISIBLE);
        mEquationContainerView.setVisibility(View.INVISIBLE);
    }

    private void animateFeedBackMessageSuccess(boolean mIsLockActive)
    {
        if (mIsLockActive == true)
        {
            closeParentalDialog();
            SdkToast.getSdkInstance(getContext()).showToast(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_LOCK_DEACTIVATED), Toast.LENGTH_LONG);
        } else
        {
            closeParentalDialog();
            SdkToast.getSdkInstance(getContext()).showToast(StringAssetsUtils.getLangString(getContext(), StringAssetsUtils.PLD_TITLE_LOCK_ACTIVATED), Toast.LENGTH_LONG);
        }

        mFeedbackMessageContainer.setVisibility(View.VISIBLE);
        mInnerViewContainer.setVisibility(View.INVISIBLE);
    }

    private void animateFeedBackMessageBack()
    {
        mFeedbackMessageContainer.setVisibility(View.INVISIBLE);
        mEquationContainerView.setVisibility(View.VISIBLE);
    }

    public interface IOnParentalDialogListener
    {
        void onCloseDialog();

        void onInputPass(boolean isCorrectPass);
    }

    public static ParentalLockDialog startParentalDialog(Context context, boolean isGateToGooglePaly, float showLocationX, float showLocationY, final IOnParentalDialogListener listener)
    {
        int[] popLocation = new int[2];
        popLocation[0] = (int) (ScreenUtils.getScreenSize(context, true) * showLocationX);
        popLocation[1] = (int) (ScreenUtils.getScreenSize(context, false) * showLocationY);
        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, isGateToGooglePaly, popLocation);
        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener()
        {
            @Override
            public void onDismiss(DialogInterface dialog)
            {
                listener.onCloseDialog();
            }
        });
        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
        {
            @Override
            public void onPasswordEntered(boolean isPasswordCorrect)
            {
                listener.onInputPass(isPasswordCorrect);
            }
        });
        parentalLockDialog.show();
        return parentalLockDialog;
    }

    /**
     * Check if parental lock is active
     */
    public static boolean isParentalLockActive(Context context)
    {
        return SharedPreferencesUtils.loadBooleanSharedPreferencesData(context, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY);
    }

    /**
     * Save parental lock state
     */
    public static void saveParentalLockState(Context context, boolean active)
    {
        SharedPreferencesUtils.saveBooleanSharedPreferencesData(context, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY, active);
    }

    /**
     * Check if initial lock state have changed
     */
    public static boolean isLockStateChanged(Context context)
    {
        return SharedPreferencesUtils.hasBooleanSharedPreferencesData(context, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY);
    }
}
