package com.kidoz.events;

import android.content.Context;
import android.os.AsyncTask;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;

import java.lang.ref.WeakReference;

public class EventSyncAsyncTask extends AsyncTask<EventBulk, Void, Void>
{
    WeakReference<Context> weakActivity = null;

    public EventSyncAsyncTask(Context context)
    {
        weakActivity = new WeakReference<>(context);
    }

    @Override
    protected Void doInBackground(EventBulk... params)
    {
        try
        {
            SDKLogger.printWarningLog(" ----------------------  ********************* ----------------------");
            SDKLogger.printWarningLog(" -----------------    START EVENTS SYNCING THREAD ---------------------");
            SDKLogger.printWarningLog(" ----------------------  ******************** ----------------------");
            if (weakActivity != null)
            {
                Context mContext = weakActivity.get();

                if (mContext != null && params != null && params.length > 0)
                {
                    EventBulk bulk = params[0];
                    if (bulk != null)
                    {
                        String json = bulk.toString();
                        SDKLogger.printWarningLog("Log Events Sync info : bulk value:" + json);
                        if (json != null)
                        {
                            SdkAPIManager.getSdkApiInstance(mContext).sendKidozEventsToServerNotAsync(json);
                        }
                    }
                }
            }
        } catch (Exception e)
        {

        }

        if (weakActivity != null)
        {
            weakActivity.clear();
        }
        return null;
    }
}
