/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.web_unit_view;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class ConfigurationView
extends View {
    private final String TAG = ConfigurationView.class.getSimpleName();
    private ConfigurationViewInterface mConfigurationViewInterface;

    public ConfigurationView(Context context, ConfigurationViewInterface configurationViewInterface) {
        super(context);
        this.mConfigurationViewInterface = configurationViewInterface;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mConfigurationViewInterface != null) {
            this.mConfigurationViewInterface.onViewVisibilityChanged(false);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        SDKLogger.printDebbugLog(this.TAG, "*** onConfigurationChanged ***");
        if (newConfig.orientation == 2) {
            SDKLogger.printDebbugLog(this.TAG, "New configuration: LANDSCAPE");
        } else {
            SDKLogger.printDebbugLog(this.TAG, "New configuration: PORTRAIT");
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        SDKLogger.printDebbugLog(this.TAG, "*** onWindowFocusChanged ***");
        SDKLogger.printDebbugLog(this.TAG, "Has window focus = " + Boolean.toString(hasWindowFocus));
        if (this.mConfigurationViewInterface != null) {
            this.mConfigurationViewInterface.onViewVisibilityChanged(hasWindowFocus);
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        SDKLogger.printDebbugLog(this.TAG, "*** onVisibilityChanged ***");
        SDKLogger.printDebbugLog(this.TAG, "Visibility = " + String.valueOf(visibility));
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        SDKLogger.printDebbugLog(this.TAG, "*** onWindowVisibilityChanged ***");
        SDKLogger.printDebbugLog(this.TAG, "Visibility = " + String.valueOf(visibility));
    }

    public static interface ConfigurationViewInterface {
        public void onViewVisibilityChanged(boolean var1);
    }
}

