/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.video_unit;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebChromeClient;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnit;
import org.json.JSONObject;

public class VideoUnitActivity
extends Activity {
    public static final String VIDEO_UNIT_ACTION_BUTTON_TAG = "VIDEO_UNIT_ACTION_BUTTON_TAG";
    public static final String VIDEO_UNIT_URL_TAG = "VIDEO_UNIT_URL_TAG";
    private final String TAG = VideoUnitActivity.class.getSimpleName();
    public static FullScreenVideoEnabledWebView mWebView;
    public static VideoUnit.VideoUnitListener sVideoUnitListener;
    private BroadcastReceiver mBroadcastReceiver;
    private boolean mIsAlreadyLoaded = false;
    private int mDeviceOrientation;

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDeviceOrientation = this.getRequestedOrientation();
        this.initActivity();
        if (mWebView != null) {
            this.setContentView((View)mWebView, new ViewGroup.LayoutParams(-1, -1));
            this.invokeJavaScript("javascript:onWidgetOpen();");
            if (sVideoUnitListener != null && sVideoUnitListener != null) {
                sVideoUnitListener.onOpen();
            }
        } else {
            this.finish();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.invokeJavaScript("javascript:onWidgetClose();");
        if (sVideoUnitListener != null && sVideoUnitListener != null) {
            sVideoUnitListener.onClose();
        }
        mWebView = null;
        sVideoUnitListener = null;
    }

    protected void onStop() {
        super.onStop();
        this.setRequestedOrientation(this.mDeviceOrientation);
        EventManager.getInstance((Context)this).startEventsSync((Context)this, 250);
    }

    protected void onResume() {
        super.onResume();
        this.initFullScreenFlags();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mBroadcastReceiver, new IntentFilter("WebPlayerDialogClosed"));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mBroadcastReceiver, new IntentFilter("CloseVideoUnit"));
        if (mWebView != null) {
            mWebView.bringToFront();
        }
        this.invokeJavaScript("javascript:onWidgetResume();");
    }

    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mBroadcastReceiver);
        this.invokeJavaScript("javascript:onWidgetPause();");
    }

    private void initActivity() {
        if (this.getIntent() != null) {
            this.mIsAlreadyLoaded = this.getIntent().getBooleanExtra("isLoaded", false);
        }
        this.initFullScreenFlags();
        this.initWebView();
        this.initBroadcastReceiver();
    }

    private void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int itemIndexAsInteger = 0;
                try {
                    itemIndexAsInteger = Integer.parseInt(itemIndex);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(VideoUnitActivity.this.TAG, "Error when trying to parse item index: " + ex.getMessage());
                }
                ContentItem contentItem = new ContentItem();
                contentItem.setId(appID);
                contentItem.setName("");
                contentItem.setData(googlePlayLink);
                contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                contentItem.setAdvertiserID(advertiserID);
                contentItem.setIsPromoted(true);
                ContentExecutionHandler.handleContentItemClick((Context)VideoUnitActivity.this, contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
            }
        });
    }

    private void initWebView() {
        if (mWebView != null) {
            if (mWebView.getParent() != null) {
                ((ViewGroup)mWebView.getParent()).removeView((View)mWebView);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                FullScreenVideoEnabledWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
            }
        }
        if (!this.mIsAlreadyLoaded) {
            this.initWebViewSettings();
            VideoUnit.misLoaded = true;
        }
    }

    private void initWebViewSettings() {
        PropertiesObj propertiesObj;
        if (mWebView != null) {
            mWebView.initWebViewSettings();
            mWebView.addJavascriptInterface(new VideoUnitJavascriptInterface(), "VideoUnit");
        }
        if ((propertiesObj = DatabaseManager.getInstance((Context)this).getConfigTable().loadAppProperties()) != null) {
            String videoUnitURL = propertiesObj.getVideoUnitURL();
            StringBuilder stringBuilder = HtmlViewWrapper.populateMustHaveParams((Context)this, videoUnitURL);
            stringBuilder.append("&style_id=0");
            stringBuilder.append("&widget_type=").append(WidgetType.WIDGET_TYPE_VIDEO_UNIT.getStringValue());
            SharedPreferences sharedPreferences = this.getSharedPreferences("events_shared_preferences", 0);
            long appSessionID = sharedPreferences.getLong("last_session_id", 0L);
            stringBuilder.append("&appSessionID=").append(appSessionID);
            if (mWebView != null) {
                mWebView.setWebViewClient(new WebViewClient(){

                    public boolean shouldOverrideUrlLoading(WebView view, String url) {
                        SDKLogger.printDebbugLog(VideoUnitActivity.this.TAG, "shouldOverrideUrlLoading: URL = " + url);
                        if (!url.contains("youtube")) {
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.setData(Uri.parse((String)url));
                            VideoUnitActivity.this.startActivity(intent);
                        }
                        return true;
                    }

                    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                        EventManager.getInstance((Context)VideoUnitActivity.this).logEvent((Context)VideoUnitActivity.this, WidgetType.WIDGET_TYPE_VIDEO_UNIT.getStringValue(), "0", EventManager.LOG_CRITICAL_LEVEL, "WebView Error", String.valueOf(errorCode).concat(": ").concat(description), failingUrl);
                        EventManager.getInstance((Context)VideoUnitActivity.this).startEventsSync((Context)VideoUnitActivity.this);
                    }
                });
                FullScreenVideoEnabledWebChromeClient webChromeClient = new FullScreenVideoEnabledWebChromeClient(null, null, null, mWebView){};
                webChromeClient.setOnToggledFullscreen(new FullScreenVideoEnabledWebChromeClient.ToggledFullscreenCallback(){

                    @Override
                    public void toggledFullscreen(boolean fullscreen) {
                    }
                });
                mWebView.setWebChromeClient(webChromeClient);
                mWebView.loadUrl(stringBuilder.toString());
            }
        }
    }

    private void initBroadcastReceiver() {
        this.mBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null) {
                    if (intent.getAction().equals("WebPlayerDialogClosed")) {
                        if (mWebView != null) {
                            mWebView.bringToFront();
                        }
                        VideoUnitActivity.this.invokeJavaScript("javascript:onWidgetResume();");
                    } else if (intent.getAction().equals("CloseVideoUnit")) {
                        VideoUnitActivity.this.finish();
                    }
                }
            }
        };
    }

    private void initFullScreenFlags() {
        if (Build.VERSION.SDK_INT < 16) {
            this.getWindow().setFlags(1024, 1024);
        } else if (Build.VERSION.SDK_INT < 18) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 4;
            decorView.setSystemUiVisibility(uiOptions);
        } else {
            final View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
            decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if ((visibility & 4) == 0) {
                        decorView.setSystemUiVisibility(5894);
                    }
                }
            });
        }
    }

    private void invokeJavaScript(final String javascript) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (mWebView != null) {
                    if (Build.VERSION.SDK_INT >= 19) {
                        mWebView.evaluateJavascript(javascript, null);
                    } else {
                        mWebView.loadUrl(javascript);
                    }
                }
            }
        });
    }

    public static void parseVideoUnitStyle(final Context context, final JSONObject json) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    VideoUnitActivity.updateVideoUnitButton(context, json);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    private static void updateVideoUnitButton(Context context, JSONObject json) {
        String actionButtonURL = null;
        if (json != null) {
            try {
                JSONObject videoUnitStyle = json.getJSONObject("videoUnitStyle");
                JSONObject videoUnit = videoUnitStyle.getJSONObject("videoUnit");
                actionButtonURL = videoUnit.getString("action_button_url");
            }
            catch (Exception videoUnitStyle) {
                // empty catch block
            }
            if (actionButtonURL != null) {
                boolean isNeedUpdate = false;
                boolean isNeedRefresh = false;
                JSONObject jsonObject = DatabaseManager.getInstance(context).getConfigTable().loadProperties(VIDEO_UNIT_ACTION_BUTTON_TAG);
                if (jsonObject != null) {
                    try {
                        String oldActionButtonURL = jsonObject.getString(VIDEO_UNIT_ACTION_BUTTON_TAG);
                        if (oldActionButtonURL != null && !oldActionButtonURL.equals(actionButtonURL)) {
                            isNeedUpdate = true;
                            AssetUtil.deleteAssetFile2(context, oldActionButtonURL);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    isNeedUpdate = true;
                    isNeedRefresh = true;
                }
                if (isNeedUpdate) {
                    AssetUtil.createAssetFile2(context, actionButtonURL);
                    jsonObject = new JSONObject();
                    try {
                        jsonObject.put(VIDEO_UNIT_ACTION_BUTTON_TAG, (Object)actionButtonURL);
                        DatabaseManager.getInstance(context).getConfigTable().insertProperties(VIDEO_UNIT_ACTION_BUTTON_TAG, jsonObject);
                        if (isNeedRefresh) {
                            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent(EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY.name()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class VideoUnitJavascriptInterface {
        @JavascriptInterface
        public void onVideoUnitReady() {
        }

        @JavascriptInterface
        public void onCloseVideoUnit() {
            VideoUnitActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent();
                    intent.setAction("CloseVideoUnit");
                    LocalBroadcastManager.getInstance((Context)VideoUnitActivity.this).sendBroadcast(intent);
                }
            });
        }

        @JavascriptInterface
        public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
            VideoUnitActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VideoUnitActivity.this.forwardToGooglePlay(advertiserID, appID, googlePlayLink, widgetType, styleID, itemIndex);
                }
            });
        }

        @JavascriptInterface
        public void setOrientation(final int orientation) {
            VideoUnitActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VideoUnitActivity.this.setRequestedOrientation(orientation);
                }
            });
        }
    }
}

