/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.os.Build;
import com.kidoz.events.EventBulk;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.EncoderUtils;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.BaseAPIManager;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkRequestType;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import com.kidoz.sdk.api.structure.ContentData;
import java.io.BufferedInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import okhttp3.Call;
import okhttp3.Response;

public class SdkAPIManager
extends BaseAPIManager {
    private static final String TAG = SdkAPIManager.class.getName();
    private String mPackageName;
    private boolean mDeveloperLogging;
    private String mCalculatedDeviceHash = null;
    private static SdkAPIManager mSdkInstnace;
    private static final String JSON = "JSON";
    private static final String REQUEST_FORMAT = "resFormat";
    private static final String GET_CONTENT = "getContent";
    private static final String INIT_SDK_CONFIGURATION = "initSDK";
    private static final String SEND_KIDOZ_EVENTS_TO_SERVER = "SendKidozEventsToServer";
    public static final String METHOD_NAME = "method_name";

    public static SdkAPIManager getSdkApiInstance(Context context) {
        if (mSdkInstnace == null) {
            mSdkInstnace = new SdkAPIManager(context);
        }
        return mSdkInstnace;
    }

    public static void init(Context context, String pId, String sKey, boolean developerLogging) {
        SdkAPIManager.getSdkApiInstance(context).setProperties(pId, sKey, developerLogging);
    }

    public SdkAPIManager(Context context) {
        SdkAPIManager.initConnectionClient();
        this.mPackageName = context.getPackageName();
    }

    private void setProperties(String pId, String sKey, boolean developerLogging) {
        mPublicherId = pId;
        mSecurityToken = sKey;
        this.mDeveloperLogging = developerLogging;
    }

    public void loadContent(Context context, String styleId, String widgetType, ApiResultCallback<ContentData> resultCallback) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(METHOD_NAME, GET_CONTENT);
        this.setGeneralParams(context, contentValues);
        contentValues.put("style_id", styleId);
        contentValues.put("widget_type", widgetType);
        long ts = System.currentTimeMillis() / 1000L;
        contentValues.put("ts", Long.valueOf(ts));
        contentValues.put("hash", this.generateRequestHash(contentValues, ts, mSecurityToken));
        this.startServerConnection(context, DOMAIN + MAIN_API, BaseConnectionClient.CONNECTION_TYPE.GET, SdkRequestType.LOAD_SDK_CONTENT, contentValues, 1, resultCallback, this.mDeveloperLogging, false);
    }

    public void initSdk(Context context, ApiResultCallback<PropertiesObj> resultCallback) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(METHOD_NAME, INIT_SDK_CONFIGURATION);
        this.setGeneralParams(context, contentValues);
        try {
            this.startServerConnection(context, SDK_API_URL + INIT_SDK_CONFIGURATION, BaseConnectionClient.CONNECTION_TYPE.GET, SdkRequestType.VALIDATE_SDK, contentValues, 1, resultCallback, this.mDeveloperLogging, false);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to validateSDK: " + ex.getMessage());
            resultCallback.onFailed();
        }
    }

    public void setGeneralParams(Context context, ContentValues contentValues) {
        String[] tempVal;
        int index;
        String sub;
        String[] res;
        contentValues.put("publisher_id", mPublicherId);
        contentValues.put("package_id", this.mPackageName);
        contentValues.put("device_lang", Locale.getDefault().getLanguage());
        contentValues.put("device_hash", this.getDeviceHash());
        String addId = SdkDeviceUtils.getGoogleAdvertisingID(context);
        if (addId == null) {
            addId = "";
        }
        contentValues.put("google_id", addId);
        contentValues.put("device_type", ScreenUtils.getIsTablet(context) ? "2" : "1");
        contentValues.put("version", "4");
        contentValues.put("sdk_version", "4");
        contentValues.put("actual_sdk_version", "0.7.2");
        contentValues.put("os_type", "android");
        contentValues.put("os_version", String.valueOf(Build.VERSION.SDK_INT));
        contentValues.put("extension_type", Integer.valueOf(ConstantDef.SDK_EXTENSION_TYPE));
        String webviewVersion = "w";
        String useragent = Utils.getDefaultUserAgent();
        if (useragent != null && useragent.contains("Chrome") && (res = (sub = useragent.substring(index = useragent.indexOf("Chrome"), useragent.length())).split(" ")) != null && res.length > 0 && (tempVal = res[0].split("/")) != null && tempVal.length > 1) {
            webviewVersion = "c_" + tempVal[1];
        }
        contentValues.put("webview_version", webviewVersion);
        try {
            Point point = ScreenUtils.getScreenSize(context);
            contentValues.put("resolution_height", Integer.valueOf(point.y));
            contentValues.put("resolution_width", Integer.valueOf(point.x));
            contentValues.put("screen_size", Double.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
            contentValues.put("dpi", Float.valueOf(context.getResources().getDisplayMetrics().density));
            contentValues.put("screen_category", Integer.valueOf(context.getResources().getConfiguration().screenLayout & 0xF));
        }
        catch (Exception point) {
            // empty catch block
        }
        String appVersionCode = "";
        String appVersionName = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            appVersionCode = String.valueOf(packageInfo.versionCode);
            appVersionName = packageInfo.versionName;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to get app version name and code: " + ex.getMessage());
        }
        contentValues.put("app_version_code", appVersionCode);
        contentValues.put("app_version_name", appVersionName);
    }

    public ResultData<Boolean> sendKidozEventsToServerNotAsync(String eventsJsonBulk) {
        ResultData<Boolean> resultCallback;
        block8: {
            ContentValues contentValues = new ContentValues();
            contentValues.put("methodName", SEND_KIDOZ_EVENTS_TO_SERVER);
            String encodedString = eventsJsonBulk;
            try {
                encodedString = URLEncoder.encode(eventsJsonBulk, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            contentValues.put("KidozEventsLogAsJson", encodedString);
            contentValues.put(REQUEST_FORMAT, JSON);
            resultCallback = null;
            Call call = null;
            try {
                call = BaseConnectionClient.makePostConnection(KIDOZ_ANALITYCS_SERVER_URL, contentValues, "analyticsRequest");
                if (call == null) break block8;
                SDKLogger.printDebbugLog("|KIDOZ SDK| **[REQUEST]** API : [POST],  [SEND_EVENT_ANALYTYCS]");
                Response response = call.execute();
                if (response == null) break block8;
                if (response.isSuccessful()) {
                    SDKLogger.printDebbugLog("|KIDOZ SDK| **[RESPONSE SUCCESS]** API : [POST],  [SEND_EVENT_ANALYTICS]");
                    try {
                        String responce = StreamToStringConverter.readStream(new BufferedInputStream(response.body().byteStream()), null, false);
                        if (responce != null) {
                            resultCallback = EventBulk.parseResultSuccsesStatus(responce);
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        SDKLogger.printErrorLog(" \n Unable to convertByte Stream to String! [ Kidoz Analytics Data Sent ]  : \n\n" + e.getMessage());
                    }
                    break block8;
                }
                SDKLogger.printErrorLog(" \n Server connectivity Error! [ Kidoz Analytics Data Sent ]  Code : " + response.code());
            }
            catch (Exception e) {
                SDKLogger.printErrorLog(" \n IO Exception On [ Kidoz Analytics Data Sent ] \n " + e.getMessage());
            }
        }
        return resultCallback;
    }

    private String generateRequestHash(ContentValues contentValues, long ts, String token) {
        Set set = contentValues.keySet();
        ArrayList list = new ArrayList();
        list.addAll(set);
        Collections.sort(list);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(contentValues.getAsString((String)list.get(i)));
        }
        stringBuilder.append(ts);
        stringBuilder.append(token);
        return EncoderUtils.SHA1(stringBuilder.toString());
    }

    private String getDeviceHash() {
        if (this.mCalculatedDeviceHash == null) {
            this.mCalculatedDeviceHash = Utils.generateUniqeDeviceID(this.mPackageName, mPublicherId);
        }
        return this.mCalculatedDeviceHash;
    }

    public void getCountryCode(Context context, ApiResultCallback<String> apiResultCallback) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("key", "Xg4VFb!7P%24_p87Eq%2B7-t%26X%3DVPHw3P%26yL");
        this.startServerConnection(context, "http://accounts.kidoz.net/api/cc", BaseConnectionClient.CONNECTION_TYPE.POST, SdkRequestType.GET_COUNTRY_CODE, contentValues, 0, apiResultCallback, this.mDeveloperLogging, false);
    }
}

