/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.kidoz.sdk.api.general.utils.Utils;

public class SdkToast {
    private static SdkToast mInstance;
    private Context mContext;
    private Toast mToast;
    private TextView mTextView;

    private SdkToast(Context context) {
        this.mContext = context;
        this.initToast(this.mContext);
    }

    public static SdkToast getSdkInstance(Context context) {
        if (mInstance == null) {
            mInstance = new SdkToast(context);
        }
        return mInstance;
    }

    private void initToast(Context mContext) {
        this.mToast = new Toast(mContext);
        this.mToast.setView(this.generateToastLayout(mContext));
    }

    private View generateToastLayout(Context context) {
        LinearLayout container = new LinearLayout(context);
        container.setGravity(17);
        this.mTextView = new TextView(context);
        this.mTextView.setGravity(17);
        this.mTextView.setTypeface(Typeface.DEFAULT_BOLD);
        this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTextView.setTextColor(-1);
        this.mTextView.setTextSize(2, 17.0f);
        this.mTextView.setMinLines(2);
        int padding = Utils.dpTOpx(this.mContext, 12.0f);
        this.mTextView.setPadding(padding, padding, padding, padding);
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(Color.parseColor((String)"#ee39b0c6"));
        gradientDrawable.setStroke(Utils.spTOpx(this.mContext, 1.0f), Color.parseColor((String)"#ffffff"));
        gradientDrawable.setCornerRadius((float)Utils.dpTOpx(this.mContext, 15.0f));
        if (Build.VERSION.SDK_INT >= 16) {
            this.mTextView.setBackground((Drawable)gradientDrawable);
        } else {
            this.mTextView.setBackgroundDrawable((Drawable)gradientDrawable);
        }
        container.addView((View)this.mTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        return container;
    }

    public void showToast(String text, int duration) {
        this.mTextView.setText((CharSequence)text);
        this.mToast.setDuration(duration);
        this.mToast.show();
    }
}

