/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import com.kidoz.sdk.api.ui_views.interstitial.BaseInterstitial;
import com.kidoz.sdk.api.ui_views.interstitial.IntrstWrapper;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class KidozInterstitial
extends BaseInterstitial {
    public static final String TAG = KidozInterstitial.class.getSimpleName();
    public static final EventSignObj mEventObj = new EventSignObj();

    public KidozInterstitial(Context context) {
        this.initInnerWrapper(context);
        this.setRequestType();
        if (!EventBus.getDefault().isRegistered((Object)mEventObj)) {
            EventBus.getDefault().register((Object)mEventObj);
        }
    }

    protected void initInnerWrapper(Context context) {
        this.mInterstitialView = IntrstWrapper.initInstance(context);
    }

    protected void setRequestType() {
        this.mInterstitialView.setIsLocalRequest(false);
    }

    public synchronized void show() {
        if (this.mInterstitialView != null) {
            this.mInterstitialView.show();
        }
    }

    @Deprecated
    public synchronized void loadAd() {
        this.mInterstitialView.setIsLocalRequest(false);
        if (this.mInterstitialView != null) {
            this.mInterstitialView.load(AD_TYPE.INTERSTITIAL);
        }
    }

    public synchronized void loadAd(AD_TYPE ad_type) {
        this.mInterstitialView.setIsLocalRequest(false);
        if (this.mInterstitialView != null) {
            this.mInterstitialView.load(ad_type);
        }
    }

    public boolean isLoaded() {
        if (this.mInterstitialView != null) {
            return this.mInterstitialView.isInterstitialLoaded();
        }
        return false;
    }

    public void setOnInterstitialEventListener(BaseInterstitial.IOnInterstitialEventListener listener) {
        mEventObj.setOnListener(listener);
    }

    public void setOnInterstitialRewardedEventListener(BaseInterstitial.IOnInterstitialRewardedEventListener listener) {
        mEventObj.setOnRewardedListener(listener);
    }

    private static final class EventSignObj {
        protected BaseInterstitial.IOnInterstitialEventListener eventListener;
        protected BaseInterstitial.IOnInterstitialRewardedEventListener eventRewardedListener;

        private EventSignObj() {
        }

        @Subscribe
        public void onHandleEvent(IntrstWrapper.InterstitialEvents event) {
            if (this.eventListener != null) {
                switch (event) {
                    case CLOSED: {
                        this.eventListener.onClosed();
                        break;
                    }
                    case OPENED: {
                        this.eventListener.onOpened();
                        break;
                    }
                    case READY: {
                        this.eventListener.onReady();
                        break;
                    }
                    case LOAD_FAILED: {
                        this.eventListener.onLoadFailed();
                    }
                }
            }
            if (this.eventRewardedListener != null) {
                switch (event) {
                    case REWARDED: {
                        this.eventRewardedListener.onRewarded();
                        break;
                    }
                    case REWARDED_VIDEO_STARTED: {
                        this.eventRewardedListener.onRewardedVideoStarted();
                    }
                }
            }
        }

        public void setOnListener(BaseInterstitial.IOnInterstitialEventListener listener) {
            this.eventListener = listener;
        }

        public void setOnRewardedListener(BaseInterstitial.IOnInterstitialRewardedEventListener listener) {
            this.eventRewardedListener = listener;
        }
    }

    public static enum AD_TYPE {
        INTERSTITIAL(0),
        REWARDED_VIDEO(1);

        private int value;

        private AD_TYPE(int Value) {
            this.value = Value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

